//
//  ICRPlaceholderTextView.m
//  Cruiser
//
//  Created by Lili Wang on 15/4/7.
//  Copyright (c) 2015年 Xummer. All rights reserved.
//

#import "ICRPlaceholderTextView.h"

@interface ICRPlaceholderTextView ()

@property (unsafe_unretained, nonatomic, readonly) NSString* realText;

- (void) beginEditing:(NSNotification*) notification;
- (void) endEditing:(NSNotification*) notification;

@end

@implementation ICRPlaceholderTextView

@synthesize m_placeholderColor;
@synthesize m_placeHolder;
@synthesize m_realTextColor;

- (id)initWithFrame:(CGRect)frame {
    self = [super initWithFrame:frame];
    if (self) {
        [self initObserver];
        
    }
    return self;
}

- (void)awakeFromNib {
    [super awakeFromNib];
    [self initObserver];
}

- (void)initObserver {
    [[NSNotificationCenter defaultCenter] addObserver:self
                                             selector:@selector(beginEditing:)
                                                 name:UITextViewTextDidBeginEditingNotification
                                               object:self];
    [[NSNotificationCenter defaultCenter] addObserver:self
                                             selector:@selector(endEditing:)
                                                 name:UITextViewTextDidEndEditingNotification
                                               object:self];
    
    self.m_realTextColor = self.textColor;
    self.m_placeholderColor = [UIColor lightGrayColor];
}

#pragma mark -
#pragma mark Setter/Getters 
- (NSString *)realText {
    return [super text];
}

- (void)setTextColor:(UIColor *)textColor {
    if ([self.realText isEqualToString:self.m_placeHolder]) {
        if ([textColor isEqual:self.m_placeholderColor]){
            [super setTextColor:textColor];
        } else {
            self.m_realTextColor = textColor;
        }
    }
    else {
        self.m_realTextColor = textColor;
        [super setTextColor:textColor];
    }
}

- (void)setM_placeHolder:(NSString *)am_placeHolder {
    if ([self.realText isEqualToString:self.m_placeHolder] && ![self isFirstResponder]) {
        self.text = am_placeHolder;
    }
    if (am_placeHolder != self.m_placeHolder) {
        m_placeHolder = am_placeHolder;
    }
    
    
    [self endEditing:nil];
}

- (void)setM_placeholderColor:(UIColor *)am_placeholderColor {
    m_placeholderColor = am_placeholderColor;
    
    if ([super.text isEqualToString:self.m_placeHolder]) {
        self.textColor = self.m_placeholderColor;
    }
}

- (NSString *)text {
    NSString* text = [super text];
    if ([text isEqualToString:self.m_placeHolder]) return @"";
    return text;
}

- (void) setText:(NSString *)text {
    if (([text isEqualToString:@""] || text == nil) && ![self isFirstResponder]) {
        super.text = self.m_placeHolder;
    }
    else {
        super.text = text;
    }
    
    if ([text isEqualToString:self.m_placeHolder] || text == nil) {
        self.textColor = self.m_placeholderColor;
    }
    else {
        self.textColor = self.m_realTextColor;
    }
}
#pragma mark -
#pragma mark - Observer Actions

- (void) beginEditing:(NSNotification*) notification {
    if ([self.realText isEqualToString:self.m_placeHolder]) {
        super.text = nil;
        self.textColor = self.m_realTextColor;
    }
}

- (void) endEditing:(NSNotification*) notification {
    if ([self.realText isEqualToString:@""] || self.realText == nil) {
        super.text = self.m_placeHolder;
        self.textColor = self.m_placeholderColor;
    }
}

#pragma mark -
#pragma mark Dealloc

- (void)dealloc {
    
    [[NSNotificationCenter defaultCenter] removeObserver:self];
}
@end
