//
//  NSDate+Formatting.m
//  Lighting
//
//  Created by 曹云霄 on 2016/12/12.
//  Copyright © 2016年 上海勾芒科技有限公司. All rights reserved.
//

#import "NSDate+Formatting.h"

@implementation NSDate (Formatting)



- (NSString *)httpParameterString {
    return [self stringWithFormatter:@"%Y-%m-%d %H:%M:%S"];
}
- (NSString *)yearMonthDayString {
    return [self stringWithFormatter:@"%Y-%m-%d"];
}
- (NSString *)yearMonthString {
    return [self stringWithFormatter:@"%Y-%m"];
}
- (NSString *)yearString {
    NSString *strDate = [self yearMonthDayString];
    NSArray *arrDate = [strDate componentsSeparatedByString:@"-"];
    return arrDate[0];
}
- (NSString *)monthString {
    NSString *strDate = [self yearMonthDayString];
    NSArray *arrDate = [strDate componentsSeparatedByString:@"-"];
    return arrDate[1];
}
- (NSString *)dayString{
    NSString *strDate = [self yearMonthDayString];
    NSArray *arrDate = [strDate componentsSeparatedByString:@"-"];
    return arrDate[2];
}

+ (NSString *)stringWithFormatter:(NSString *)dateFormatter andDate:(NSDate *)date {
    if ([dateFormatter length] == 0) {
        return nil;
    }
    
    struct tm *timeinfo;
    char buffer[80];
    
    time_t rawtime = (time_t)[date timeIntervalSince1970];
    timeinfo = gmtime(&rawtime);
    
    strftime(buffer, 80, [dateFormatter UTF8String], timeinfo);
    
    return [NSString stringWithCString:buffer encoding:NSUTF8StringEncoding];
}

- (NSString *)stringWithFormatter:(NSString *)dateFormatter {
    
    if ([dateFormatter length] == 0) {
        return nil;
    }
    
    // Change to Local time zone
    NSTimeZone *zone = [NSTimeZone systemTimeZone];
    NSInteger interval = [zone secondsFromGMTForDate:self];
    NSDate *localDate = [self dateByAddingTimeInterval: interval];
    
    return [[self class] stringWithFormatter:dateFormatter andDate:localDate];
}

@end
