//
//  RebateViewController.m
//  Lighting
//
//  Created by 曹云霄 on 16/8/26.
//  Copyright © 2016年 上海勾芒科技有限公司. All rights reserved.
//

#import "RebateViewController.h"
#import "RebateDetailsViewController.h"
#import "WithdrawalTableViewController.h"
#import "CardViewController.h"
#import "CardDetailsViewController.h"
#import "LuckyDrawViewController.h"
#import "LuckyDrawDetailsViewController.h"
#import "PaymentWithdrawalMainViewController.h"
#import "BindingBankCARDViewController.h"

@interface RebateViewController ()

/**
 *  头像
 */
@property (weak, nonatomic) IBOutlet UIImageView *headerImageView;

/**
 *  总资产
 */
@property (weak, nonatomic) IBOutlet UILabel *currentAmountLabel;
/*******************************/
/**
 *  产品返利
 */
@property (weak, nonatomic) IBOutlet UILabel *productRebateAmountLabel;

/**
 *  昨日收益
 */
@property (weak, nonatomic) IBOutlet UILabel *productRebateYesterdayAmountLabel;

/**
 *  历史收益
 */
@property (weak, nonatomic) IBOutlet UILabel *productRebateHistoryAmountLabel;

/**
 *  冻结金额
 */
@property (weak, nonatomic) IBOutlet UILabel *productRebateFreezeAmountLabel;

/**
 提现
 */
@property (weak, nonatomic) IBOutlet UIButton *productRebateButton;

/*******************************/
/**
 *  欧普奖励
 */
@property (weak, nonatomic) IBOutlet UILabel *oppleRewardAmountLabel;

/**
 *  昨日收益
 */
@property (weak, nonatomic) IBOutlet UILabel *oppleRewardYesterdayAmountLabel;

/**
 *  历史收益
 */
@property (weak, nonatomic) IBOutlet UILabel *oppleRewardHistoryAmountLabel;

/**
 *  冻结金额
 */
@property (weak, nonatomic) IBOutlet UILabel *oppleRewardFreezeAmountLabel;

/**
 提现
 */
@property (weak, nonatomic) IBOutlet UIButton *oppleRewardButton;

/*******************************/

/**
 *  我的卡劵包
 */
@property (weak, nonatomic) IBOutlet UIView *cardBackgroundView;

/**
 *  我的抽奖
 */
@property (weak, nonatomic) IBOutlet UIView *drawBackgroundView;

/**
 返利数据
 */
@property (nonatomic,strong) EarningsResponse *resultEntity;


@end

//欧普奖励
NSString *const commission = @"commission";
//红包
NSString *const redPackage = @"redPackage";


@implementation RebateViewController

- (void)viewDidAppear:(BOOL)animated
{
    [super viewDidAppear:animated];
    [[NSNotificationCenter defaultCenter] postNotificationName:PROMPTDRAWINFORMATION object:@(0)];
    [self getRebateDatasFromUser];
}

- (void)viewDidLoad {
    [super viewDidLoad];
    
    [self setupChildViewController];
    [self uiConfigAction];
}

#pragma mark - UI
- (void)uiConfigAction
{
    [self.headerImageView sd_setImageWithURL:[NSURL URLWithString:[Shoppersmanager manager].Shoppers.employee.picture] placeholderImage:ReplaceImage];
}

#pragma mark - 添加卡劵、抽奖控制器
- (void)setupChildViewController
{
    // 我的卡劵
    CardViewController *cardVc = [[[self class] getMainStoryboardClass] instantiateViewControllerWithIdentifier:@"CardViewController"];
    [self addChildViewController:cardVc];
    [self.cardBackgroundView addSubview:cardVc.view];
    
    // 我的抽奖
    LuckyDrawDetailsViewController *draw = [[[self class] getMainStoryboardClass]instantiateViewControllerWithIdentifier:@"LuckyDrawDetailsViewController"];
    [self addChildViewController:draw];
    draw.drawValue = ZERO;
    [self.drawBackgroundView addSubview:draw.view];
}

#pragma mark - 布局
- (void)viewDidLayoutSubviews
{
    CardViewController *cardVc = self.childViewControllers[0];
    cardVc.view.frame = CGRectMake(10, 40, (self.cardBackgroundView.mj_w-20), self.cardBackgroundView.mj_h-50);

    LuckyDrawDetailsViewController *draw = self.childViewControllers[1];
    draw.view.frame = CGRectMake(10, 40, (self.drawBackgroundView.mj_w-20), self.drawBackgroundView.mj_h-50);
}


#pragma mark - 查询返利信息
- (void)getRebateDatasFromUser
{
    WS(weakSelf);
    [XBLoadingView showHUDViewWithDefault];
    NSString *url = [NSString stringWithFormat:@"%@/%@",REBATE,[Shoppersmanager manager].Shoppers.employee.fid];
    [[NetworkRequestClassManager Manager] NetworkWithDictionaryRequestWithURL:SERVERREQUESTURL(url) WithRequestType:ONE WithParameter:nil WithReturnValueBlock:^(id returnValue) {
        
        [XBLoadingView hideHUDViewWithDefault];
        if ([returnValue[@"code"] isEqualToNumber:@0]) {
            weakSelf.resultEntity = [[EarningsResponse alloc]initWithDictionary:returnValue[@"data"] error:nil];
            [weakSelf setUpRichTextString:weakSelf.resultEntity];
        }else
        {
            [XBLoadingView showHUDViewWithText:returnValue[@"message"]];
        }
        
    } WithFailureBlock:^(NSError *error) {
        [XBLoadingView showHUDViewWithText:error.localizedDescription];
    }];
}

#pragma mark - 设置富文本字符串<赋值>
- (void)setUpRichTextString:(EarningsResponse *)response
{
    //总资产
    NSMutableAttributedString *totalAssets = [[NSMutableAttributedString alloc] initWithString:[NSString stringWithFormat:@"%2f",[response.accountTotal floatValue]+[response.redPackageAccountTotal floatValue]]];
    [totalAssets addAttribute:NSFontAttributeName value:[UIFont systemFontOfSize:20] range:NSMakeRange(totalAssets.length-3, 3)];
    self.currentAmountLabel.attributedText = totalAssets;
    //产品返利
    NSMutableAttributedString *productRebate = [[NSMutableAttributedString alloc] initWithString:[NSString stringWithFormat:@"%.2f",[response.accountTotal floatValue]]];
    [productRebate addAttribute:NSFontAttributeName value:[UIFont systemFontOfSize:20] range:NSMakeRange(productRebate.length-3, 3)];
    self.productRebateAmountLabel.attributedText = productRebate;
    //欧普奖励
    NSMutableAttributedString *oppleReward = [[NSMutableAttributedString alloc] initWithString:[NSString stringWithFormat:@"%.2f",[response.redPackageAccountTotal floatValue]]];
    [oppleReward addAttribute:NSFontAttributeName value:[UIFont systemFontOfSize:20] range:NSMakeRange(oppleReward.length-3, 3)];
    self.oppleRewardAmountLabel.attributedText = oppleReward;
    self.currentAmountLabel.text = [NSString stringWithFormat:@"%.2f",[response.redPackageAccountTotal floatValue] + [response.accountTotal floatValue]];
    self.productRebateAmountLabel.text = [NSString stringWithFormat:@"%.2f",[response.accountTotal floatValue]];
     self.productRebateYesterdayAmountLabel.text = [NSString stringWithFormat:@"昨日收益：%.2f",[response.yesterdayEarnings floatValue]];
     self.productRebateHistoryAmountLabel.text = [NSString stringWithFormat:@"历史收益：%.2f",[response.historyEarning floatValue]];
    self.productRebateFreezeAmountLabel.text = [NSString stringWithFormat:@"冻结金额：%.2f",[response.applytotal floatValue]];
    self.oppleRewardYesterdayAmountLabel.text = [NSString stringWithFormat:@"昨日收益：%.2f",[response.redPackageYesterdayEarnings floatValue]];
    self.oppleRewardHistoryAmountLabel.text = [NSString stringWithFormat:@"历史收益：%.2f",[response.redPackageHistoryEarning floatValue]];
    self.oppleRewardFreezeAmountLabel.text = [NSString stringWithFormat:@"冻结金额：%.2f",[response.redPackageApplytotal floatValue]];
    self.oppleRewardAmountLabel.text = [NSString stringWithFormat:@"%.2f",[response.redPackageAccountTotal floatValue]];
}


#pragma mark - 提现<tag == 100 产品返利><tag == 101 欧普奖励>
- (IBAction)withdrawalButtonClickAction:(UIButton *)sender {

    if (!self.resultEntity.bankCards.count) {
        [self showUnboundedAlertView];
    }
//    if (!self.resultEntity.isUsable) {
//        [self promptCustomerTitle:@"我知道了" withMessage:@"只能在周二和周五发起提现申请!" finish:nil];
//        return;
//    }
    WS(weakSelf);
    RebateDetailsViewController *rebateDetails = [[[self class] getMainStoryboardClass] instantiateViewControllerWithIdentifier:@"RebateDetailsViewController"];
    rebateDetails.rebateAmount = (sender.tag == 100)?[self.resultEntity.accountTotal floatValue]:[self.resultEntity.redPackageAccountTotal floatValue];
    rebateDetails.billType = (sender.tag == 100)?commission:redPackage;
    rebateDetails.bankCardNumber = [[self.resultEntity.bankCards firstObject] bankAccount];
    [rebateDetails setShowApplyDetails:^(TOApplyBillEntity *entity) {
        WithdrawalTableViewController *detailVC = [[[self class] getMainStoryboardClass] instantiateViewControllerWithIdentifier:@"WithdrawalTableViewController"];
        detailVC.model = entity;
        [weakSelf.navigationController pushViewController:detailVC animated:YES];
    }];
    [self.navigationController pushViewController:rebateDetails animated:YES];
}

#pragma mark - 收支明细
- (IBAction)paymentDetailsClickAction:(UIButton *)sender {
    
    PaymentWithdrawalMainViewController *controller = [[[self class] getMainStoryboardClass]instantiateViewControllerWithIdentifier:@"PaymentWithdrawalMainViewController"];
    [self.navigationController pushViewController:controller animated:YES];
}

#pragma mark - 提现账户
- (IBAction)withdrawalAccountClickAction:(UIButton *)sender {
    
    if (self.resultEntity.bankCards.count) {
        [self haveBindingBankCARDS];
    }else {
        [self showUnboundedAlertView];
    }
}

#pragma mark - 未绑定银行卡
- (void)showUnboundedAlertView
{
    UIAlertController *alertView = [UIAlertController alertControllerWithTitle:nil message:@"您还没有绑定提现账户" preferredStyle:UIAlertControllerStyleAlert];
    [alertView addAction:[UIAlertAction actionWithTitle:@"取消" style:UIAlertActionStyleCancel handler:nil]];
    [alertView addAction:[UIAlertAction actionWithTitle:@"去绑定" style:UIAlertActionStyleDefault handler:^(UIAlertAction * _Nonnull action) {
        BindingBankCARDViewController *bindingVC = [[[self class] getMainStoryboardClass] instantiateViewControllerWithIdentifier:@"BindingBankCARDViewController"];
        [self.navigationController pushViewController:bindingVC animated:YES];
    }]];
    [self presentViewController:alertView animated:YES completion:nil];
}

#pragma mark - 已绑定银行卡
- (void)haveBindingBankCARDS
{
    TOBankCardEntity *entity = self.resultEntity.bankCards[0];
    NSString *bankCard = [NSString stringWithFormat:@"您已绑定提现账户\n%@(**** %@)",entity.bankCardType,[entity.bankAccount substringWithRange:NSMakeRange(entity.bankAccount.length-4, 4)]];
    UIAlertController *alertView = [UIAlertController alertControllerWithTitle:nil message:bankCard preferredStyle:UIAlertControllerStyleAlert];
    [alertView addAction:[UIAlertAction actionWithTitle:@"解除绑定" style:UIAlertActionStyleDefault handler:^(UIAlertAction * _Nonnull action) {
        [self removeBindingBankCARDS];
    }]];
    [alertView addAction:[UIAlertAction actionWithTitle:@"重新绑定" style:UIAlertActionStyleDefault handler:^(UIAlertAction * _Nonnull action) {
        BindingBankCARDViewController *bindingVC = [[[self class] getMainStoryboardClass] instantiateViewControllerWithIdentifier:@"BindingBankCARDViewController"];
        [self.navigationController pushViewController:bindingVC animated:YES];
    }]];
    [alertView addAction:[UIAlertAction actionWithTitle:@"返回" style:UIAlertActionStyleCancel handler:nil]];
    [self presentViewController:alertView animated:YES completion:nil];
}

#pragma mark - 解除绑定银行卡
- (void)removeBindingBankCARDS
{
    [XBLoadingView showHUDViewWithDefault];
    WS(weakSelf);
     TOBankCardEntity *entity = self.resultEntity.bankCards[0];
    [[NetworkRequestClassManager Manager] NetworkWithDictionaryRequestWithURL:[NSString stringWithFormat:SERVERREQUESTURL(UNBINDING),entity.bankAccount] WithRequestType:ONE WithParameter:nil WithReturnValueBlock:^(id returnValue) {
        
        [XBLoadingView hideHUDViewWithDefault];
        if ([returnValue[@"code"] isEqualToNumber:@0]) {
            [XBLoadingView showHUDViewWithSuccessText:@"解除绑定成功" completeBlock:^{
                [weakSelf getRebateDatasFromUser];
            }];
        }else {
            [XBLoadingView showHUDViewWithText:returnValue[@"message"]];
        }
        
    } WithFailureBlock:^(NSError *error) {
        [XBLoadingView hideHUDViewWithDefault];
        [XBLoadingView showHUDViewWithText:error.localizedDescription];
    }];
}


#pragma mark - 更多卡劵
- (IBAction)moreCardButtonClickAction:(UIButton *)sender {
    
    CardDetailsViewController *cardDetails = [[[self class] getMainStoryboardClass]instantiateViewControllerWithIdentifier:@"CardDetailsViewController"];
    [self.navigationController pushViewController:cardDetails animated:YES];
}

#pragma mark - 更多抽奖信息
- (IBAction)moreDrawButtonClickAction:(UIButton *)sender {
    
    LuckyDrawViewController *luckDrawDetails = [[[self class]  getMainStoryboardClass] instantiateViewControllerWithIdentifier:@"LuckyDrawViewController"];
    [self.navigationController pushViewController:luckDrawDetails animated:YES];
}



@end
