//
//  PromotionalGoodsModel.h
//  Lighting
//
//  Created by 曹云霄 on 2016/10/18.
//  Copyright © 2016年 上海勾芒科技有限公司. All rights reserved.
//

#import <Foundation/Foundation.h>

@class Goods;
@protocol Goods @end

@interface PromotionalGoodsModel : JSONModel

//** 促销对象 */
@property (nonatomic, copy) NSString *body;

//** 赠送数量 */
@property (nonatomic, assign) NSInteger count;

//** 类型 */
@property (nonatomic, copy) NSString *type;

//** 商品列表 */
@property (nonatomic, strong) Goods *goods;

//** 描述 */
@property (nonatomic, copy) NSString *descriptionString;

// 优先级
@property (nonatomic,assign) NSInteger priority;

//** 是否选中 */
@property (nonatomic,assign) BOOL isSelected;

// 冲突列表
@property (nonatomic,strong) NSArray *conflicts;

@end

@interface Goods : JSONModel

//** 商品名称 */
@property (nonatomic, copy) NSString *name;

//** ID */
@property (nonatomic, copy) NSString *uuid;

//** code */
@property (nonatomic, copy) NSString *code;

@end

