//
//  LearningCenterMainViewController.m
//  Lighting
//
//  Created by 曹云霄 on 2016/11/16.
//  Copyright © 2016年 上海勾芒科技有限公司. All rights reserved.
//

#import "LearningCenterMainViewController.h"
#import "OnlineLearningViewController.h"
#import "ForumViewController.h"
#import "EmigratedMainViewController.h"
#import "RCAnimatedImagesView.h"

@interface LearningCenterMainViewController ()<RCAnimatedImagesViewDelegate>

@property (nonatomic,strong) RCAnimatedImagesView *imageview;

@end

@implementation LearningCenterMainViewController

- (void)viewWillAppear:(BOOL)animated
{
    [super viewWillAppear:animated];
    self.IntegralInformationBackView.backgroundColor = [[UIColor blackColor] colorWithAlphaComponent:0.5];
}

#pragma mark -渲染完成
- (void)viewDidAppear:(BOOL)animated
{
    [super viewDidAppear:animated];
    self.navigationController.fd_fullscreenPopGestureRecognizer.enabled = NO;
    if ([self.navigationController respondsToSelector:@selector(interactivePopGestureRecognizer)]) {
        self.navigationController.interactivePopGestureRecognizer.enabled = NO;
    }
    [self.imageview startAnimating];
    [self queryIntegralDetails];
}

#pragma mark -视图即将消失
- (void)viewWillDisappear:(BOOL)animated
{
    [super viewWillDisappear:animated];
    // 开启
    self.navigationController.fd_fullscreenPopGestureRecognizer.enabled = YES;
    if ([self.navigationController respondsToSelector:@selector(interactivePopGestureRecognizer)]) {
        self.navigationController.interactivePopGestureRecognizer.enabled = YES;
    }
}

- (void)viewDidDisappear:(BOOL)animated
{
    [super viewDidDisappear:animated];
    [self.imageview stopAnimating];
}

- (void)viewDidLoad {
    [super viewDidLoad];
    
    [self setUpBackImageView];
    [self addGestureRecognizer];
}

#pragma mark - 设置背景View
- (void)setUpBackImageView
{
    self.imageview = [[RCAnimatedImagesView alloc]initWithFrame:CGRectMake(ZERO, NavigationHeight, ScreenWidth+200, ScreenHeight)];
    [self.view addSubview:self.imageview];
    [self.view sendSubviewToBack:self.imageview];
    self.imageview.delegate = self;
}

#pragma mark - <RCAnimatedImagesViewDelegate>
- (NSUInteger)animatedImagesNumberOfImages:(RCAnimatedImagesView *)animatedImagesView
{
    return 2;
}

//返回显示的图片对象
- (UIImage *)animatedImagesView:(RCAnimatedImagesView *)animatedImagesView imageAtIndex:(NSUInteger)index
{
    return [UIImage imageNamed:@"Studybackground"];
}

#pragma mark - 添加点击
- (void)addGestureRecognizer
{
    [self.comprehensiveDiscussionView addGestureRecognizer:[[UITapGestureRecognizer alloc]initWithTarget:self action:@selector(comprehensiveDiscussionViewClickAction:)]];
    [self.onlineLearningView addGestureRecognizer:[[UITapGestureRecognizer alloc]initWithTarget:self action:@selector(onlineLearningViewClickAction:)]];
    [self.breakthroughView addGestureRecognizer:[[UITapGestureRecognizer alloc]initWithTarget:self action:@selector(breakthroughViewClickAction:)]];
}

#pragma mark - 查询积分明细
- (void)queryIntegralDetails
{
    WS(weakSelf);
    [XBLoadingView showHUDViewWithDefault];;
    NSString *url = [NSString stringWithFormat:SERVERREQUESTURL(INTEGRALQUERY),[Shoppersmanager manager].Shoppers.employee.fid];
    [[NetworkRequestClassManager Manager] NetworkWithDictionaryRequestWithURL:url WithRequestType:ONE WithParameter:nil WithReturnValueBlock:^(id returnValue) {
        
        [XBLoadingView hideHUDViewWithDefault];
        if ([returnValue[@"code"] isEqualToNumber:@0]) {
            RsScoreDetails *integralDatas = [[RsScoreDetails alloc]initWithDictionary:returnValue[@"data"] error:nil];
            [weakSelf setUpIntegral:integralDatas];

        }else {
            [XBLoadingView showHUDViewWithText:returnValue[@"message"]];
        }
        
    }WithFailureBlock:^(NSError *error) {
        [XBLoadingView hideHUDViewWithDefault];
        [XBLoadingView showHUDViewWithText:error.localizedDescription];
    }];
}

#pragma mark - 积分信息
- (void)setUpIntegral:(RsScoreDetails *)entity
{
    if (entity.currentScore == 0) {
        entity.quarterlyRanking = 0;
        entity.annualRanking = 0;
    }
    self.currentScoreLabel.text = [NSString stringWithFormat:@"%.0lf",entity.currentScore];
    self.yearRankingLabel.text = [NSString stringWithFormat:@"%ld",(long)entity.annualRanking];
    [self.guideHeadImageView sd_setImageWithURL:[NSURL URLWithString:[Shoppersmanager manager].Shoppers.employee.picture] placeholderImage:ReplaceImage];
    self.quarterRankingLabel.text = [NSString stringWithFormat:@"%ld",(long)entity.quarterlyRanking];
}

#pragma mark - 综合讨论
- (void)comprehensiveDiscussionViewClickAction:(UITapGestureRecognizer *)sender
{
    ForumViewController *forum = [[[self class] getLearningCenterStoryboardClass]instantiateViewControllerWithIdentifier:@"ForumViewController"];
    [self.navigationController pushViewController:forum animated:YES];
}

#pragma mark - 在线学习
- (void)onlineLearningViewClickAction:(UITapGestureRecognizer *)sender
{
    OnlineLearningViewController *onlineLearning = [[[self class] getLearningCenterStoryboardClass] instantiateViewControllerWithIdentifier:@"OnlineLearningViewController"];
    [self.navigationController pushViewController:onlineLearning animated:YES];
}

#pragma mark - 闯关
- (void)breakthroughViewClickAction:(UITapGestureRecognizer *)sender
{
    EmigratedMainViewController *emigrated = [[[self class] getLearningCenterStoryboardClass] instantiateViewControllerWithIdentifier:@"EmigratedMainViewController"];
    [self.navigationController pushViewController:emigrated animated:YES];
}


@end
