//
//  ForumViewController.m
//  Lighting
//
//  Created by 曹云霄 on 2016/11/24.
//  Copyright © 2016年 上海勾芒科技有限公司. All rights reserved.
//

#import "ForumViewController.h"
#import "ForumTableViewCell.h"
#import "ForumItemListViewController.h"


@interface ForumViewController ()<UITableViewDelegate,UITableViewDataSource>

@property (nonatomic,strong) ForumCategoryResponse *category;

@end

@implementation ForumViewController

- (void)viewDidLoad {
    [super viewDidLoad];
    
    [self setUpForumTableView];
    [self setUpRefreshAction];
}

#pragma mark - UITableView
- (void)setUpForumTableView
{
    self.forumTableView.tableFooterView = [UIView new];
    self.forumTableView.rowHeight = 90;
}

#pragma mark - 设置刷新
- (void)setUpRefreshAction
{
    WS(weakSelf);
    MjRefreshHeaderCustom *headerRefresh = [MjRefreshHeaderCustom headerWithRefreshingBlock:^{
        [weakSelf getForumAllTypeAction];
    }];
    headerRefresh.stateLabel.hidden = YES;
    headerRefresh.lastUpdatedTimeLabel.hidden = YES;
    self.forumTableView.mj_header =headerRefresh;
    [self.forumTableView.mj_header beginRefreshing];
}

#pragma mark - 获取论坛项Type
- (void)getForumAllTypeAction
{
    WS(weakSelf);
    [XBLoadingView showHUDViewWithDefault];;
    [[NetworkRequestClassManager Manager] NetworkWithDictionaryRequestWithURL:SERVERREQUESTURL(FORUMTYPS) WithRequestType:ONE WithParameter:nil WithReturnValueBlock:^(id returnValue) {
        
        [XBLoadingView hideHUDViewWithDefault];
        [weakSelf endRefreshingForTableView:weakSelf.forumTableView];
        if ([returnValue[@"code"] isEqualToNumber:@0]) {
            weakSelf.category = [[ForumCategoryResponse alloc] initWithDictionary:returnValue[@"data"] error:nil];
            [weakSelf.forumTableView reloadData];
        }else{
            [XBLoadingView showHUDViewWithText:returnValue[@"message"]];
        }
    } WithFailureBlock:^(NSError *error) {
        [XBLoadingView hideHUDViewWithDefault];
        [XBLoadingView showHUDViewWithText:error.localizedDescription];
    }];
}

#pragma mark - <UITableViewDelegate,UITableViewDataSource>
- (UITableViewCell *)tableView:(UITableView *)tableView cellForRowAtIndexPath:(NSIndexPath *)indexPath
{
    ForumTableViewCell *forumCell = [tableView dequeueReusableCellWithIdentifier:@"ForumTableViewCell" forIndexPath:indexPath];
    forumCell.categoryEntity = self.category.categories[indexPath.row];
    return forumCell;
}

- (NSInteger)tableView:(UITableView *)tableView numberOfRowsInSection:(NSInteger)section
{
    return self.category.categories.count;
}

- (void)tableView:(UITableView *)tableView didSelectRowAtIndexPath:(NSIndexPath *)indexPath
{
    ForumItemListViewController *itemListVc = [[[self class] getLearningCenterStoryboardClass] instantiateViewControllerWithIdentifier:@"ForumItemListViewController"];
    itemListVc.category = self.category.categories[indexPath.row];
    [self.navigationController pushViewController:itemListVc animated:YES];
}


@end
