//
//  BestReplyView.m
//  Lighting
//
//  Created by 曹云霄 on 2016/12/13.
//  Copyright © 2016年 上海勾芒科技有限公司. All rights reserved.
//

#import "BestReplyView.h"

@implementation BestReplyView

- (instancetype)initWithFrame:(CGRect)frame
{
    if (self = [super initWithFrame:frame]) {
        [self uiConfigAction];
        [self addGestureRecognizer];
    }
    return self;
}

#pragma mark - UI
- (void)uiConfigAction
{
    self.backgroundColor = RGB(115, 116, 117, 1);
    self.layer.cornerRadius = 4.0f;
    self.layer.masksToBounds = YES;
    
    UIButton *button = [UIButton buttonWithType:UIButtonTypeCustom];
    button.frame = CGRectMake(5, 5, 20, 20);
    button.tag = 100;
    [button setImage:TCImage(@"best") forState:UIControlStateNormal];
    [button setImage:TCImage(@"bestselect") forState:UIControlStateSelected];
    [self addSubview:button];
    
    UILabel *label = [[UILabel alloc] initWithFrame:CGRectMake(30, 5, 50, 20)];
    label.text = @"最佳回复";
    label.tag = 101;
    label.font = [UIFont systemFontOfSize:12];
    label.textColor = [UIColor whiteColor];
    [self addSubview:label];
}

- (void)setIsBest:(BOOL)isBest
{
    _isBest = isBest;
    UIButton *button = [self viewWithTag:100];
    UILabel *label = [self viewWithTag:101];
    button.selected = _isBest;
    label.text = _isBest?@"取消最佳":@"设为最佳";
}

#pragma mark - 事件
- (void)addGestureRecognizer
{
    [self addGestureRecognizer:[[UITapGestureRecognizer alloc] initWithTarget:self action:@selector(tapClickAction:)]];
}

#pragma mark - 响应
- (void)tapClickAction:(UITapGestureRecognizer *)sender
{
    if ([self.delegate respondsToSelector:@selector(tapClickAction:withReplyId:withIndexPath:)]) {
        UIButton *button = [self viewWithTag:100];
        [self.delegate tapClickAction:!button.isSelected withReplyId:self.replyId withIndexPath:self.indexPath];
    }
}

@end
