//
//  BestReplyView.h
//  Lighting
//
//  Created by 曹云霄 on 2016/12/13.
//  Copyright © 2016年 上海勾芒科技有限公司. All rights reserved.
//

#import <UIKit/UIKit.h>


@protocol TapClickDelegate <NSObject>

/**
 点击事件

 @param isBest true 表示设为最佳   false 表示取消最佳    replyId 回复ID
 */
- (void)tapClickAction:(BOOL)isBest withReplyId:(NSString *)replyId withIndexPath:(NSIndexPath *)indexPath;

@end

@interface BestReplyView : UIView

@property (nonatomic,weak) id<TapClickDelegate>delegate;

/**
 回复ID
 */
@property (nonatomic,copy) NSString *replyId;

/**
 是否最佳回复
 */
@property (nonatomic,assign) BOOL isBest;

/**
 cell下标
 */
@property (nonatomic,strong) NSIndexPath *indexPath;

@end
