//
//  IntegralDetailsViewController.m
//  Lighting
//
//  Created by 曹云霄 on 2016/11/21.
//  Copyright © 2016年 上海勾芒科技有限公司. All rights reserved.
//

#import "IntegralDetailsViewController.h"
#import "IntegralDetailsTableViewCell.h"
#import "prizeDetailsTableViewCell.h"
#import "PrizeExchangeDetailsViewController.h"

@interface IntegralDetailsViewController ()<UITableViewDelegate,UITableViewDataSource,DZNEmptyDataSetSource,DZNEmptyDataSetDelegate>
/**
 数据源
 */
@property (nonatomic,strong) NSMutableArray *datasArray;

/**
 顶部约束
 */
@property (weak, nonatomic) IBOutlet NSLayoutConstraint *topConstraint;

@end

@implementation IntegralDetailsViewController

- (void)viewDidAppear:(BOOL)animated
{
    [super viewDidAppear:animated];
    [self setUpRefreshAction];
}

- (void)viewDidLoad {
    [super viewDidLoad];
    
    [self uiConfigAction];
}

#pragma mark - UI
- (void)uiConfigAction
{
    self.integralDetailsTableView.rowHeight = (self.cellType == PrizeTableView)?90:70;
    self.integralDetailsTableView.tableFooterView = [UIView new];
    if (self.cellType == PrizeTableView) {
        self.topConstraint.constant = NavigationHeight;
        self.integralDetailsTableView.separatorStyle = UITableViewCellSeparatorStyleNone;
        self.integralDetailsTableView.backgroundColor = RGB(237, 238, 239, 1);
    }
}

#pragma mark - 设置刷新
- (void)setUpRefreshAction
{
    WS(weakSelf);
    MjRefreshHeaderCustom *headerRefresh = [MjRefreshHeaderCustom headerWithRefreshingBlock:^{
        [weakSelf.integralDetailsTableView.mj_footer resetNoMoreData];
        switch (weakSelf.cellType) {
            case IntrgralTableView:
            {
                [weakSelf.integralDetailsTableView.mj_footer resetNoMoreData];
                [weakSelf queryIntegralDetails:YES];
            }
                break;
            case PrizeTableView:
            {
                [weakSelf queryPrizeDetails:YES];
            }
                break;
                
            default:
                break;
        }
    }];
    headerRefresh.stateLabel.hidden = YES;
    headerRefresh.lastUpdatedTimeLabel.hidden = YES;
    self.integralDetailsTableView.mj_header = headerRefresh;
     [self.integralDetailsTableView.mj_header beginRefreshing];
    MJRefreshAutoNormalFooter *footer = [MJRefreshAutoNormalFooter footerWithRefreshingBlock:^{
        switch (weakSelf.cellType) {
            case IntrgralTableView:
            {
                [weakSelf.integralDetailsTableView.mj_footer endRefreshingWithNoMoreData];
            }
                break;
            case PrizeTableView:
            {
                [weakSelf.integralDetailsTableView.mj_footer endRefreshingWithNoMoreData];
            }
                break;
                
            default:
                break;
        }
    }];
    footer.automaticallyHidden = YES;
    self.integralDetailsTableView.mj_footer = footer;
}
#pragma mark - 查询积分明细
- (void)queryIntegralDetails:(BOOL)isRemove
{
    WS(weakSelf);
    [XBLoadingView showHUDViewWithDefault];;
    NSString *url = [NSString stringWithFormat:SERVERREQUESTURL(INTEGRALQUERY),[Shoppersmanager manager].Shoppers.employee.fid];
    [[NetworkRequestClassManager Manager] NetworkWithDictionaryRequestWithURL:url WithRequestType:ONE WithParameter:nil WithReturnValueBlock:^(id returnValue) {
        
        [XBLoadingView hideHUDViewWithDefault];
        [weakSelf endRefreshingForTableView:weakSelf.integralDetailsTableView];
        weakSelf.integralDetailsTableView.emptyDataSetSource = weakSelf;
        weakSelf.integralDetailsTableView.emptyDataSetDelegate = weakSelf;
        if ([returnValue[@"code"] isEqualToNumber:@0]) {
            if (isRemove) {
                [weakSelf.datasArray removeAllObjects];
            }
            RsScoreDetails *integralDatas = [[RsScoreDetails alloc]initWithDictionary:returnValue[@"data"] error:nil];
            [weakSelf.datasArray addObjectsFromArray:integralDatas.recoreds];
            if (weakSelf.returnIntegralDetailsBlock) {
                weakSelf.returnIntegralDetailsBlock(integralDatas);
            }
        }else {
            [XBLoadingView showHUDViewWithText:returnValue[@"message"]];
        }
        [weakSelf.integralDetailsTableView reloadData];
        
    }WithFailureBlock:^(NSError *error) {
        [weakSelf endRefreshingForTableView:weakSelf.integralDetailsTableView];
        [XBLoadingView hideHUDViewWithDefault];
        [XBLoadingView showHUDViewWithText:error.localizedDescription];
    }];
}

#pragma mark - 查询兑奖明细
- (void)queryPrizeDetails:(BOOL)isRemove
{
    WS(weakSelf);
    [XBLoadingView showHUDViewWithDefault];;
    NSString *url = [NSString stringWithFormat:SERVERREQUESTURL(ALLEXCHANGERECORD),[Shoppersmanager manager].Shoppers.employee.fid];
    [[NetworkRequestClassManager Manager] NetworkWithDictionaryRequestWithURL:url WithRequestType:ONE WithParameter:nil WithReturnValueBlock:^(id returnValue) {
        
        [XBLoadingView hideHUDViewWithDefault];
        [weakSelf endRefreshingForTableView:weakSelf.integralDetailsTableView];
        weakSelf.integralDetailsTableView.emptyDataSetSource = weakSelf;
        weakSelf.integralDetailsTableView.emptyDataSetDelegate = weakSelf;
        if ([returnValue[@"code"] isEqualToNumber:@0]) {
            if (isRemove) {
                [weakSelf.datasArray removeAllObjects];
            }
            RsPrizeBillResponse *integralDatas = [[RsPrizeBillResponse alloc]initWithDictionary:returnValue[@"data"] error:nil];
            [weakSelf.datasArray addObjectsFromArray:integralDatas.bills];
        }else {
            [XBLoadingView showHUDViewWithText:returnValue[@"message"]];
        }
        [weakSelf.integralDetailsTableView reloadData];
        
    } WithFailureBlock:^(NSError *error) {
        [weakSelf endRefreshingForTableView:weakSelf.integralDetailsTableView];
        [XBLoadingView hideHUDViewWithDefault];
        [XBLoadingView showHUDViewWithText:error.localizedDescription];
    }];
}

#pragma mark - <UITableViewDataSource,UITableViewDelegate>
- (UITableViewCell *)tableView:(UITableView *)tableView cellForRowAtIndexPath:(NSIndexPath *)indexPath
{
    switch (self.cellType) {
        case IntrgralTableView:
        {
            IntegralDetailsTableViewCell *integralCell = [tableView dequeueReusableCellWithIdentifier:@"IntegralDetailsTableViewCell" forIndexPath:indexPath];
            integralCell.integralEntity = self.datasArray[indexPath.row];
            integralCell.selectionStyle = UITableViewCellSelectionStyleNone;
            return integralCell;
        }
            break;
        case PrizeTableView:
        {
            prizeDetailsTableViewCell *prizeCell = [tableView dequeueReusableCellWithIdentifier:@"prizeDetailsTableViewCell" forIndexPath:indexPath];
            prizeCell.prizeListModel = self.datasArray[indexPath.row];
            prizeCell.backgroundColor = [UIColor clearColor];
            return prizeCell;
        }
            break;
            
        default:
            break;
    }
    return nil;
}

- (NSInteger)tableView:(UITableView *)tableView numberOfRowsInSection:(NSInteger)section
{
    return self.datasArray.count;
}

- (void)tableView:(UITableView *)tableView didSelectRowAtIndexPath:(NSIndexPath *)indexPath
{
    switch (self.cellType) {
        case PrizeTableView:
        {
            PrizeExchangeDetailsViewController *exchangeDetails = [[[self class] getGuideIntegralStoryboardClass] instantiateViewControllerWithIdentifier:@"PrizeExchangeDetailsViewController"];
            RsPrizeBill *bill = self.datasArray[indexPath.row];
            exchangeDetails.isDelivery = ![bill.bill.state isEqualToString:TOPRIZEBILLENTITYSTATE_REQUESTED];
            exchangeDetails.prizeBillNumber = bill.bill.billnumber;
            [self.navigationController pushViewController:exchangeDetails animated:YES];
        }
            break;
            
        default:
            break;
    }
}

#pragma mark -友好界面
- (UIImage *)imageForEmptyDataSet:(UIScrollView *)scrollView
{
    return kNoDataImage;
}

- (BOOL)emptyDataSetShouldAllowScroll:(UIScrollView *)scrollView
{
    return YES;
}

- (NSAttributedString *)titleForEmptyDataSet:(UIScrollView *)scrollView
{
    return [[NSAttributedString alloc]initWithString:@"暂无数据~" attributes:nil];
}


#pragma mark - lazy
- (NSMutableArray *)datasArray
{
    if (!_datasArray) {
        _datasArray = [NSMutableArray array];
    }
    return _datasArray;
}

@end
