//
//  CommodityListTableViewCell.m
//  Lighting
//
//  Created by 曹云霄 on 16/5/4.
//  Copyright © 2016年 上海勾芒科技有限公司. All rights reserved.
//

#import "CommodityListTableViewCell.h"

@implementation CommodityListTableViewCell

- (void)awakeFromNib {
    [super awakeFromNib];
    // Initialization code
}

#pragma mark 赋值
- (void)setModel:(ShopcarModel *)model
{
    _model = model;
    [self.goodsHeader sd_setImageWithURL:[NSURL URLWithString:_model.goods.pictures] placeholderImage:REPLACEIMAGE];
    self.goodsName.text = _model.goods.name;
    self.specifications.text = _model.goods.size;
    self.goodsCode.text = _model.goods.code;
    self.goodsNumber.text = [NSString stringWithFormat:@"数量   X%d",_model.goodsNum];
    self.clinchPrice.text = [NSString stringWithFormat:@"成交价   ￥%.2f",[_model.goods.costPrice floatValue]];
    //计算总价格
    NSInteger number = _model.goodsNum;
    CGFloat price = [_model.goods.costPrice floatValue];
    CGFloat allPrice = number*price;
    self.totalPrice.text = [NSString stringWithFormat:@"￥%.2f",allPrice];
}



#pragma mark -订单详情页赋值
- (void)setOrderDetailslist:(TOOrderdetailEntity *)orderDetailslist
{
    
    _orderDetailslist = orderDetailslist;
    self.goodsName.text = _orderDetailslist.goodsName;
    self.goodsCode.text = _orderDetailslist.goodsCode;
    [self.goodsHeader sd_setImageWithURL:[NSURL URLWithString:_orderDetailslist.goodsBrand] placeholderImage:REPLACEIMAGE];
    self.goodsNumber.text = [NSString stringWithFormat:@"数量   X%@",_orderDetailslist.goodsNum];
    self.clinchPrice.text = [NSString stringWithFormat:@"成交价  ￥%.2f",[_orderDetailslist.goodsPrice floatValue]];
    //小计
    CGFloat totalPrice = [_orderDetailslist.goodsNum integerValue] * [_orderDetailslist.goodsPrice floatValue];
    self.totalPrice.text = [NSString stringWithFormat:@"￥%.2f",totalPrice];
    
    
    
}




- (void)setSelected:(BOOL)selected animated:(BOOL)animated {
    [super setSelected:selected animated:animated];

    // Configure the view for the selected state
}

@end
