//
//  XBLoadingView.m
//  Lighting
//
//  Created by 曹云霄 on 2016/12/1.
//  Copyright © 2016年 上海勾芒科技有限公司. All rights reserved.
//

#import "XBLoadingView.h"

@implementation XBLoadingView

/**
 显示普通加载框
 */
+ (void)showHUDViewWithDefault
{
    UIActivityIndicatorView *loadingView = [[UIActivityIndicatorView alloc] initWithActivityIndicatorStyle:UIActivityIndicatorViewStyleWhiteLarge];
    loadingView.frame = [UIScreen mainScreen].bounds;
    [[self hudShowWindow] addSubview:loadingView];
    loadingView.center = [[self hudShowWindow] center];
    loadingView.color = kMainBlueColor;
    loadingView.hidesWhenStopped = YES;
    [loadingView startAnimating];
    
//    XBLoadingView *hud = [XBLoadingView showHUDAddedTo:[self hudShowWindow] animated:YES];
//    hud.animationType = MBProgressHUDAnimationZoom;
//    hud.mode = MBProgressHUDModeIndeterminate;
//    hud.color = [UIColor clearColor];
//    hud.activityIndicatorColor = kMainBlueColor;
//    hud.removeFromSuperViewOnHide = YES;
}

/**
 显示普通加载框
 */
+ (void)showHUDViewWithDefaultWithView:(UIView *)view
{
//    XBLoadingView *hud = [XBLoadingView showHUDAddedTo:view animated:YES];
//    hud.animationType = MBProgressHUDAnimationZoom;
//    hud.mode = MBProgressHUDModeIndeterminate;
//    hud.color = [UIColor clearColor];
//    hud.activityIndicatorColor = kMainBlueColor;
//    hud.removeFromSuperViewOnHide = YES;
    
    UIActivityIndicatorView *loadingView = [[UIActivityIndicatorView alloc] initWithActivityIndicatorStyle:UIActivityIndicatorViewStyleWhiteLarge];
    loadingView.frame = view.bounds;
    [view addSubview:loadingView];
    loadingView.center = [view center];
    loadingView.color = kMainBlueColor;
    loadingView.hidesWhenStopped = YES;
    [loadingView startAnimating];
}

/**
 显示文本提示框
 
 @param text 提示信息
 */
+ (void)showHUDViewWithText:(NSString *)text
{
    XBLoadingView *hud = [XBLoadingView showHUDAddedTo:[self hudShowWindow] animated:YES];
    hud.labelText = text;
    hud.margin = 20.f;
    hud.color = [[UIColor blackColor] colorWithAlphaComponent:0.5];
    hud.animationType = MBProgressHUDAnimationZoom;
    hud.mode = MBProgressHUDModeText;
    hud.removeFromSuperViewOnHide = YES;
    [hud hide:YES afterDelay:3.0f];
}

/**
 显示成功提示框
 
 @param text 提示信息
 */
+ (void)showHUDViewWithSuccessText:(NSString *)text completeBlock:(void (^)())finish
{
    XBLoadingView *hud = [XBLoadingView showHUDAddedTo:[self hudShowWindow] animated:YES];
    hud.mode = MBProgressHUDModeCustomView;
    UIImage *image = [[UIImage imageNamed:@"success-1"] imageWithRenderingMode:UIImageRenderingModeAlwaysOriginal];
    hud.customView = [[UIImageView alloc] initWithImage:image];
    hud.color = [[UIColor blackColor] colorWithAlphaComponent:0.6];
    hud.labelFont = [UIFont systemFontOfSize:15];
    hud.labelText = text;
    [hud hide:YES afterDelay:3];
    if (finish) {
        dispatch_after(dispatch_time(DISPATCH_TIME_NOW, (int64_t)(3 * NSEC_PER_SEC)), dispatch_get_main_queue(), ^{
            finish();
        });
    }
}

/**
 显示进度框
 
 @param text 提示信息
 
 @return XBLoadingView
 */
+ (XBLoadingView *)showHUDViewProgressLabel:(NSString *)text
{
    XBLoadingView *hud = [XBLoadingView showHUDAddedTo:[self hudShowWindow] animated:YES];
    hud.mode = MBProgressHUDModeDeterminateHorizontalBar;
    hud.labelText = text;
    hud.labelFont = [UIFont systemFontOfSize:12];
    hud.removeFromSuperViewOnHide = YES;
    return hud;
}

/**
 隐藏加载框
 */
+ (void)hideHUDViewWithDefault
{
//    [[self class] hideAllHUDsForView:[self hudShowWindow] animated:YES];
    [[self class] hideActivityIndicatorForView:[self hudShowWindow] animated:YES];
}


/**
 隐藏加载框
 */
+ (void)hideHUDViewWithDefaultWithView:(UIView *)view
{
//    [[self class] hideAllHUDsForView:view animated:YES];
    [[self class] hideActivityIndicatorForView:view animated:YES];
}



#pragma mark - 隐藏UIActivityIndicatorView
+ (void)hideActivityIndicatorForView:(UIView *)view animated:(BOOL)animated
{
    NSArray *indicators = [XBLoadingView allIndicatorViewForView:view];
    for (UIActivityIndicatorView *indicator in indicators) {
        [indicator stopAnimating];
    }
}


#pragma mark - 获取所有的 UIActivityIndicatorView
+ (NSArray *)allIndicatorViewForView:(UIView *)view {
    NSMutableArray *indicatos = [NSMutableArray array];
    NSArray *subviews = view.subviews;
    for (UIView *aView in subviews) {
        if ([aView isKindOfClass:[UIActivityIndicatorView class]]) {
            [indicatos addObject:aView];
        }
    }
    return [NSArray arrayWithArray:indicatos];
}

#pragma mark - 获取主窗口
+ (UIWindow *)hudShowWindow
{
    UIWindow *showWindow = nil;
    NSArray *windows = [[UIApplication sharedApplication] windows];
    if ([windows count] >= 2) {
        showWindow = [windows objectAtIndex:1];
    }
    else {
        showWindow = [[UIApplication sharedApplication] keyWindow];
    }
    return showWindow;
}
@end
