//
//  BaseViewController.h
//  Lighting
//
//  Created by 曹云霄 on 16/4/27.
//  Copyright © 2016年 上海勾芒科技有限公司. All rights reserved.
//

#import <UIKit/UIKit.h>



@interface BaseViewController : UIViewController


/**
 *  结束刷新
 *
 *  @param TableView Tableview
 */
- (void)endRefreshingForTableView:(UIScrollView *)TableView;


/**
 *  获得主体的storyboard对象
 */
+ (UIStoryboard *)getMainStoryboardClass;

/**
 获得公告storyboard对象
 */
+ (UIStoryboard *)getAnnouncementStoryboardClass;

/**
 获得学习中心storyboard对象
 */
+ (UIStoryboard *)getLearningCenterStoryboardClass;

/**
 获得积分storyboard对象
 */
+ (UIStoryboard *)getGuideIntegralStoryboardClass;

/**
 *  调用打印机
 */
- (void)callAirprintWithdata:(NSString *)PDFpath SuccessBlock:(void(^)())success ErrorBlock:(void(^)())failed;

/**
 *  判断是否有相机权限
 */
+ (BOOL)determineCameraPermissions;

/**
 *  判断是否有相册权限
 */
+ (BOOL)determinePhotosPermissions;

/**
 *  提示框
 *
 */
- (void)promptCustomerTitle:(NSString *)title withMessage:(NSString *)message finish:(void (^)())complete;


/**
 *  查询订单状态图片
 */
+ (UIImage *)ReturnOrderStateImageWithStateCode:(NSInteger)ordercode;

/**
 *  查询订单状态文本      //code == 0 取文字  code == 1取颜色
 */
+ (id)ReturnOrderStateTitleWithStateCode:(NSInteger)ordercode withPoint:(CGPoint)point WithCode:(NSInteger)code;


/**
 *  查询购物车数量
 */
- (void)QueryShoppingCarNumber;

/**
 *  查询购物车商品
 */
- (void)queryShoppingCarGoods;


/**
 *  系统提示框
 */
- (void)promptCustomerWithString:(NSString *)message;

/**
 *  友好化时间
 */
+ (NSString *) compareCurrentTime:(NSString *)str;

/**
 *  获取版本号
 */
- (NSString*)getAppVersion;

/**
 *  通过面额获取相应的图片
 */
+ (UIImage *)getCorrespondingPictures:(NSInteger)total;

/**
 *  判断字符串是否为空
 */
+ (BOOL)isBlankString:(NSString *)string;

/**
 *  获取当前时间之前或者之后的时间（之前传入负数）
 */
+ (NSString *)getTimeby:(NSInteger)day;

/**
 查询兑奖单state对应文字
 */
+ (id)returnPrizeBillStateTitleColor:(NSString *)stateCode;

#pragma mark - 设置提现状态

/**
 提现申请状态

 @param text 状态码

 @return 字体颜色、文本
 */
+ (NSDictionary *)setupLabelColor:(NSString *)text;

/**
 收支明细

 @param number 金额
 @param type   类型
 */
+ (NSString *)separatePaymentsAndWithfrawal:(NSNumber *)number withType:(NSString *)type;

/**
 考核题型转义
 */
+ (NSString *)returnTopicTypeTitle:(NSString *)typeCode;

/**
 选择框

 @param message 文本
 @param cancel  取消
 @param sure    确认
 */
- (void)promptBoxWithMessage:(NSString *)message cancelBlock:(void(^)())cancel sureBlock:(void(^)())sure;


/**
 闯关结果状态

 @param passResult 闯关结果

 @return 状态图片
 */
- (UIImage *)emigratedState:(NSString *)passResult;


/**
 保存用户名密码

 @param account  用户名
 @param passWord 密码
 */
+ (void)saveAccountAndPassWord:(NSString *)account AndPassword:(NSString *)passWord;

/**
 删除用户名密码
 */
+ (void)deleteAccountAndPassWord;

/**
 比较时间大小

 @param dateString 时间字符串

 @return 是否比当前时间大
 */
- (int)compareOneDay:(NSDate *)oneDay withAnotherDay:(NSDate *)anotherDay;


/**
 转换秒钟
 
 @param totalSeconds 秒数
 
 */
- (NSString *)timeFormatted:(NSInteger)totalSeconds;

/**
 url转码

 @param ChineseString 带中文的字符串
 */
- (NSString *)returnUrlString:(NSString *)ChineseString;


@end
