

#配置以下项
# 工程名
APP_NAME="Lighting"
# 电脑用户名
USER_NAME="caoyunxiao"
# 证书
CODE_SIGN_DISTRIBUTION="iPhone Distribution: Shanghai Gomore Information Technology Co.,Ltd"
#描述文件名称
Profile_Name="oppleDis"



# info.plist路径
project_infoplist_path="./${APP_NAME}/Info.plist"

#取版本号
bundleShortVersion=$(/usr/libexec/PlistBuddy -c "print CFBundleShortVersionString" "${project_infoplist_path}")

#取build值
bundleVersion=$(/usr/libexec/PlistBuddy -c "print CFBundleVersion" "${project_infoplist_path}")

#日期
DATE="$(date +%Y%m%d %H:%M:%S)"

#ipa文件名字
IPANAME="${APP_NAME}_V${bundleShortVersion}_${DATE}"

#xcarchive路径
archivePath="/Users/${USER_NAME}/Desktop/App_IOS/archive/${APP_NAME}.xcarchive"

#IPA路径
ipa_path="/Users/${USER_NAME}/Desktop/App_IOS/archive/${IPANAME}"

#要上传的ipa文件路径
echo ${ipa_path}".ipa"> text.txt

echo "=================clean================="
xcodebuild -workspace "${APP_NAME}.xcworkspace" -scheme "${APP_NAME}"  -configuration 'Release' clean


echo "+++++++++++++++++build+++++++++++++++++"
xcodebuild -workspace "${APP_NAME}.xcworkspace" -scheme "${APP_NAME}" -sdk iphoneos -configuration 'Release' CODE_SIGN_IDENTITY="${CODE_SIGN_DISTRIBUTION}" SYMROOT='$(PWD)'

#打包
xcodebuild -archivePath ${archivePath} -workspace "${APP_NAME}.xcworkspace" -sdk iphoneos -scheme "${APP_NAME}" -configuration "Release" archive

#生成IPA
xcodebuild -exportArchive -archivePath ${archivePath} -exportPath ${ipa_path} -exportProvisioningProfile "${Profile_Name}"
