//
//  RightViewController.m
//  Lighting
//
//  Created by 曹云霄 on 16/4/28.
//  Copyright © 2016年 上海勾芒科技有限公司. All rights reserved.
//

#import "RightViewController.h"
#import "AppDelegate.h"
#import "RightControlSectionView.h"
#import "RightControlTableViewCell.h"





@interface RightViewController ()<UITableViewDataSource,UITableViewDelegate>


@property (weak, nonatomic) IBOutlet UITableView *rightTableview;

/**
 *  section数据源
 */
@property (nonatomic,strong) NSMutableArray *dataArray;

/**
 *  客户管理下级菜单
 */
@property (nonatomic,strong) NSArray *subSectionArray;

/**
 *  控制section 闭合开启
 */
@property (nonatomic,strong) NSMutableArray *sectionClosedArray;

/**
 *  图片数组
 */
@property (nonatomic,strong) NSArray *imageArray;

/**
 *  指示线
 */
@property (nonatomic,strong) UIView *lineView;


@end

@implementation RightViewController

/**
 *  初始化数据源
 *
 *  @return NSArray
 */
- (NSMutableArray *)dataArray
{
    if (_dataArray == nil) {
        _dataArray = [NSMutableArray arrayWithObjects:@"体验中心",@"场景库",@"产品库",@"客户管理",@"学习中心",@"关于", nil];
        if ([[Shoppersmanager manager].Shoppers.employee.userKey rangeOfString:@"学习人员"].location == NSNotFound) {
            [_dataArray removeObject:@"学习中心"];
        }
    }
    return _dataArray;
}

- (NSArray *)subSectionArray
{
    if (!_subSectionArray) {
        _subSectionArray = @[@"",@"",@"",@[@"所有客户",@"客户订单"],@"",@""];
    }
    return _subSectionArray;
}

- (NSMutableArray *)sectionClosedArray
{
    if (!_sectionClosedArray) {
        _sectionClosedArray = [NSMutableArray array];
        //** @0表示闭合，@1表示开启 */
        for (int i=0; i<self.dataArray.count; i++) {
            [_sectionClosedArray addObject:@0];
        }
    }
    return _sectionClosedArray;
}

- (UIView *)lineView
{
    if (!_lineView) {
        _lineView = [[UIView alloc]init];
        _lineView.backgroundColor = kMainBlueColor;
        [self.rightTableview addSubview:_lineView];
    }
    return _lineView;
}

/**
 *  图片
 */
- (NSArray *)imageArray
{
    if (_imageArray == nil) {
        
        _imageArray = [NSArray arrayWithObjects:@"tiyan",@"changjing",@"chanping",@"kehu",@"Learningcenter",@"guanyu", nil];
    }
    return _imageArray;
}

- (void)viewDidLoad {
    [super viewDidLoad];
    [self createHeaderview];
    [self uiConfigAction];
}

#pragma mark -布局
- (void)uiConfigAction
{
    self.rightTableview.tableFooterView = [UIView new];
    [self.rightTableview registerClass:[UITableViewCell class] forCellReuseIdentifier:@"rightcell"];
    [self.rightTableview registerClass:[RightControlSectionView class] forHeaderFooterViewReuseIdentifier:@"RightControlSectionView"];
}

#pragma mark -头部视图
- (void)createHeaderview
{
    UIView *navigationView = [[UIView alloc]initWithFrame:CGRectMake(0, 0, RightWidth, NavigationHeight)];
    //阴影
    navigationView.layer.shadowColor = [UIColor blackColor].CGColor;
    navigationView.layer.shadowRadius = 4;
    navigationView.layer.shadowOpacity = 0.5;
    navigationView.layer.shadowOffset = CGSizeMake(0,0);
    navigationView.backgroundColor = kMainBlueColor;
    UILabel *label = [[UILabel alloc] initWithFrame:navigationView.frame];
    label.text = @"功能菜单";
    label.font = [UIFont boldSystemFontOfSize:20];
    [label setTextColor:[UIColor whiteColor]];
    [navigationView addSubview:label];
    label.textAlignment = NSTextAlignmentCenter;
    [self.view addSubview:navigationView];
    
    UIView *headerView = [[UIView alloc]initWithFrame:CGRectMake(0, 0, RightWidth, NavigationHeight)];
    self.rightTableview.tableHeaderView = headerView;
}


- (UITableViewCell *)tableView:(UITableView *)tableView cellForRowAtIndexPath:(NSIndexPath *)indexPath
{
    RightControlTableViewCell *cell = [tableView dequeueReusableCellWithIdentifier:@"RightControlTableViewCell" forIndexPath:indexPath];
    cell.sectionTitle.text = self.subSectionArray[indexPath.section][indexPath.row];
    return cell;
    
}

- (NSInteger)tableView:(UITableView *)tableView numberOfRowsInSection:(NSInteger)section
{
    BOOL controlClose = [self.sectionClosedArray[section] boolValue];
    if (section == 3 || section == 4) {
        NSArray *subArray = self.subSectionArray[section];
        return controlClose?subArray.count:0;
    }
    return 0;
}

- (void)tableView:(UITableView *)tableView didSelectRowAtIndexPath:(NSIndexPath *)indexPath
{
    RightControlTableViewCell *cell = [tableView cellForRowAtIndexPath:indexPath];
    CGPoint point = [cell convertPoint:cell.sectionTitle.mj_origin toView:self.rightTableview];
    [self addInstructionsLine:point.y];
    [self closeSidebarAndPassEvents:self.subSectionArray[indexPath.section][indexPath.row]];
}

- (CGFloat)tableView:(UITableView *)tableView heightForRowAtIndexPath:(NSIndexPath *)indexPath
{
    return 60;
}

- (UIView *)tableView:(UITableView *)tableView viewForHeaderInSection:(NSInteger)section
{
    RightControlSectionView *sectionView = [tableView dequeueReusableHeaderFooterViewWithIdentifier:@"RightControlSectionView"];
    sectionView.sectionTitle.text = [self.dataArray objectAtIndex_opple:section];
    sectionView.sectionImageView.image = TCImage(self.imageArray[section]);
    sectionView.tag = section;
    [sectionView addGestureRecognizer:[[UITapGestureRecognizer alloc]initWithTarget:self action:@selector(sectionClickAction:)]];
    return sectionView;
}

- (CGFloat)tableView:(UITableView *)tableView heightForHeaderInSection:(NSInteger)section
{
    return 60;
}

- (CGFloat)tableView:(UITableView *)tableView heightForFooterInSection:(NSInteger)section
{
    return 0.01;
}

- (NSInteger)numberOfSectionsInTableView:(UITableView *)tableView
{
    return self.dataArray.count;
}

#pragma mark - section Click
- (void)sectionClickAction:(UITapGestureRecognizer *)sender
{
    NSInteger index = sender.view.tag;
    if (index == 3 ) {
        BOOL controlClose = [self.sectionClosedArray[index] boolValue];
        self.sectionClosedArray[index] = controlClose?@0:@1;
        [self.rightTableview reloadSections:[NSIndexSet indexSetWithIndex:index] withRowAnimation:UITableViewRowAnimationFade];
    }else{
        self.sectionClosedArray[3] = @0;
        NSMutableIndexSet *indexSet = [[NSMutableIndexSet alloc]init];
        [indexSet addIndex:3];
        [self.rightTableview reloadSections:indexSet withRowAnimation:UITableViewRowAnimationFade];
       [self closeSidebarAndPassEvents:self.dataArray[index]];
    }
    RightControlSectionView *sectionView = (RightControlSectionView *)sender.view;
    CGPoint point = [sender.view convertPoint:sectionView.sectionImageView.mj_origin toView:self.rightTableview];
    [self addInstructionsLine:point.y];
}

#pragma mark - 收起侧边栏并传递事件
- (void)closeSidebarAndPassEvents:(NSString *)name
{
    //收起右侧控制器
    [SHARED_APPDELEGATE.mmdrawer toggleDrawerSide:MMDrawerSideRight animated:YES completion:nil];
    if ([self.delegate respondsToSelector:@selector(SelectedControllerWithIndex:)]) {
        [self.delegate SelectedControllerWithIndex:name];
    }
}

#pragma mark - 添加指示线
- (void)addInstructionsLine:(CGFloat)offsetY
{
    WS(weakSelf);
    [UIView animateWithDuration:0.5 delay:0.1f usingSpringWithDamping:0.5f initialSpringVelocity:0.5f options:UIViewAnimationOptionCurveEaseInOut animations:^{
        weakSelf.lineView.frame = CGRectMake(0, offsetY, 10, 25);
    } completion:nil];
}

- (void)didReceiveMemoryWarning {
    [super didReceiveMemoryWarning];
    // Dispose of any resources that can be recreated.
}


@end
