//
//  EmigratedMainViewController.m
//  Lighting
//
//  Created by 曹云霄 on 2016/11/28.
//  Copyright © 2016年 上海勾芒科技有限公司. All rights reserved.
//

#import "EmigratedMainViewController.h"
#import "ThroughHistoryView.h"
#import "InstructionsViewController.h"
#import "AnswerViewController.h"

@interface EmigratedMainViewController ()<WYPopoverControllerDelegate,DismissDelegate>

@property (nonatomic,strong) WYPopoverController *popover;

/**
 闯关数据
 */
@property (nonatomic,strong) PassLevelResponse *emigratedResponse;

@end

@implementation EmigratedMainViewController


- (void)viewDidLoad {
    [super viewDidLoad];
    
    [self getThroughHistoryDatasAction];
}

#pragma mark - 获取闯关信息
- (void)getThroughHistoryDatasAction
{
    WS(weakSelf);
    PassLevelCondition *emigrated = [[PassLevelCondition alloc]init];
    emigrated.validEquals = YES;
    DataPage *page = [[DataPage alloc]init];
    page.page = ONE;
    page.rows = KROWS;
    emigrated.page = page;
    [XBLoadingView showHUDViewWithDefault];;
    [[NetworkRequestClassManager Manager] NetworkRequestWithURL:SERVERREQUESTURL(THROUGHLIST) WithRequestType:ZERO WithParameter:emigrated WithReturnValueBlock:^(id returnValue) {
        
        [XBLoadingView hideHUDViewWithDefault];
        if ([returnValue[@"code"] isEqualToNumber:@0]) {
            weakSelf.emigratedResponse = [[PassLevelResponse alloc]initWithDictionary:returnValue[@"data"] error:nil];
            [weakSelf setUpEmigratedItem];
        }else {
            [XBLoadingView hideHUDViewWithDefault];
        }
        
    }WithFailureBlock:^(NSError *error) {
        [XBLoadingView hideHUDViewWithDefault];
        [XBLoadingView showHUDViewWithText:error.localizedDescription];
    }];
}

#pragma mark - 开始
- (IBAction)beginButtonClickAction:(UIButton *)sender {
    
    CGFloat width = 100;
    CGFloat interval = 30;
    self.throughHistoryBackScrollView.contentSize = CGSizeMake(self.emigratedResponse.passLevelEntity.count*width+(self.emigratedResponse.passLevelEntity.count-1)*interval, 0);
    WS(weakSelf);
    [UIView animateWithDuration:0.2 animations:^{
        sender.alpha = 0;
        weakSelf.throughHistoryBackScrollView.alpha = 1;
    }];
}

#pragma mark - 设置闯关项
- (void)setUpEmigratedItem
{
    CGFloat width = 100;
    CGFloat height = 120;
    CGFloat interval = 30;
    for (int i=0; i<self.emigratedResponse.passLevelEntity.count; i++) {
        TOPassLevelEntity *entity = self.emigratedResponse.passLevelEntity[i];
        ThroughHistoryView *throughView = [ThroughHistoryView initializeView];
        throughView.tag = i;
        if ([[self class] isBlankString:entity.passResult]) {
            [throughView addGestureRecognizer:[[UITapGestureRecognizer alloc] initWithTarget:self action:@selector(selectApplicableAction:)]];
        }
        throughView.titleLabel.text = entity.title;
        throughView.endDateLabel.text = [[entity.endDate componentsSeparatedByString:@" "] firstObject];
        throughView.frame = CGRectMake(i*width+i*interval, 0, width, height);
        throughView.stateImageView.image = [self emigratedState:entity.passResult];
        [self.throughHistoryBackScrollView addSubview:throughView];
    }
}

#pragma mark - 选择相应的期数
- (void)selectApplicableAction:(UITapGestureRecognizer *)sender
{
    TOPassLevelEntity *entity = self.emigratedResponse.passLevelEntity[sender.view.tag];
    //判断闯关任务是否过期
    NSDateFormatter* dateFormat = [[NSDateFormatter alloc] init];
    dateFormat.locale = [[NSLocale alloc] initWithLocaleIdentifier:@"en_US"];
    [dateFormat setDateFormat:@"yyyy-MM-dd HH:mm:ss"];
    NSDate *date = [dateFormat dateFromString:entity.endDate];
    NSDate *date2 = [date dateByAddingTimeInterval:8 * 60 * 60];//手动增加8小时
    int result = [self compareOneDay:[NSDate date] withAnotherDay:date2];
    if (result == ONE) {
        [XBLoadingView showHUDViewWithText:@"已过期"];return;
    }
    AnswerViewController *answer = [[[self class] getLearningCenterStoryboardClass] instantiateViewControllerWithIdentifier:@"AnswerViewController"];
    answer.delegate = self;
    answer.passLevelId = entity.fid;
    answer.preferredContentSize = CGSizeMake(520, 400);
    [self showPopoverView:answer];
}

#pragma mark - <DismissDelegate>
#pragma mark - 做题完成
- (void)dismissController:(BOOL)animationed
{
    [self.popover dismissPopoverAnimated:animationed];
}

#pragma mark - 闯关完成
- (void)emigratedFinish
{
    [self getThroughHistoryDatasAction];
}

#pragma mark - 闯关说明
- (IBAction)instructionsButtonClickAction:(UIButton *)sender {
    
    InstructionsViewController *instruction = [[[self class] getLearningCenterStoryboardClass] instantiateViewControllerWithIdentifier:@"InstructionsViewController"];
    WS(weakSelf);
    [instruction setDismissSyntonyBlock:^{
        [weakSelf.popover dismissPopoverAnimated:YES];
    }];
    instruction.preferredContentSize = CGSizeMake(ScreenWidth/2, ScreenHeight/2);
    [self showPopoverView:instruction];
}

#pragma mark - 弹出框
- (void)showPopoverView:(BaseViewController *)controller
{
    self.popover = [[WYPopoverController alloc] initWithContentViewController:controller];
    self.popover.theme.fillBottomColor = [UIColor clearColor];
    self.popover.theme.fillTopColor = [UIColor clearColor];
    self.popover.theme.glossShadowColor = [UIColor clearColor];
    self.popover.delegate = self;
    [self.popover presentPopoverAsDialogAnimated:YES options:WYPopoverAnimationOptionFadeWithScale];
}

#pragma mark - 点击空白禁止收起
- (BOOL)popoverControllerShouldDismissPopover:(WYPopoverController *)popoverController
{
    return NO;
}

@end
