//
//  VideoListViewController.m
//  Lighting
//
//  Created by 曹云霄 on 2016/11/25.
//  Copyright © 2016年 上海勾芒科技有限公司. All rights reserved.
//

#import "VideoListViewController.h"
#import "VideoListItemTableViewCell.h"
#import "VideoListSectionHeaderView.h"
#import "PPTListItemTableViewCell.h"

@interface VideoListViewController ()<UITableViewDelegate,UITableViewDataSource>


@property (weak, nonatomic) IBOutlet UIView *headerView;

@end

@implementation VideoListViewController

- (void)viewDidLoad {
    [super viewDidLoad];
    
    [self setUpTableView];
}

#pragma mark - 刷新选中项
- (void)selectedIndexPath:(NSIndexPath *)indexPath withIsQualified:(BOOL)boolValue
{
    //考核状态
    RsStudyTask *studyEntity = self.datasArray[indexPath.section];
    CustomStudyEntity *studyList = studyEntity.studyTasks[indexPath.row];
    studyList.examResult = [NSString stringWithFormat:@"%d",boolValue];
    [self.studyListTableView reloadRowsAtIndexPaths:@[indexPath] withRowAnimation:UITableViewRowAnimationAutomatic];
    
    //播放状态
    UITableViewCell *cell = [self.studyListTableView cellForRowAtIndexPath:indexPath];
    if ([cell isKindOfClass:[PPTListItemTableViewCell class]]) {
        PPTListItemTableViewCell *pptCell = (PPTListItemTableViewCell *)cell;
        pptCell.pptButton.selected = YES;
    }else if ([cell isKindOfClass:[VideoListItemTableViewCell class]]) {
        VideoListItemTableViewCell *videoCell = (VideoListItemTableViewCell *)cell;
        videoCell.playButton.selected = YES;
    }
}


#pragma mark - 数据源
- (void)setDatasArray:(NSMutableArray *)datasArray
{
    _datasArray = datasArray;
    [self.studyListTableView reloadData];
}

#pragma mark - UITableView
- (void)setUpTableView
{
    self.studyListTableView.tableFooterView = [UIView new];
    self.studyListTableView.rowHeight = 50;
    self.studyListTableView.sectionHeaderHeight = 60;
    self.studyItemTitleLabel.text = self.studyItemTitle;
}

#pragma mark - <UITableViewDelegate,UITableViewDataSource>
- (UITableViewCell *)tableView:(UITableView *)tableView cellForRowAtIndexPath:(NSIndexPath *)indexPath
{
    RsStudyTask *studyEntity = self.datasArray[indexPath.section];
    CustomStudyEntity *studyList = studyEntity.studyTasks[indexPath.row];
    if ([studyList.attachment.fileUrl rangeOfString:@".ppt"].location != NSNotFound) {
        PPTListItemTableViewCell *pptItemCell = [tableView dequeueReusableCellWithIdentifier:@"PPTListItemTableViewCell" forIndexPath:indexPath];
        pptItemCell.model = studyList;
        return pptItemCell;
    }else if ([studyList.attachment.fileUrl rangeOfString:@".mp4"].location != NSNotFound){
        VideoListItemTableViewCell *videoItemCell = [tableView dequeueReusableCellWithIdentifier:@"VideoListItemTableViewCell" forIndexPath:indexPath];
        videoItemCell.model = studyList;
        return videoItemCell;
    }
    return [UITableViewCell new];
}

- (NSInteger)tableView:(UITableView *)tableView numberOfRowsInSection:(NSInteger)section
{
    RsStudyTask *studyTask = self.datasArray[section];
    return studyTask.studyTasks.count;
}

- (NSInteger)numberOfSectionsInTableView:(UITableView *)tableView
{
    return self.datasArray.count;
}

- (UIView *)tableView:(UITableView *)tableView viewForHeaderInSection:(NSInteger)section
{
    VideoListSectionHeaderView *headerView = [tableView dequeueReusableCellWithIdentifier:@"VideoListSectionHeaderView"];
    headerView.studyItemSectionLabel.text = [self.datasArray[section] categoryName];
    return headerView;
}

- (void)tableView:(UITableView *)tableView didSelectRowAtIndexPath:(NSIndexPath *)indexPath
{
    //如果已经选中再次点击无效
    UITableViewCell *playCell = [tableView cellForRowAtIndexPath:indexPath];
    if ([playCell isKindOfClass:[PPTListItemTableViewCell class]]) {
        PPTListItemTableViewCell *pptCell = (PPTListItemTableViewCell *)playCell;
        if (pptCell.pptButton.selected) {
            return;
        }
    }else if ([playCell isKindOfClass:[VideoListItemTableViewCell class]]) {
        VideoListItemTableViewCell *videoCell = (VideoListItemTableViewCell *)playCell;
        if (videoCell.playButton.selected) {
            return;
        }
    }
    //取消所有选中状态
    for (UITableViewCell *cell in self.studyListTableView.visibleCells) {
        if ([cell isKindOfClass:[PPTListItemTableViewCell class]]) {
            PPTListItemTableViewCell *pptCell = (PPTListItemTableViewCell *)cell;
            pptCell.pptButton.selected = NO;
        }
        if ([cell isKindOfClass:[VideoListItemTableViewCell class]]) {
            VideoListItemTableViewCell *videoCell = (VideoListItemTableViewCell *)cell;
            videoCell.playButton.selected = NO;
        }
    }
    if ([self.delegate respondsToSelector:@selector(seleStudyItemCellIndex:)]) {
        [self.delegate seleStudyItemCellIndex:indexPath];
    }
}

#pragma mark - 视频播放百分比
- (void)videoPlayProportion:(NSInteger)proportion withIndexPath:(NSIndexPath *)indexPath
{
    VideoListItemTableViewCell *videoPlayCell = [self.studyListTableView cellForRowAtIndexPath:indexPath];
    RsStudyTask *studyEntity = self.datasArray[indexPath.section];
    CustomStudyEntity *studyList = studyEntity.studyTasks[indexPath.row];
    studyList.attachment.playPercent = [NSString stringWithFormat:@"%ld",proportion];
    [videoPlayCell.studyProgressView updateChartByCurrent:@(proportion)];
    NSLog(@"%ld",proportion);
}


@end
