//
//  AssessmentUnqualifiedViewController.m
//  Lighting
//
//  Created by 曹云霄 on 2016/12/6.
//  Copyright © 2016年 上海勾芒科技有限公司. All rights reserved.
//

#import "AssessmentUnqualifiedViewController.h"

@interface AssessmentUnqualifiedViewController ()

/**
 重新开始
 */
@property (weak, nonatomic) IBOutlet UIButton *startAgainButton;

@end

@implementation AssessmentUnqualifiedViewController

- (void)viewDidLoad {
    [super viewDidLoad];
    
    self.startAgainButton.enabled = self.opportunityCount;
    [self.startAgainButton setTitleColor:self.opportunityCount?kMainBlueColor:kMainGrayColor forState:UIControlStateNormal];
    NSMutableAttributedString *attributedString = [[NSMutableAttributedString alloc]initWithString:[NSString stringWithFormat:@"您的得分为 %@",self.allScore]];
    NSRange range = NSMakeRange(attributedString.length-[self.allScore length], [self.allScore length]);    [attributedString addAttribute:NSForegroundColorAttributeName value:[UIColor redColor] range:range];
    [attributedString addAttribute:NSFontAttributeName value:[UIFont fontWithName:@"HelveticaNeue-Bold" size:25] range:range];
    self.scoreLabel.attributedText = attributedString;
    NSMutableAttributedString *attributed = [[NSMutableAttributedString alloc]initWithString:[NSString stringWithFormat:@"考核不通过！(%ld次重考机会)",self.opportunityCount]];
    NSString *string = [NSString stringWithFormat:@"(%ld次重考机会)",self.opportunityCount];
    NSRange newRange = NSMakeRange(attributed.length-[string length], [string length]);
    [attributed addAttribute:NSForegroundColorAttributeName value:[UIColor darkGrayColor] range:newRange];
    [attributed addAttribute:NSFontAttributeName value:[UIFont fontWithName:@"HelveticaNeue-Light" size:13] range:newRange];
    self.unQualifiedLabel.attributedText = attributed;
}


#pragma mark - 重新开始
- (IBAction)startAgainButtonClickAction:(UIButton *)sender {
    
    if ([self.delgate respondsToSelector:@selector(startAgainAction)]) {
        [self.delgate startAgainAction];
    }
}

#pragma mark - 在学一遍
- (IBAction)continueLearnButtonClickAction:(UIButton *)sender {
    
    if ([self.delgate respondsToSelector:@selector(learnAgainAction)]) {
        [self.delgate learnAgainAction];
    }
}



@end
