//
//  ContentTableViewCell.h
//  Lighting
//
//  Created by 曹云霄 on 2016/12/9.
//  Copyright © 2016年 上海勾芒科技有限公司. All rights reserved.
//

#import <UIKit/UIKit.h>
#import "KeyBoardAccessoryView.h"


@protocol ExtensionViewTapDelegate <NSObject>
@required

/**
 拍照
 */
- (void)showCameraAction;

/**
 相册选择
 */
- (void)showPhotoAlbumAction;

/**
 刷新高度
 */
- (void)refreshHeight:(CGFloat)height;

@end


/**
 扩展项

 - Camera:     相机
 - PhotoAlbum: 相册
 - Emoji:      表情
 */
typedef NS_ENUM(NSInteger,ItemIndex){
    Camera = 0,
    PhotoAlbum,
    Emoji,
};

@interface ContentTableViewCell : UITableViewCell<ExtensionDelegate,UITextViewDelegate>
@property (nonatomic,weak) id<ExtensionViewTapDelegate>delgate;

/**
 textView 高度
 */
@property (weak, nonatomic) IBOutlet NSLayoutConstraint *heightConstraint;

/**
 内容
 */
@property (weak, nonatomic) IBOutlet ICRPlaceholderTextView *contentTextView;

@end
