//
//  CardDetailsViewController.m
//  Lighting
//
//  Created by 曹云霄 on 2016/10/19.
//  Copyright © 2016年 上海勾芒科技有限公司. All rights reserved.
//

#import "CardDetailsViewController.h"
#import "CardDontUseViewController.h"
#import "CardBeenUseViewController.h"

@interface CardDetailsViewController ()

/**
 *  当前的控制器
 */
@property (nonatomic,strong) UIViewController *currentVC;

/**
 指示线约束
 */
@property (weak, nonatomic) IBOutlet NSLayoutConstraint *instructionViewConstraint;

@end

@implementation CardDetailsViewController

- (void)viewDidLoad {
    [super viewDidLoad];
    
    [self addChildViewController];
}

#pragma mark - 添加卡劵详情vc
- (void)addChildViewController
{
    /// 未领取
    CardDontUseViewController *dontUseVc = [[[self class] getMainStoryboardClass] instantiateViewControllerWithIdentifier:@"CardDontUseViewController"];
    [self addChildViewController:dontUseVc];
    /// 已领取
    CardBeenUseViewController *beenUseVc = [[[self class] getMainStoryboardClass] instantiateViewControllerWithIdentifier:@"CardBeenUseViewController"];
    // 审批中
    CardBeenUseViewController *examineUseVc = [[[self class] getMainStoryboardClass]instantiateViewControllerWithIdentifier:@"CardBeenUseViewController"];
    examineUseVc.cardState = CHECK;
    [self addChildViewController:examineUseVc];

    beenUseVc.cardState = ACTIVED;
    [self addChildViewController:beenUseVc];
    /// 已使用
    CardBeenUseViewController *usedVc = [[[self class] getMainStoryboardClass] instantiateViewControllerWithIdentifier:@"CardBeenUseViewController"];
    usedVc.cardState = USED;
    [self addChildViewController:usedVc];
    [self.cardBackgroundView addSubview:dontUseVc.view];
    self.currentVC = dontUseVc;
}

#pragma mark - 布局
- (void)viewDidLayoutSubviews
{
    CardDontUseViewController *dontUseVc = self.childViewControllers[0];
    dontUseVc.view.frame = CGRectMake(0, 0, self.cardBackgroundView.mj_w, self.cardBackgroundView.mj_h);

    CardBeenUseViewController *beenUseVc = self.childViewControllers[1];
    beenUseVc.view.frame = CGRectMake(0, 0, self.cardBackgroundView.mj_w, self.cardBackgroundView.mj_h);

    CardBeenUseViewController *examineUseVc = self.childViewControllers[2];
    examineUseVc.view.frame = CGRectMake(0, 0, self.cardBackgroundView.mj_w, self.cardBackgroundView.mj_h);

    CardBeenUseViewController *usedVc = self.childViewControllers[3];
    usedVc.view.frame = CGRectMake(0, 0, self.cardBackgroundView.mj_w, self.cardBackgroundView.mj_h);
}


#pragma mark - 切换已使用卡劵、未使用卡劵
- (void)switchPaymentsVCAndWithdrawalVC:(UIViewController *)newViewController
{
    [self transitionFromViewController:self.currentVC toViewController:newViewController duration:0.5 options:UIViewAnimationOptionTransitionNone animations:nil completion:^(BOOL finished) {
        if (finished) {
            [self.cardBackgroundView addSubview:newViewController.view];
            self.currentVC = newViewController;
        }
    }];
}

#pragma mark - 切换ContentController
- (IBAction)paymentsButtonAndWithdrawalButtonClick:(UIButton *)sender {
    
    for (id object in self.view.subviews) {
        if ([object isKindOfClass:[UIButton class]]) {
            UIButton *button = (UIButton *)object;
            button.selected = NO;
        }
    }
    sender.selected = YES;
    [self setupInstructionsViewOrigin:sender];
    [self switchPaymentsVCAndWithdrawalVC:self.childViewControllers[sender.tag-100]];
}

#pragma mark - 设置指示线的位置
- (void)setupInstructionsViewOrigin:(UIButton *)sender
{
    self.instructionViewConstraint.constant = sender.x+16;
    [UIView animateWithDuration:0.5 delay:0.1f usingSpringWithDamping:0.5f initialSpringVelocity:0.5f options:UIViewAnimationOptionCurveEaseInOut animations:^{
        [self.view layoutIfNeeded];
    } completion:nil];
}

- (void)didReceiveMemoryWarning {
    [super didReceiveMemoryWarning];
}


@end
