//
//  BindingSuccessViewController.m
//  Lighting
//
//  Created by 曹云霄 on 2016/11/30.
//  Copyright © 2016年 上海勾芒科技有限公司. All rights reserved.
//

#import "BindingSuccessViewController.h"
#import "UIButton+countDown.h"

@interface BindingSuccessViewController ()

@end

@implementation BindingSuccessViewController

- (void)viewDidLoad {
    [super viewDidLoad];
    
    [self setUpUIAction];
    [self sendVerificationCodeAction];
}

#pragma mark - UI
- (void)setUpUIAction
{
    self.mobileNumberLabel.text = [NSString stringWithFormat:@"请输入%@接收到的验证码",[self phoneNumberEncryption:self.bankEntity.phoneNumber]];
    self.bankNameAndCardTypeLabel.text = self.bankType;
}

#pragma mark - 发送验证码
- (void)sendVerificationCodeAction
{
    WS(weakSelf);
    [XBLoadingView showHUDViewWithDefault];
    //发送验证码
    NSString *urlString = [NSString stringWithFormat:SERVERREQUESTURL(SENDSMSBANK),self.bankEntity.phoneNumber,[Shoppersmanager manager].Shoppers.employee.userName];
    [[NetworkRequestClassManager Manager] NetworkWithDictionaryRequestWithURL:[self returnUrlString:urlString]  WithRequestType:ONE WithParameter:nil WithReturnValueBlock:^(id returnValue) {
        [XBLoadingView hideHUDViewWithDefault];
        if ([returnValue[@"code"] isEqualToNumber:@0]) {
            [XBLoadingView showHUDViewWithSuccessText:@"发送成功" completeBlock:^{
                [weakSelf.sendButton startWithTime:60 title:@"获取验证码" countDownTitle:@"秒后重发" mainColor:kMainBlueColor countColor:kMainBlueColor];
            }];
        }else
        {
            [XBLoadingView showHUDViewWithText:returnValue[@"message"]];
        }
    }WithFailureBlock:^(NSError *error) {
        [XBLoadingView hideHUDViewWithDefault];
        [XBLoadingView showHUDViewWithText:error.localizedDescription];
    }];
}

#pragma mark -汉字转码
- (NSString *)returnUrlString:(NSString *)ChineseString
{
    NSString* encodedString = [ChineseString stringByAddingPercentEncodingWithAllowedCharacters:[NSCharacterSet URLQueryAllowedCharacterSet]];
    return encodedString;
}

#pragma mark - 绑定
- (IBAction)nextButtonClickAction:(UIButton *)sender {
    
    if (!self.isAgreeButton.selected) {
        [XBLoadingView showHUDViewWithText:@"需要同意用户协议"];return;
    }
    if ([[self class] isBlankString:self.verificationCodeTextField.text]) {
        [XBLoadingView showHUDViewWithText:@"验证码不能为空"];
    }
    TOBankBindEntity *entity = [[TOBankBindEntity alloc] init];
    entity.bankAccount = self.bankEntity.bankAccount;
    entity.accountName = self.bankEntity.accountName;
    entity.identityCode = self.bankEntity.identityCode;
    entity.phoneNumber = self.bankEntity.phoneNumber;
    entity.smsCode = self.verificationCodeTextField.text;
    entity.bankCardType = self.bankType;
    WS(weakSelf);
    [[NetworkRequestClassManager Manager] NetworkRequestWithURL:SERVERREQUESTURL(BINDING) WithRequestType:ZERO WithParameter:entity WithReturnValueBlock:^(id returnValue) {
        
        if ([returnValue[@"code"] isEqualToNumber:@0]) {
            [XBLoadingView showHUDViewWithSuccessText:@"绑定成功" completeBlock:^{
                [weakSelf.navigationController popToRootViewControllerAnimated:YES];
            }];
        }else {
            [XBLoadingView showHUDViewWithText:returnValue[@"message"]];
        }
        
    } WithFailureBlock:^(NSError *error) {
        [XBLoadingView hideHUDViewWithDefault];
        [XBLoadingView showHUDViewWithText:error.localizedDescription];
    }];
}

#pragma mark - 用户协议
- (IBAction)userAgreementButton:(UIButton *)sender {
    
}

#pragma mark - 是否同意用户协议
- (IBAction)isAgreeButtonClickAction:(UIButton *)sender {
    sender.selected = !sender.selected;
}

#pragma mark - 发送验证码
- (IBAction)sendVerificationCodeButtonClick:(UIButton *)sender {
    
    [self sendVerificationCodeAction];
}

#pragma mark - 手机号加密
- (NSString *)phoneNumberEncryption:(NSString *)phoneNumber
{
    return [phoneNumber stringByReplacingCharactersInRange:NSMakeRange(3, 4) withString:@"****"];
}


@end
