//
//  SettlementViewController.m
//  Lighting
//
//  Created by 曹云霄 on 16/5/11.
//  Copyright © 2016年 上海勾芒科技有限公司. All rights reserved.
//

#import "SettlementViewController.h"

@interface SettlementViewController ()<ReturnTableviewcellIndexpathdelegate>

@end

@implementation SettlementViewController

- (void)viewDidLoad {
    [super viewDidLoad];
    
    [self uiConfigAction];
}




#pragma mark -布局
- (void)uiConfigAction
{
    self.goodsAllNumberBackvie.layer.masksToBounds = YES;
    self.goodsAllNumberBackvie.layer.cornerRadius = kCornerRadius;
    self.goodsAllpriceBackView.layer.masksToBounds = YES;
    self.goodsAllpriceBackView.layer.cornerRadius = kCornerRadius;
    self.payTypeButton.layer.masksToBounds = YES;
    self.payTypeButton.layer.cornerRadius = kCornerRadius;
    self.WeixiPayButton.layer.masksToBounds = YES;
    self.WeixiPayButton.layer.cornerRadius = kCornerRadius;
    self.payTreasureButton.layer.masksToBounds = YES;
    self.payTreasureButton.layer.cornerRadius = kCornerRadius;
    self.ISinvoiceButton.layer.masksToBounds = YES;
    self.ISinvoiceButton.layer.cornerRadius = kCornerRadius;
    self.invoiceType.layer.masksToBounds = YES;
    self.invoiceType.layer.cornerRadius = kCornerRadius;
    self.invoiceBackView.layer.masksToBounds = YES;
    self.invoiceBackView.layer.cornerRadius = kCornerRadius;
    
}



#pragma mark -支付总金额，商品总数量
- (void)setGoodsArray:(NSArray *)goodsArray
{
    _goodsArray = goodsArray;
    
    NSInteger goodsAllNumber = 0;//总数量
    NSInteger goodAllprice = 0;//总价格
    for (TOOrderdetailEntity *model in _goodsArray) {
        goodsAllNumber += [model.goodsNum integerValue];
        goodAllprice += [model.goodsPrice integerValue];
    }
    self.goodsAllNumber.text = [NSString stringWithFormat:@"%ld",goodsAllNumber];
    self.goodsAllPrice.text = [NSString stringWithFormat:@"%ld元",goodAllprice];
}




- (void)viewWillAppear:(BOOL)animated
{
    self.view.superview.layer.cornerRadius = 0;
}



#pragma mark -取消支付
- (IBAction)CancelButtonClick:(UIButton *)sender {
    
    [self dismissViewControllerAnimated:YES completion:nil];
}


#pragma mark -确认支付
- (IBAction)SureButtonClick:(UIButton *)sender {
    
    
    [self SurePayRequest];
}

#pragma amrk -支付方式选择
- (IBAction)payTypeButtonClick:(UIButton *)sender {
    
    NSArray *arr = @[@"现金",@"支票",@"转账"];
    [self ShowPopoverViewController:CGSizeMake(100, 200) Withdatas:arr ShowButton:sender SelectedIndex:0 GetTitle:YES];
}


#pragma mark -是否开票
- (IBAction)isinvoiceButtonClick:(UIButton *)sender {
    
    NSArray *arr = @[@"是",@"否"];
    [self ShowPopoverViewController:CGSizeMake(50, 150) Withdatas:arr ShowButton:sender SelectedIndex:1 GetTitle:YES];
}


#pragma mark -发票类型
- (IBAction)invoiceTypeButtonClick:(UIButton *)sender {
    
    NSArray *arr = @[@"个人发票",@"公司发票"];
    [self ShowPopoverViewController:CGSizeMake(100, 150) Withdatas:arr ShowButton:sender SelectedIndex:2 GetTitle:YES];
}



#pragma mark -弹出popover视图控制器
- (void)ShowPopoverViewController:(CGSize)size Withdatas:(NSArray *)datasArray ShowButton:(UIButton *)button SelectedIndex:(NSInteger)index GetTitle:(BOOL )istitle
{
    
    PopoverViewController *popover = [[PopoverViewController alloc]init];
    popover.datasArray = datasArray;
    popover.delegate = self;
    popover.Selectedindex = index;
    popover.isString = YES;
    popover.contentSize = size;
    popover.preferredContentSize = size;
    popover.modalPresentationStyle = UIModalPresentationPopover;
    UIPopoverPresentationController *pop = popover.popoverPresentationController;
    pop.permittedArrowDirections = UIPopoverArrowDirectionUp;
    pop.sourceView = popover.view;
    pop.barButtonItem = [[UIBarButtonItem alloc]initWithCustomView:button];
    [self presentViewController:popover animated:YES completion:nil];
}



/**
 *  选中筛选条件对象typecode
 *
 *  @param index NSString
 */
- (void)returnCellindexpathwithrow:(NSString *)Type WithcellTitle:(NSString *)title Withselected:(NSInteger)Selected
{
    [self dismissViewControllerAnimated:YES completion:nil];
    switch (Selected) {
        case 0://支付方式
        {
            [self.payTypeButton setTitle:title forState:UIControlStateNormal];
        }
            break;
        case 1://是否开票
        {
            [self.ISinvoiceButton setTitle:title forState:UIControlStateNormal];
        }
            break;
        case 2://发票类型
        {
            [self.invoiceType setTitle:title forState:UIControlStateNormal];
        }
            break;
            
        default:
            break;
    }
}






#pragma mark -确认支付请求
- (void)SurePayRequest
{
    NSString *string = [NSString stringWithFormat:@"%@%@%@/%@/%@/%@/%@",ServerAddress,@"/order/payOrder/",_orderCode,[self ReturnUrlString:self.payTypeButton.currentTitle],[self ReturnUrlString:self.ISinvoiceButton.currentTitle],[self ReturnUrlString:self.invoiceType.currentTitle],[self ReturnUrlString:self.invoiceHeader.text]];
    
    [[NetworkRequestClassManager Manager] NetworkWithDictionaryRequestWithURL:string WithRequestType:1 WithParameter:nil WithReturnValueBlock:^(id returnValue) {
        
        NSLog(@"%@",returnValue);
        
    } WithErrorCodeBlock:^(id errorCodeValue) {
        
        
    } WithFailureBlock:^(id error) {
        
        NSLog(@"%@",error);
    }];
}


#pragma mark -汉字转码
- (NSString *)ReturnUrlString:(NSString *)ChineseString
{
    NSString* encodedString = [ChineseString stringByAddingPercentEncodingWithAllowedCharacters:[NSCharacterSet URLQueryAllowedCharacterSet]];
    return encodedString;
}



- (void)didReceiveMemoryWarning {
    [super didReceiveMemoryWarning];
    // Dispose of any resources that can be recreated.
}

/*
#pragma mark - Navigation

// In a storyboard-based application, you will often want to do a little preparation before navigation
- (void)prepareForSegue:(UIStoryboardSegue *)segue sender:(id)sender {
    // Get the new view controller using [segue destinationViewController].
    // Pass the selected object to the new view controller.
}
*/

@end
