//
//  RightSubView.m
//  Lighting
//
//  Created by mac on 16/5/10.
//  Copyright © 2016年 上海勾芒科技有限公司. All rights reserved.
//

#import "RightSubView.h"

@implementation RightSubView
- (instancetype)initWithFrame:(CGRect)frame
{
    if (self = [super initWithFrame:frame]) {
         
        [self initdata];
        [self initSubView];
    }
    return self;
}
-(void)initdata
{
    self.dataArray=[[NSMutableArray alloc]initWithObjects:@"1",@"2",@"3",nil];
    
//    待接收
}
-(void)initSubView
{
    UIButton *button=[UIButton buttonWithType:UIButtonTypeCustom];
    button.frame=CGRectMake(self.frame.size.width-100, self.frame.size.height-60, 60, 60);
    button.tag=300;
    [button setBackgroundImage:[UIImage imageNamed:@"产品1"] forState:UIControlStateNormal];
    [button addTarget:self action:@selector(rightBtnDidSelected:) forControlEvents:UIControlEventTouchUpInside];
    [self addSubview:button];
    self.scrollView=[[UIScrollView alloc]initWithFrame:CGRectMake(0, 0, self.frame.size.width, self.frame.size.height-100)];
    // contentSize的y值为0表示在垂直方向上不做滚动
    self.scrollView.contentSize = CGSizeMake(0, (self.dataArray.count+1) * (100+10));
    for (int i=0; i<self.dataArray.count; i++) {
        
        UIButton *button=[[UIButton alloc]initWithFrame:CGRectMake(80, 20+i*(100+10), 100, 100)];
        NSString *imageName = [NSString stringWithFormat:@"05产品库-详情_03" ];
        [button setImage:[UIImage imageNamed:imageName] forState:UIControlStateNormal];
        button.tag=100+i;
        [button addTarget:self action:@selector(clicked:) forControlEvents:UIControlEventTouchUpInside];
        UILongPressGestureRecognizer *longPressGR =
        [[UILongPressGestureRecognizer alloc] initWithTarget:self action:@selector(longPress)];
        longPressGR.minimumPressDuration = 0.5;
        [button addGestureRecognizer:longPressGR];
        
        [self.scrollView addSubview:button];
//        UIImageView *imageView = [[UIImageView alloc] init];
//        // 定义图片名，通过循环把所有的图片添加到scrollView中
//        NSString *imageName = [NSString stringWithFormat:@"05产品库-详情_03" ];
//        imageView.frame = CGRectMake(80, 20+i*(100+10), 100, 100);
//        imageView.image = [UIImage imageNamed:imageName];
//        [self.scrollView addSubview:imageView];
    }
    // 禁用滚动条，只设置水平方向的滚动条即可，竖直方向的滚动范围是0，所以没必要设置
    self.scrollView.showsVerticalScrollIndicator = NO;
    [self addSubview:self.scrollView];

}
//单次点击
-(void)clicked:(UIButton*)sender
{
    NSLog(@"%d",(sender.tag));
    if ([self.delegate respondsToSelector:@selector(addProductImage:)]) {
        
        [self.delegate addProductImage:sender.imageView.image];
    }
    
    //    resetSuperBackGroundImage
}
//长按
-(void)longPress
{
    NSLog(@"长按");
}

-(void)rightBtnDidSelected:(UIButton *)sender
{
    if ([self.delegate respondsToSelector:@selector(buttonClick:withButton:)]) {
        
        [self.delegate buttonClick:sender.tag withButton:sender];
    }

}
/*
// Only override drawRect: if you perform custom drawing.
// An empty implementation adversely affects performance during animation.
- (void)drawRect:(CGRect)rect {
    // Drawing code
}
*/

@end
