//
//  ProductLibraryView.m
//  Lighting
//
//  Created by mac on 16/5/11.
//  Copyright © 2016年 上海勾芒科技有限公司. All rights reserved.
//

#import "ProductLibraryView.h"

@implementation ProductLibraryView
- (instancetype)initWithFrame:(CGRect)frame
{
    if (self = [super initWithFrame:frame]) {
        [self initdata];
        [self initSubView];
    }
    return self;
}
-(void)initdata
{
    self.arrayData=[[NSMutableArray alloc]init];
    self.nameData=[[NSMutableArray alloc]initWithObjects:@"风格",@"类型",@"空间",@"材质",@"价格", @"",@"高级",nil];
    self.array1=[[NSMutableArray alloc]initWithObjects:@"吊灯",@"壁灯",@"台灯",@"落地灯",@"吸顶灯", @"镜前灯",@"烛台灯",@"过厅灯",@"过道灯",@"商业照明",@"家具饰品",@"其他",nil];
    self.array2=[[NSMutableArray alloc]initWithObjects:@"水晶系列",@"金属系列",@"商照电工",@"陶瓷",@"木艺", @"其它",nil];
    self.array3=[[NSMutableArray alloc]initWithObjects:@"田园",@"宫廷",@"乡村",@"日式风格",@"欧式风格", @"混搭风格",@"现代简约",nil];
    self.arrayData=self.array3;
}

-(void)initSubView
{
    for (int i=0; i<self.nameData.count; i++) {
        if (i !=5) {
            UIButton *btn=[UIButton buttonWithType:UIButtonTypeCustom];
            btn.frame=CGRectMake(ScreenWidth-190, 52+i*50, 50, 46) ;
            btn.backgroundColor=[UIColor whiteColor];
            [btn setTitle:[self.nameData objectAtIndex:i] forState:UIControlStateNormal];
            [btn setTitleColor:[UIColor blackColor] forState:UIControlStateNormal];
//            btn.contentEdgeInsets = UIEdgeInsetsMake(0, 60, 0, 0);
            [btn addTarget:self action:@selector(selectedType:) forControlEvents:UIControlEventTouchUpInside];
            btn.tag=100 +i;
            btn.layer.masksToBounds = YES;
            btn.layer.cornerRadius = 23;
            [self addSubview:btn];
        }
       
    }
    self.subView=[[UIView alloc]initWithFrame:CGRectMake(100, 50, ScreenWidth-300, ScreenHeight-200)];
    self.subView.backgroundColor=[UIColor whiteColor];
    [self  addSubview:self.subView];

    //点击手势
    UITapGestureRecognizer *tap = [[UITapGestureRecognizer alloc]initWithTarget:self action:@selector(DismissScreenView:)];
    tap.delegate = self;
    tap.cancelsTouchesInView = NO;
    [[UIApplication sharedApplication].keyWindow addGestureRecognizer:tap];
    [self initSubViews];
}


-(void)initSubViews
{
    self.headerView=[[UIView alloc]initWithFrame:CGRectMake(0, 0, self.subView.frame.size.width-100, 50)];
    self.headerView.backgroundColor=[UIColor grayColor];
    [self.subView addSubview:self.headerView];
    UIButton *btn=[UIButton buttonWithType:UIButtonTypeCustom];
    btn.frame=CGRectMake(10, 10, 30, 30);
    [btn setBackgroundImage:[UIImage imageNamed:@"changjingtubiao"] forState:UIControlStateNormal];
    [self.headerView addSubview:btn];
    UILabel *lable=[[UILabel alloc]initWithFrame:CGRectMake(45, 10, 100, 30)];
    lable.text=@"选择产品";
    [self.headerView addSubview:lable];
    self.seceneTableView=[[UITableView alloc]initWithFrame:CGRectMake( self.headerView.frame.size.width, 0, 100, self.subView.frame.size.height)];
    self.seceneTableView.delegate=self;
    self.seceneTableView.dataSource=self;
    [self.subView addSubview:self.seceneTableView];
    
    self.pictureTableView=[[UITableView alloc]initWithFrame:CGRectMake( 0, 50, self.headerView.frame.size.width, self.subView.frame.size.height-50)];
    self.pictureTableView.delegate=self;
    self.pictureTableView.dataSource=self;
    [self.subView addSubview:self.pictureTableView];
}
-(void)selectedType:(UIButton *)sender
{

            switch (sender.tag) {
                case 100:
                    //            风格
                    self.arrayData=self.array3;
                    break;
                case 101:
                    //            类型
                    self.arrayData=self.array2;
                    break;
                case 102:
                    //            空间
                    self.arrayData=self.array1;
                    break;
                case 103:
                    //            材质
                    self.arrayData=self.array3;
                    break;
                case 104:
                    //            价格
                    self.arrayData=self.array3;
                    break;
                case 106:
                    //            高级
                    self.arrayData=self.array3;
                    break;
                default:
                    break;
            }
    [self.seceneTableView reloadData];
}
#pragma mark - 协议方法
- (NSInteger)numberOfSectionsInTableView:(UITableView *)tableView {
    return 1;
}
- (NSInteger)tableView:(UITableView *)tableView numberOfRowsInSection:(NSInteger)section
{    if ([tableView isEqual:self.seceneTableView])
{
    return self.arrayData.count;
}else
{
    return 5;
}
    
}
- (CGFloat)tableView:(UITableView *)tableView heightForRowAtIndexPath:(NSIndexPath *)indexPath
{
    if ([tableView isEqual:self.seceneTableView])
    {
        return 50;
    }else
    {
        return 150;
    }
    
    
}


- (UITableViewCell *)tableView:(UITableView *)tableView cellForRowAtIndexPath:(NSIndexPath *)indexPath
{
    if ([tableView isEqual:self.seceneTableView])
    {
        static NSString *cellID = @"ChooseTansferCell";
        UITableViewCell *cell = [tableView dequeueReusableCellWithIdentifier:cellID];
        if (cell == nil) {
            cell = [[UITableViewCell alloc]initWithStyle:UITableViewCellStyleDefault reuseIdentifier:cellID];
         
        }
        
        cell.textLabel.text=[self.arrayData objectAtIndex:indexPath.row];
        
        return cell;
    }else
    {
        
        static NSString *CellID = @"TansferCell";
        CustomPictureShowCell *cell = [tableView dequeueReusableCellWithIdentifier:CellID];
        if (cell == nil) {
            cell = [[CustomPictureShowCell alloc]initWithStyle:UITableViewCellStyleDefault reuseIdentifier:CellID withImageName:nil];
            cell.selectionStyle = UITableViewCellSelectionStyleNone;
        }
        cell.pictureView1.image=[UIImage imageNamed:@"05产品库-详情_03"];
        cell.pictureView2.image=[UIImage imageNamed:@"05产品库-详情_03"];
        cell.pictureView3.image=[UIImage imageNamed:@"05产品库-详情_03"];
        
        return cell;
    }
    
}

- (void)tableView:(UITableView *)tableView didSelectRowAtIndexPath:(NSIndexPath *)indexPath
{
    
}

-(void)DismissScreenView:(UITapGestureRecognizer*)sender{
    CGPoint point = [sender locationInView:self];
    if (point.x<100 || point.x >ScreenWidth-100||point.y<50||point.y>ScreenHeight-150) {
        
        if (self) {
            [self removeFromSuperview];
        }
    }
}

/*
// Only override drawRect: if you perform custom drawing.
// An empty implementation adversely affects performance during animation.
- (void)drawRect:(CGRect)rect {
    // Drawing code
}
*/

@end
