
#import <Foundation/Foundation.h>
#import "JSONModel.h"


/**
 *  评分方法。
 *
 *  @author thor
 *
 */
/**
 * 自动
 */
extern NSString * const GRADEMETHOD_AUTO;
/**
 * 人工
 */
extern NSString * const GRADEMETHOD_MANUL;




/**
 *  @author wolv
 *
 */
/**
 *
 */
extern NSString * const TOPRIZEBILLENTITYSTATE_REQUESTED;
/**
 *
 */
extern NSString * const TOPRIZEBILLENTITYSTATE_SHIPPED;
/**
 *
 */
extern NSString * const TOPRIZEBILLENTITYSTATE_DONE;




/**
 *  @Description: TODO(排序定义)
 *  asc 升序
 *  @author  张代浩
 *  desc 降序
 */
/**
 *
 */
extern NSString * const SORTDIRECTION_ASC;
/**
 *
 */
extern NSString * const SORTDIRECTION_DESC;




/**
 *  题目类型。
 *
 *  @author thor
 *
 */
/**
 * 单选题
 */
extern NSString * const PASSLEVELTOPICTYPE_SINGLE;
/**
 * 多选题
 */
extern NSString * const PASSLEVELTOPICTYPE_MULTIPLE;
/**
 * 判断题
 */
extern NSString * const PASSLEVELTOPICTYPE_TRUEORFALSE;
/**
 * 填空题
 */
extern NSString * const PASSLEVELTOPICTYPE_GAPFILLING;
/**
 * 简答题
 */
extern NSString * const PASSLEVELTOPICTYPE_SHORTANSWER;




@class ApplyRequest;
@class RsApplyBillRequest;
@class RsCommissionRequest;
@class DataPage;
@class PageRows;
@class RsResponse;
@class FunctionInfo;
@class LoginResult;
@class ResetPasswordRequest;
@class DataDict;
@class GoodsCondition;
@class GoodsFilter;
@class GroupByOrderNumber;
@class RsJingDongECardRequest;
@class RsSimpleJingDongECardRequest;
@class LotteryDrawResponse;
@class RsLotteryRequest;
@class OrderBill;
@class OrderPayRequest;
@class PromotionGoods;
@class PassLevelCondition;
@class PrizeCondition;
@class RsPrizeBillResponse;
@class SceneCondition;
@class SceneFilter;
@class RsShippingAddrEntity;
@class SaveShoppingCartRequest;
@class ShopCartFilter;
@class StudyTypeResponse;
@class TOAfficheEntity;
@class TOAttachmentEntity;
@class TOConsumerEntity;
@class TOGoodsForResellerEntity;
@class TOGoodsBrandEntity;
@class TOGoodsLabelEntity;
@class TOJingdongEcardEntity;
@class TODrawEntity;
@class TOOrderdetailEntity;
@class TOPassLevelEntity;
@class TOPassLevelTopicOptionEntity;
@class TOPrizeBillDetailsEntity;
@class TOSceneEntity;
@class TOShippingAddrEntity;
@class TOStudyTypeEntity;
@class Action;
@class IdEntity;
@class UCN;
@class TOShopcartEntity;
@class TOScoreRecordEntity;
@class TOPrizeEntity;
@class TOPrizeBillEntity;
@class TOPositionEntity;
@class TOPassLevelTopicEntity;
@class TOOrderPromotionEntity;
@class TOOrderEntity;
@class TOAwardEntity;
@class TOGoodsLabelCategoryEntity;
@class TOGoodsCategoryEntity;
@class VOResellerGoodsEntity;
@class TOGoodsEntity;
@class TOCommissionHistEntity;
@class TOApplyBillEntity;
@class RsShareResponse;
@class StudyTaskCondition;
@class DeleteCartRequest;
@class RsScoreDetails;
@class RsActionResult;
@class RsPrizeBill;
@class OrderFilter;
@class Draw;
@class HotFilter;
@class GoodsCategory;
@class RsEmployeeRequest;
@class ModifyPasswordRequest;
@class LoginInfo;
@class ConsumerQueryCondition;
@class ExceptionCode;
@class EarningsResponse;
@class AfficheCondition;
@class GoodsResponse;
@class RsJingDongECardResponse;
@class TSBaseUser;
@class TSDepart;
@class RsAwardDraw;
@class TSUserOrg;
@class RsLotteryResponse;
@class PassLevelResponse;
@class ShopCartResponse;
@class SceneResponse;
@class PrizeResponse;
@class OrderResponse;
@class RsSimpleJingDongECardResponse;
@class RsCommissionResponse;
@class ConsumerPageResult;
@class RsApplyBillResponse;
@class AfficheResponse;
@class TSUser;
@class TOEmployee;

@protocol ApplyRequest @end
@protocol RsApplyBillRequest @end
@protocol RsCommissionRequest @end
@protocol DataPage @end
@protocol PageRows @end
@protocol RsResponse @end
@protocol FunctionInfo @end
@protocol LoginResult @end
@protocol ResetPasswordRequest @end
@protocol DataDict @end
@protocol GoodsCondition @end
@protocol GoodsFilter @end
@protocol GroupByOrderNumber @end
@protocol RsJingDongECardRequest @end
@protocol RsSimpleJingDongECardRequest @end
@protocol LotteryDrawResponse @end
@protocol RsLotteryRequest @end
@protocol OrderBill @end
@protocol OrderPayRequest @end
@protocol PromotionGoods @end
@protocol PassLevelCondition @end
@protocol PrizeCondition @end
@protocol RsPrizeBillResponse @end
@protocol SceneCondition @end
@protocol SceneFilter @end
@protocol RsShippingAddrEntity @end
@protocol SaveShoppingCartRequest @end
@protocol ShopCartFilter @end
@protocol StudyTypeResponse @end
@protocol TOAfficheEntity @end
@protocol TOAttachmentEntity @end
@protocol TOConsumerEntity @end
@protocol TOGoodsForResellerEntity @end
@protocol TOGoodsBrandEntity @end
@protocol TOGoodsLabelEntity @end
@protocol TOJingdongEcardEntity @end
@protocol TODrawEntity @end
@protocol TOOrderdetailEntity @end
@protocol TOPassLevelEntity @end
@protocol TOPassLevelTopicOptionEntity @end
@protocol TOPrizeBillDetailsEntity @end
@protocol TOSceneEntity @end
@protocol TOShippingAddrEntity @end
@protocol TOStudyTypeEntity @end
@protocol Action @end
@protocol IdEntity @end
@protocol UCN @end
@protocol TOShopcartEntity @end
@protocol TOScoreRecordEntity @end
@protocol TOPrizeEntity @end
@protocol TOPrizeBillEntity @end
@protocol TOPositionEntity @end
@protocol TOPassLevelTopicEntity @end
@protocol TOOrderPromotionEntity @end
@protocol TOOrderEntity @end
@protocol TOAwardEntity @end
@protocol TOGoodsLabelCategoryEntity @end
@protocol TOGoodsCategoryEntity @end
@protocol VOResellerGoodsEntity @end
@protocol TOGoodsEntity @end
@protocol TOCommissionHistEntity @end
@protocol TOApplyBillEntity @end
@protocol RsShareResponse @end
@protocol StudyTaskCondition @end
@protocol DeleteCartRequest @end
@protocol RsScoreDetails @end
@protocol RsActionResult @end
@protocol RsPrizeBill @end
@protocol OrderFilter @end
@protocol Draw @end
@protocol HotFilter @end
@protocol GoodsCategory @end
@protocol RsEmployeeRequest @end
@protocol ModifyPasswordRequest @end
@protocol LoginInfo @end
@protocol ConsumerQueryCondition @end
@protocol ExceptionCode @end
@protocol EarningsResponse @end
@protocol AfficheCondition @end
@protocol GoodsResponse @end
@protocol RsJingDongECardResponse @end
@protocol TSBaseUser @end
@protocol TSDepart @end
@protocol RsAwardDraw @end
@protocol TSUserOrg @end
@protocol RsLotteryResponse @end
@protocol PassLevelResponse @end
@protocol ShopCartResponse @end
@protocol SceneResponse @end
@protocol PrizeResponse @end
@protocol OrderResponse @end
@protocol RsSimpleJingDongECardResponse @end
@protocol RsCommissionResponse @end
@protocol ConsumerPageResult @end
@protocol RsApplyBillResponse @end
@protocol AfficheResponse @end
@protocol TSUser @end
@protocol TOEmployee @end


/**
 *  @author Administrator
 @since 0.1
 
 */
@interface ApplyRequest : JSONModel
/**
 * (no documentation provided)
 *
 *
 */
@property (nonatomic, strong) NSNumber *amount;
@end /* interface ApplyRequest */



/**
 * (no documentation provided)
 */
@interface RsApplyBillRequest : JSONModel
/**
 * (no documentation provided)
 *
 *
 */
@property (nonatomic, copy) NSString *employeeId;
/**
 * (no documentation provided)
 *
 *
 */
@property (nonatomic, strong) DataPage *page;
@end /* interface RsApplyBillRequest */



/**
 *  流水请求
 
 @author nevermore
 @since 0.1
 
 */
@interface RsCommissionRequest : JSONModel
/**
 * (no documentation provided)
 *
 *
 */
@property (nonatomic, copy) NSString *emploreeId;
/**
 * (no documentation provided)
 *
 *
 */
@property (nonatomic, strong) DataPage *page;
@end /* interface RsCommissionRequest */



/**
 *  easyui的datagrid向后台传递参数使用的model
 
 @author
 
 
 */
@interface DataPage : JSONModel
/**
 * (no documentation provided)
 *
 *
 */
@property (nonatomic, assign) NSInteger total;
/**
 * (no documentation provided)
 *
 *
 */
@property (nonatomic, assign) NSInteger page;
/**
 * (no documentation provided)
 *
 *
 */
@property (nonatomic, assign) NSInteger rows;
/**
 * (no documentation provided)
 *
 *
 */
@property (nonatomic, copy) NSString *sort;
/**
 * (no documentation provided)
 *
 * 取值: SORTDIRECTION_ASC, SORTDIRECTION_DESC,
 */
@property (nonatomic, copy) NSString *order;
@end /* interface DataPage */



/**
 *  分页类
 
 @author Administrator
 @since 0.1
 
 */
@interface PageRows : JSONModel
/**
 * (no documentation provided)
 *
 *
 */
@property (nonatomic, assign) NSInteger page;
/**
 * (no documentation provided)
 *
 *
 */
@property (nonatomic, assign) NSInteger rows;
/**
 * (no documentation provided)
 *
 *
 */
@property (nonatomic, assign) NSInteger total;
/**
 * (no documentation provided)
 *
 *
 */
@property (nonatomic, assign) NSInteger totalpages;
@end /* interface PageRows */



/**
 *  Restful Service response base
 
 @author Debenson
 @since 0.1
 
 */
@interface RsResponse : JSONModel
/**
 * 0:正常， 非0异常。
 *
 *
 */
@property (nonatomic, assign) long long code;
/**
 * 异常描述
 *
 *
 */
@property (nonatomic, copy) NSString *message;
/**
 * 返回数据
 *
 *
 */
@property (nonatomic, strong) NSObject *data;
@end /* interface RsResponse */



/**
 *  用户权限信息
 
 @author thor
 @date 2016年11月17日 下午2:29:40
 @version 0.1
 
 */
@interface FunctionInfo : JSONModel
/**
 * (no documentation provided)
 *
 *
 */
@property (nonatomic, copy) NSString *userName;
/**
 * (no documentation provided)
 *
 *
 */
@property (nonatomic, copy) NSString *functionName;
@end /* interface FunctionInfo */



/**
 *  登录结果。
 
 @author Debenson
 @since 0.1
 
 */
@interface LoginResult : JSONModel
/**
 * 员工
 *
 *
 */
@property (nonatomic, strong) TOEmployee *employee;
/**
 * 分成比例
 *
 *
 */
@property (nonatomic, strong) NSNumber *commissionRate;
/**
 * 提成金额
 *
 *
 */
@property (nonatomic, strong) NSNumber *commissionTotal;
/**
 * 最低分成比例
 *
 *
 */
@property (nonatomic, strong) NSNumber *lowestDiscount;
@end /* interface LoginResult */



/**
 *  重置密码请求。
 
 @author Debenson
 @since 0.1
 
 */
@interface ResetPasswordRequest : JSONModel
/**
 * 用户名
 *
 *
 */
@property (nonatomic, copy) NSString *username;
/**
 * 短信验证码，请先调用发送短信接口
 * com.gomore.opple.rest.system.RsSystemService#sendSms(String)
 *
 *
 */
@property (nonatomic, copy) NSString *smsCode;
/**
 * 新密码
 *
 *
 */
@property (nonatomic, copy) NSString *fnewPassword;
@end /* interface ResetPasswordRequest */



/**
 *  @author Administrator
 @since 0.1
 
 */
@interface DataDict : JSONModel
/**
 * (no documentation provided)
 *
 *
 */
@property (nonatomic, copy) NSString *typeName;
/**
 * (no documentation provided)
 *
 *
 */
@property (nonatomic, copy) NSString *typecode;
@end /* interface DataDict */



/**
 *  @author NuoSa
 
 @since 0.1
 
 */
@interface GoodsCondition : JSONModel
/**
 * 查询条件是 商品名称
 *
 *
 */
@property (nonatomic, copy) NSString *nameLike;
/**
 * 查询条件是 类型id，取值: GoodsCategory#getId()
 *
 *
 */
@property (nonatomic, copy) NSString *categoryEquals;
/**
 * 查询条件是 风格
 *
 *
 */
@property (nonatomic, copy) NSString *styleEquals;
/**
 * 查询条件是 空间
 *
 *
 */
@property (nonatomic, copy) NSString *spaceEquals;
/**
 * 查询条件是 材质
 *
 *
 */
@property (nonatomic, copy) NSString *materialEqueals;
/**
 * 查询条件是 起始价格
 *
 *
 */
@property (nonatomic, strong) NSNumber *startprice;
/**
 * 查询条件是 起始价格
 *
 *
 */
@property (nonatomic, strong) NSNumber *endprice;
/**
 * (no documentation provided)
 *
 *
 */
@property (nonatomic, strong) DataPage *page;
@end /* interface GoodsCondition */



/**
 *  @author Debenson
 @since 0.1
 
 */
@interface GoodsFilter : JSONModel
/**
 * 风格
 * @see DataDict
 *
 */
@property (nonatomic, strong) NSArray<DataDict> *styles;
/**
 * (no documentation provided)
 * @see GoodsCategory
 *
 */
@property (nonatomic, strong) NSArray<GoodsCategory> *categories;
/**
 * 空间
 * @see DataDict
 *
 */
@property (nonatomic, strong) NSArray<DataDict> *space;
/**
 * 材质
 * @see DataDict
 *
 */
@property (nonatomic, strong) NSArray<DataDict> *material;
/**
 * 价格
 * @see DataDict
 *
 */
@property (nonatomic, strong) NSArray<DataDict> *price;
@end /* interface GoodsFilter */



/**
 *  查询京东E卡对象
 
 @author nevermore
 @since 0.1
 
 */
@interface GroupByOrderNumber : JSONModel
/**
 * (no documentation provided)
 *
 *
 */
@property (nonatomic, copy) NSString *orderNumber;
/**
 * (no documentation provided)
 *
 *
 */
@property (nonatomic, copy) NSString *orderTime;
/**
 * (no documentation provided)
 *
 *
 */
@property (nonatomic, copy) NSString *orderReceiptUrl;
/**
 * (no documentation provided)
 * @see TOJingdongEcardEntity
 *
 */
@property (nonatomic, strong) NSArray<TOJingdongEcardEntity> *eCards;
@end /* interface GroupByOrderNumber */



/**
 * (no documentation provided)
 */
@interface RsJingDongECardRequest : JSONModel
/**
 * (no documentation provided)
 *
 *
 */
@property (nonatomic, copy) NSString *guideIdEquals;
/**
 * (no documentation provided)
 *
 *
 */
@property (nonatomic, copy) NSString *stateEquals;
/**
 * (no documentation provided)
 *
 *
 */
@property (nonatomic, strong) DataPage *page;
@end /* interface RsJingDongECardRequest */



/**
 * (no documentation provided)
 */
@interface RsSimpleJingDongECardRequest : JSONModel
/**
 * (no documentation provided)
 *
 *
 */
@property (nonatomic, copy) NSString *guideIdEquals;
/**
 * (no documentation provided)
 *
 *
 */
@property (nonatomic, copy) NSString *stateEquals;
/**
 * (no documentation provided)
 *
 *
 */
@property (nonatomic, strong) DataPage *page;
@end /* interface RsSimpleJingDongECardRequest */



/**
 *  查询京东E卡对象
 
 @author nevermore
 @since 0.1
 
 */
@interface LotteryDrawResponse : JSONModel
/**
 * (no documentation provided)
 * @see TOAwardEntity
 *
 */
@property (nonatomic, strong) NSArray<TOAwardEntity> *awards;
/**
 * (no documentation provided)
 * @see NSString
 *
 */
@property (nonatomic, strong) NSArray<NSString *> *descriptions;
/**
 * (no documentation provided)
 *
 *
 */
@property (nonatomic, copy) NSString *rule;
@end /* interface LotteryDrawResponse */



/**
 * (no documentation provided)
 */
@interface RsLotteryRequest : JSONModel
/**
 * (no documentation provided)
 *
 *
 */
@property (nonatomic, copy) NSString *winnerIdEquals;
/**
 * (no documentation provided)
 *
 *
 */
@property (nonatomic, copy) NSString *lotteryIdEquals;
/**
 * (no documentation provided)
 *
 *
 */
@property (nonatomic, copy) NSString *orderNumberEquals;
/**
 * (no documentation provided)
 *
 *
 */
@property (nonatomic, copy) NSString *stateEquals;
/**
 * (no documentation provided)
 *
 *
 */
@property (nonatomic, strong) DataPage *page;
@end /* interface RsLotteryRequest */



/**
 *  @author Flash
 @since 0.1
 
 */
@interface OrderBill : JSONModel
/**
 * (no documentation provided)
 *
 *
 */
@property (nonatomic, strong) DataPage *datapage;
/**
 * (no documentation provided)
 *
 *
 */
@property (nonatomic, strong) TOOrderEntity *order;
/**
 * (no documentation provided)
 * @see TOOrderdetailEntity
 *
 */
@property (nonatomic, strong) NSArray<TOOrderdetailEntity> *orderdetailList;
/**
 * (no documentation provided)
 *
 *
 */
@property (nonatomic, strong) TOConsumerEntity *consumer;
/**
 * (no documentation provided)
 *
 *
 */
@property (nonatomic, strong) TOEmployee *employee;
@end /* interface OrderBill */



/**
 *  订单支付
 
 @author wsx
 @since 0.1
 
 */
@interface OrderPayRequest : JSONModel
/**
 * 订单编号
 *
 *
 */
@property (nonatomic, copy) NSString *orderNumber;
/**
 * 旧状态
 *
 *
 */
@property (nonatomic, copy) NSString *oldstate;
/**
 * 新状态
 *
 *
 */
@property (nonatomic, copy) NSString *fnewstate;
/**
 * 支付方式
 *
 *
 */
@property (nonatomic, copy) NSString *payType;
/**
 * 是否开票
 *
 *
 */
@property (nonatomic, copy) NSString *isbill;
/**
 * 发票类型
 *
 *
 */
@property (nonatomic, copy) NSString *billType;
/**
 * 发票抬头
 *
 *
 */
@property (nonatomic, copy) NSString *billTitle;
/**
 * 实际支付金额
 *
 *
 */
@property (nonatomic, strong) NSNumber *realAmount;
/**
 * 抽奖主题标识
 *
 *
 */
@property (nonatomic, copy) NSString *lotteryId;
/**
 * 抽奖记录标识
 *
 *
 */
@property (nonatomic, copy) NSString *drawId;
/**
 * 促销商品
 * @see PromotionGoods
 *
 */
@property (nonatomic, strong) NSArray<PromotionGoods> *promotionGoods;
/**
 * 京东E卡面额
 *
 *
 */
@property (nonatomic, assign) NSInteger jdCardDenomation;
/**
 * 抵扣
 *
 *
 */
@property (nonatomic, strong) NSNumber *promotionMoney;
/**
 * 微信卡券卡号
 *
 *
 */
@property (nonatomic, copy) NSString *wxcardNumber;
/**
 * 微信卡券面额
 *
 *
 */
@property (nonatomic, strong) NSNumber *wxcardDenomation;
/**
 * 抵扣优先级
 *
 *
 */
@property (nonatomic, assign) NSInteger deductionPrority;
/**
 * 赠送商品优��级
 *
 *
 */
@property (nonatomic, assign) NSInteger goodsPrority;
/**
 * 京东E卡优先级
 *
 *
 */
@property (nonatomic, assign) NSInteger jdEcardsPrority;
/**
 * 消费者抽奖结果优先级
 *
 *
 */
@property (nonatomic, assign) NSInteger drawPrority;
/**
 * 导购抽奖主题优先级
 *
 *
 */
@property (nonatomic, assign) NSInteger lotteryPrority;
/**
 * 微信卡券优先级
 *
 *
 */
@property (nonatomic, assign) NSInteger wxCardPrority;
@end /* interface OrderPayRequest */



/**
 *  订单支付
 
 @author wsx
 @since 0.1
 
 */
@interface PromotionGoods : JSONModel
/**
 *
 *
 *
 */
@property (nonatomic, strong) UCN *goods;
/**
 *
 *
 *
 */
@property (nonatomic, strong) NSNumber *promotionNumber;
@end /* interface PromotionGoods */



/**
 * (no documentation provided)
 */
@interface PassLevelCondition : JSONModel
/**
 * (no documentation provided)
 *
 *
 */
@property (nonatomic, copy) NSString *titleLike;
/**
 * (no documentation provided)
 *
 *
 */
@property (nonatomic, copy) NSString *beginDateFrom;
/**
 * (no documentation provided)
 *
 *
 */
@property (nonatomic, copy) NSString *endDateTo;
/**
 * (no documentation provided)
 *
 *
 */
@property (nonatomic, assign) BOOL validEquals;
/**
 * (no documentation provided)
 *
 *
 */
@property (nonatomic, copy) NSString *employeeIdEquals;
/**
 * (no documentation provided)
 *
 *
 */
@property (nonatomic, strong) DataPage *page;
@end /* interface PassLevelCondition */



/**
 *  奖品查询条件
 
 @author wolv
 
 
 */
@interface PrizeCondition : JSONModel
/**
 *
 *
 *
 */
@property (nonatomic, copy) NSString *codeLike;
/**
 *
 *
 *
 */
@property (nonatomic, copy) NSString *nameLike;
/**
 *
 *
 *
 */
@property (nonatomic, strong) DataPage *page;
@end /* interface PrizeCondition */



/**
 *  兑奖单查询返回包装对象
 
 @author wolv
 
 
 */
@interface RsPrizeBillResponse : JSONModel
/**
 * (no documentation provided)
 * @see RsPrizeBill
 *
 */
@property (nonatomic, strong) NSArray<RsPrizeBill> *bills;
@end /* interface RsPrizeBillResponse */



/**
 *  @author Administrator
 @since 0.1
 
 */
@interface SceneCondition : JSONModel
/**
 * 查询条件:风格
 *
 *
 */
@property (nonatomic, copy) NSString *styleEquals;
/**
 * 查询条件:空间
 *
 *
 */
@property (nonatomic, copy) NSString *spaceEquals;
/**
 * (no documentation provided)
 *
 *
 */
@property (nonatomic, strong) DataPage *page;
@end /* interface SceneCondition */



/**
 *  @author Administrator
 @since 0.1
 
 */
@interface SceneFilter : JSONModel
/**
 * (no documentation provided)
 * @see DataDict
 *
 */
@property (nonatomic, strong) NSArray<DataDict> *styles;
/**
 * (no documentation provided)
 * @see DataDict
 *
 */
@property (nonatomic, strong) NSArray<DataDict> *space;
@end /* interface SceneFilter */



/**
 *  @author Administrator
 @since 0.1
 
 */
@interface RsShippingAddrEntity : JSONModel
/**
 * (no documentation provided)
 * @see TOShippingAddrEntity
 *
 */
@property (nonatomic, strong) NSArray<TOShippingAddrEntity> *list;
@end /* interface RsShippingAddrEntity */



/**
 *  @author Debenson
 @since 0.1
 
 */
@interface SaveShoppingCartRequest : JSONModel
/**
 * 消费者标识
 *
 *
 */
@property (nonatomic, copy) NSString *consumerId;
/**
 * 商品标识
 *
 *
 */
@property (nonatomic, copy) NSString *goodsId;
/**
 * 商品数量，>0表示添加, <0表示减少
 *
 *
 */
@property (nonatomic, copy) NSString *count;
@end /* interface SaveShoppingCartRequest */



/**
 *  购物车查询条件。
 
 @author Debenson
 @since 0.1
 
 */
@interface ShopCartFilter : JSONModel
/**
 * 消费者标识
 *
 *
 */
@property (nonatomic, copy) NSString *consumerId;
/**
 * 分页数据
 *
 *
 */
@property (nonatomic, strong) DataPage *dp;
@end /* interface ShopCartFilter */



/**
 * (no documentation provided)
 */
@interface StudyTypeResponse : JSONModel
/**
 * (no documentation provided)
 * @see TOStudyTypeEntity
 *
 */
@property (nonatomic, strong) NSArray<TOStudyTypeEntity> *types;
@end /* interface StudyTypeResponse */



/**
 *  @Title: Entity
 @Description: 公告
 @author onlineGenerator
 @date 2016-11-09 11:48:16
 @version V1.0
 
 
 */
@interface TOAfficheEntity : JSONModel
/**
 * 主键
 *
 *
 */
@property (nonatomic, copy) NSString *fid;
/**
 * 创建人名称
 *
 *
 */
@property (nonatomic, copy) NSString *createName;
/**
 * 创建日期
 *
 *
 */
@property (nonatomic, copy) NSString *createDate;
/**
 * 更新人名称
 *
 *
 */
@property (nonatomic, copy) NSString *updateName;
/**
 * 更新日期
 *
 *
 */
@property (nonatomic, copy) NSString *updateDate;
/**
 * 标题
 *
 *
 */
@property (nonatomic, copy) NSString *title;
/**
 * 内容
 *
 *
 */
@property (nonatomic, copy) NSString *content;
/**
 * 优先级
 *
 *
 */
@property (nonatomic, copy) NSString *priority;
/**
 * 状态
 *
 *
 */
@property (nonatomic, copy) NSString *state;
/**
 * 公告类型
 *
 *
 */
@property (nonatomic, copy) NSString *afficheType;
/**
 * 附件
 *
 *
 */
@property (nonatomic, copy) NSString *attachmentId;
/**
 * (no documentation provided)
 *
 *
 */
@property (nonatomic, copy) NSString *departId;
/**
 * (no documentation provided)
 * @see TOAttachmentEntity
 *
 */
@property (nonatomic, strong) NSArray<TOAttachmentEntity> *attachmentUrls;
@end /* interface TOAfficheEntity */



/**
 *  @Title: Entity
 @Description: 附件
 @author onlineGenerator
 @date 2016-11-05 16:44:26
 @version V1.0
 
 
 */
@interface TOAttachmentEntity : JSONModel
/**
 * 主键
 *
 *
 */
@property (nonatomic, copy) NSString *fid;
/**
 * 文件名称
 *
 *
 */
@property (nonatomic, copy) NSString *fileName;
/**
 * 文件url
 *
 *
 */
@property (nonatomic, copy) NSString *fileUrl;
/**
 * 缩略图名称
 *
 *
 */
@property (nonatomic, copy) NSString *thumbnailName;
/**
 * 缩略图url
 *
 *
 */
@property (nonatomic, copy) NSString *thumbnailUrl;
/**
 * 实体类型
 *
 *
 */
@property (nonatomic, copy) NSString *entityType;
/**
 * 实体id
 *
 *
 */
@property (nonatomic, copy) NSString *entityId;
/**
 * 播放时间
 *
 *
 */
@property (nonatomic, copy) NSString *playTime;
@end /* interface TOAttachmentEntity */



/**
 *  @Title: Entity
 @Description: 客户
 @author onlineGenerator
 @date 2016-05-08 18:08:58
 @version V1.0
 
 
 */
@interface TOConsumerEntity : JSONModel
/**
 * 方法: 取得java.lang.String
 *
 *
 */
@property (nonatomic, copy) NSString *fid;
/**
 * 方法: 取得java.lang.String
 *
 *
 */
@property (nonatomic, copy) NSString *createName;
/**
 * 方法: 取得java.lang.String
 *
 *
 */
@property (nonatomic, copy) NSString *createBy;
/**
 * 方法: 取得java.util.Date
 *
 *
 */
@property (nonatomic, copy) NSString *createDate;
/**
 * 方法: 取得java.lang.String
 *
 *
 */
@property (nonatomic, copy) NSString *sysOrgCode;
/**
 * 方法: 取得java.lang.String
 *
 *
 */
@property (nonatomic, copy) NSString *name;
/**
 * 方法: 取得java.lang.String
 *
 *
 */
@property (nonatomic, copy) NSString *mobile;
/**
 * 方法: 取得java.lang.String
 *
 *
 */
@property (nonatomic, copy) NSString *province;
/**
 * 方法: 取得java.lang.String
 *
 *
 */
@property (nonatomic, copy) NSString *city;
/**
 * 方法: 取得java.lang.String
 *
 *
 */
@property (nonatomic, copy) NSString *country;
/**
 * 方法: 取得java.lang.String
 *
 *
 */
@property (nonatomic, copy) NSString *address;
/**
 * 方法: 取得java.lang.String
 *
 *
 */
@property (nonatomic, copy) NSString *picture;
/**
 * 方法: 取得java.util.Date
 *
 *
 */
@property (nonatomic, copy) NSString *lastVisitedTime;
/**
 * 方法: 取得java.lang.String
 *
 *
 */
@property (nonatomic, copy) NSString *company;
@end /* interface TOConsumerEntity */



/**
 * (no documentation provided)
 */
@interface TOGoodsForResellerEntity : JSONModel
/**
 * 方法: 取得java.lang.String
 *
 *
 */
@property (nonatomic, copy) NSString *fid;
/**
 * 方法: 取得java.lang.String
 *
 *
 */
@property (nonatomic, copy) NSString *resellerId;
/**
 * (no documentation provided)
 *
 *
 */
@property (nonatomic, strong) TOGoodsEntity *goods;
/**
 * (no documentation provided)
 *
 *
 */
@property (nonatomic, copy) NSString *path;
@end /* interface TOGoodsForResellerEntity */



/**
 *  @Title: Entity
 @Description: 商品品牌
 @author onlineGenerator
 @date 2016-05-05 16:14:51
 @version V1.0
 
 
 */
@interface TOGoodsBrandEntity : JSONModel
/**
 * 方法: 取得java.lang.String
 *
 *
 */
@property (nonatomic, copy) NSString *fid;
/**
 * 方法: 取得java.lang.String
 *
 *
 */
@property (nonatomic, copy) NSString *createName;
/**
 * 方法: 取得java.lang.String
 *
 *
 */
@property (nonatomic, copy) NSString *createBy;
/**
 * 方法: 取得java.util.Date
 *
 *
 */
@property (nonatomic, copy) NSString *createDate;
/**
 * 方法: 取得java.lang.String
 *
 *
 */
@property (nonatomic, copy) NSString *sysOrgCode;
/**
 * 方法: 取得java.lang.String
 *
 *
 */
@property (nonatomic, copy) NSString *sysCompanyCode;
/**
 * 方法: 取得java.lang.String
 *
 *
 */
@property (nonatomic, copy) NSString *code;
/**
 * 方法: 取得java.lang.String
 *
 *
 */
@property (nonatomic, copy) NSString *name;
/**
 * 方法: 取得java.lang.Integer
 *
 *
 */
@property (nonatomic, copy) NSString *state;
/**
 * 方法: 取得java.lang.String
 *
 *
 */
@property (nonatomic, copy) NSString *logo;
/**
 * 方法: 取得java.lang.String
 *
 *
 */
@property (nonatomic, copy) NSString *fdescription;
@end /* interface TOGoodsBrandEntity */



/**
 *  @Title: Entity
 @Description: 商品标签
 @author onlineGenerator
 @date 2016-05-05 17:18:15
 @version V1.0
 
 
 */
@interface TOGoodsLabelEntity : JSONModel
/**
 * (no documentation provided)
 *
 *
 */
@property (nonatomic, strong) TOGoodsLabelCategoryEntity *category;
/**
 * 方法: 取得java.lang.String
 *
 *
 */
@property (nonatomic, copy) NSString *fid;
/**
 * 方法: 取得java.lang.String
 *
 *
 */
@property (nonatomic, copy) NSString *sysOrgCode;
/**
 * 方法: 取得java.lang.String
 *
 *
 */
@property (nonatomic, copy) NSString *sysCompanyCode;
/**
 * 方法: 取得java.lang.String
 *
 *
 */
@property (nonatomic, copy) NSString *name;
/**
 * 方法: 取得java.lang.String
 *
 *
 */
@property (nonatomic, copy) NSString *categoryId;
@end /* interface TOGoodsLabelEntity */



/**
 *  @Title: Entity
 @Description: 京东E卡
 @author onlineGenerator
 @date 2016-10-18 16:34:26
 @version V1.0
 
 
 */
@interface TOJingdongEcardEntity : JSONModel
/**
 * 方法: 取得java.lang.String
 *
 *
 */
@property (nonatomic, copy) NSString *fid;
/**
 * 方法: 取得java.lang.String
 *
 *
 */
@property (nonatomic, copy) NSString *createName;
/**
 * 方法: 取得java.lang.String
 *
 *
 */
@property (nonatomic, copy) NSString *createBy;
/**
 * 方法: 取得java.util.Date
 *
 *
 */
@property (nonatomic, copy) NSString *createDate;
/**
 * 方法: 取得java.lang.String
 *
 *
 */
@property (nonatomic, copy) NSString *updateName;
/**
 * 方法: 取得java.lang.String
 *
 *
 */
@property (nonatomic, copy) NSString *updateBy;
/**
 * 方法: 取得java.util.Date
 *
 *
 */
@property (nonatomic, copy) NSString *updateDate;
/**
 * 方法: 取得java.lang.String
 *
 *
 */
@property (nonatomic, copy) NSString *sysOrgCode;
/**
 * 方法: 取得java.lang.String
 *
 *
 */
@property (nonatomic, copy) NSString *cardNumber;
/**
 * 方法: 取得java.lang.String
 *
 *
 */
@property (nonatomic, copy) NSString *cardPassword;
/**
 * 方法: 取得java.lang.Integer
 *
 *
 */
@property (nonatomic, assign) NSInteger denomation;
/**
 * 方法: 取得java.lang.String
 *
 *
 */
@property (nonatomic, copy) NSString *state;
/**
 * 方法: 取得java.lang.String
 *
 *
 */
@property (nonatomic, copy) NSString *guideId;
/**
 * 方法: 取得java.lang.String
 *
 *
 */
@property (nonatomic, copy) NSString *orderNumber;
/**
 * 方法: 取得java.lang.String
 *
 *
 */
@property (nonatomic, copy) NSString *orderReceiptUrl;
@end /* interface TOJingdongEcardEntity */



/**
 *  @Title: Entity
 @Description: 抽奖记录
 @author onlineGenerator
 @date 2016-11-09 18:13:23
 @version V1.0
 
 
 */
@interface TODrawEntity : JSONModel
/**
 * 方法: 取得java.lang.String
 *
 *
 */
@property (nonatomic, copy) NSString *fid;
/**
 * 方法: 取得java.lang.String
 *
 *
 */
@property (nonatomic, copy) NSString *createName;
/**
 * 方法: 取得java.lang.String
 *
 *
 */
@property (nonatomic, copy) NSString *createBy;
/**
 * 方法: 取得java.util.Date
 *
 *
 */
@property (nonatomic, copy) NSString *createDate;
/**
 * 方法: 取得java.lang.String
 *
 *
 */
@property (nonatomic, copy) NSString *updateName;
/**
 * 方法: 取得java.lang.String
 *
 *
 */
@property (nonatomic, copy) NSString *updateBy;
/**
 * 方法: 取得java.util.Date
 *
 *
 */
@property (nonatomic, copy) NSString *updateDate;
/**
 * 方法: 取得java.lang.String
 *
 *
 */
@property (nonatomic, copy) NSString *sysOrgCode;
/**
 * 方法: 取得java.util.Date
 *
 *
 */
@property (nonatomic, copy) NSString *drawDate;
/**
 * 方法: 取得java.lang.String
 *
 *
 */
@property (nonatomic, copy) NSString *winnerId;
/**
 * 方法: 取得java.lang.String
 *
 *
 */
@property (nonatomic, copy) NSString *awardId;
/**
 * 方法: 取得java.lang.String
 *
 *
 */
@property (nonatomic, copy) NSString *awardDescription;
/**
 * 方法: 取得java.lang.String
 *
 *
 */
@property (nonatomic, copy) NSString *orderNumber;
/**
 * 方法: 取得java.lang.String
 *
 *
 */
@property (nonatomic, copy) NSString *state;
/**
 * 方法: 取得java.lang.String
 *
 *
 */
@property (nonatomic, copy) NSString *lotteryId;
@end /* interface TODrawEntity */



/**
 *  @Title: Entity
 @Description: 订单详情
 @author onlineGenerator
 @date 2016-05-06 12:53:09
 @version V1.0
 
 
 */
@interface TOOrderdetailEntity : JSONModel
/**
 * (no documentation provided)
 *
 *
 */
@property (nonatomic, copy) NSString *brandName;
/**
 * 方法: 取得java.lang.String
 *
 *
 */
@property (nonatomic, copy) NSString *fid;
/**
 * 方法: 取得java.lang.String
 *
 *
 */
@property (nonatomic, copy) NSString *goodsId;
/**
 * 方法: 取得java.lang.String
 *
 *
 */
@property (nonatomic, copy) NSString *goodsCode;
/**
 * 方法: 取得java.lang.String
 *
 *
 */
@property (nonatomic, copy) NSString *goodsName;
/**
 * 方法: 取得java.lang.String
 *
 *
 */
@property (nonatomic, copy) NSString *goodsCover;
/**
 * 方法: 取得java.lang.String
 *
 *
 */
@property (nonatomic, copy) NSString *goodsSpec;
/**
 * 方法: 取得java.lang.String
 *
 *
 */
@property (nonatomic, copy) NSString *goodsBrand;
/**
 * 方法: 取得java.lang.String
 *
 *
 */
@property (nonatomic, copy) NSString *goodsNum;
/**
 * 方法: 取得java.math.BigDecimal
 *
 *
 */
@property (nonatomic, strong) NSNumber *goodsPrice;
/**
 * 方法: 取得java.math.BigDecimal
 *
 *
 */
@property (nonatomic, strong) NSNumber *goodsTotalPrice;
/**
 * 方法: 取得java.lang.String
 *
 *
 */
@property (nonatomic, copy) NSString *orderId;
/**
 * 方法: 取得java.lang.String
 *
 *
 */
@property (nonatomic, copy) NSString *goodsUnit;
/**
 * 方法: 取得java.lang.String
 *
 *
 */
@property (nonatomic, copy) NSString *remark;
@end /* interface TOOrderdetailEntity */



/**
 *  @Title: Entity
 @Description: 闯关
 @author onlineGenerator
 @date 2016-11-13 20:47:10
 @version V1.0
 
 */
@interface TOPassLevelEntity : JSONModel
/**
 * 方法: 取得主键
 *
 *
 */
@property (nonatomic, copy) NSString *fid;
/**
 * 方法: 取得创建人名称
 *
 *
 */
@property (nonatomic, copy) NSString *createName;
/**
 * 方法: 取得创建人登录名称
 *
 *
 */
@property (nonatomic, copy) NSString *createBy;
/**
 * 方法: 取得创建日期
 *
 *
 */
@property (nonatomic, copy) NSString *createDate;
/**
 * 方法: 取得更新人名称
 *
 *
 */
@property (nonatomic, copy) NSString *updateName;
/**
 * 方法: 取得更新人登录名称
 *
 *
 */
@property (nonatomic, copy) NSString *updateBy;
/**
 * 方法: 取得更新日期
 *
 *
 */
@property (nonatomic, copy) NSString *updateDate;
/**
 * 方法: 取得所属部门
 *
 *
 */
@property (nonatomic, copy) NSString *sysOrgCode;
/**
 * 方法: 取得开始时间
 *
 *
 */
@property (nonatomic, copy) NSString *beginDate;
/**
 * 方法: 取得结束时间
 *
 *
 */
@property (nonatomic, copy) NSString *endDate;
/**
 * 方法: 取得及格分数线
 *
 *
 */
@property (nonatomic, assign) NSInteger passGrade;
/**
 * 标题
 *
 *
 */
@property (nonatomic, copy) NSString *title;
/**
 * 方法: 取得评分方法
 *
 * 取值: GRADEMETHOD_AUTO, GRADEMETHOD_MANUL,
 */
@property (nonatomic, copy) NSString *gradeMethod;
/**
 * 方法: 取得积分
 *
 *
 */
@property (nonatomic, strong) NSNumber *score;
/**
 * 是否生效
 *
 *
 */
@property (nonatomic, assign) BOOL valid;
/**
 * 闯关结果
 *
 *
 */
@property (nonatomic, copy) NSString *passResult;
/**
 * 题目列表
 * @see TOPassLevelTopicEntity
 *
 */
@property (nonatomic, strong) NSArray<TOPassLevelTopicEntity> *topics;
@end /* interface TOPassLevelEntity */



/**
 *  @Title: Entity
 @Description: 闯关题目选项
 @author onlineGenerator
 @date 2016-11-13 20:48:07
 @version V1.0
 
 */
@interface TOPassLevelTopicOptionEntity : JSONModel
/**
 * 方法: 取得主键
 *
 *
 */
@property (nonatomic, copy) NSString *fid;
/**
 * 方法: 取得索引
 *
 *
 */
@property (nonatomic, assign) NSInteger findex;
/**
 * 方法: 取得取值
 *
 *
 */
@property (nonatomic, copy) NSString *value;
/**
 * 方法: 取得标题
 *
 *
 */
@property (nonatomic, copy) NSString *name;
/**
 * 方法: 取得题目id
 *
 *
 */
@property (nonatomic, copy) NSString *topicId;
@end /* interface TOPassLevelTopicOptionEntity */



/**
 *  兑奖单奖品明细
 
 @author wolv
 
 */
@interface TOPrizeBillDetailsEntity : JSONModel
/**
 *
 *
 *
 */
@property (nonatomic, copy) NSString *fid;
/**
 *
 *
 *
 */
@property (nonatomic, copy) NSString *bill;
/**
 *
 *
 *
 */
@property (nonatomic, strong) TOPrizeEntity *prize;
@end /* interface TOPrizeBillDetailsEntity */



/**
 *  @Title: Entity
 @Description: 场景
 @author onlineGenerator
 @date 2016-05-05 18:39:39
 @version V1.0
 
 
 */
@interface TOSceneEntity : JSONModel
/**
 * 方法: 取得java.lang.String
 *
 *
 */
@property (nonatomic, copy) NSString *fid;
/**
 * 方法: 取得java.lang.String
 *
 *
 */
@property (nonatomic, copy) NSString *sceneCode;
/**
 * 方法: 取得java.lang.String
 *
 *
 */
@property (nonatomic, copy) NSString *name;
/**
 * 方法: 取得java.lang.String
 *
 *
 */
@property (nonatomic, copy) NSString *pricure;
/**
 * 方法: 取得java.lang.String
 *
 *
 */
@property (nonatomic, copy) NSString *category;
/**
 * 方法: 取得java.lang.String
 *
 *
 */
@property (nonatomic, copy) NSString *style;
/**
 * 方法: 取得java.lang.String
 *
 *
 */
@property (nonatomic, copy) NSString *space;
@end /* interface TOSceneEntity */



/**
 *  @Title: Entity
 @Description: t_o_shipping_addr
 @author onlineGenerator
 @date 2016-05-14 16:14:15
 @version V1.0
 
 
 */
@interface TOShippingAddrEntity : JSONModel
/**
 * 方法: 取得java.lang.String
 *
 *
 */
@property (nonatomic, copy) NSString *fid;
/**
 * 方法: 取得java.util.Date
 *
 *
 */
@property (nonatomic, copy) NSString *createDate;
/**
 * 方法: 取得java.lang.String
 *
 *
 */
@property (nonatomic, copy) NSString *sysOrgCode;
/**
 * 方法: 取得java.lang.String
 *
 *
 */
@property (nonatomic, copy) NSString *name;
/**
 * 方法: 取得java.lang.String
 *
 *
 */
@property (nonatomic, copy) NSString *miblephone;
/**
 * 方法: 取得java.lang.String
 *
 *
 */
@property (nonatomic, copy) NSString *province;
/**
 * 方法: 取得java.lang.String
 *
 *
 */
@property (nonatomic, copy) NSString *city;
/**
 * 方法: 取得java.lang.String
 *
 *
 */
@property (nonatomic, copy) NSString *country;
/**
 * 方法: 取得java.lang.String
 *
 *
 */
@property (nonatomic, copy) NSString *address;
/**
 * 方法: 取得java.lang.String
 *
 *
 */
@property (nonatomic, copy) NSString *consumerId;
@end /* interface TOShippingAddrEntity */



/**
 *  @Title: Entity
 @Description: 学习类型
 @author onlineGenerator
 @date 2016-11-05 16:44:04
 @version V1.0
 
 
 */
@interface TOStudyTypeEntity : JSONModel
/**
 * 唯一标识。
 *
 *
 */
@property (nonatomic, copy) NSString *fid;
/**
 * 名称。
 *
 *
 */
@property (nonatomic, copy) NSString *name;
/**
 * 附件id
 *
 *
 */
@property (nonatomic, copy) NSString *attachmentId;
/**
 * 附件
 *
 *
 */
@property (nonatomic, strong) TOAttachmentEntity *attachment;
@end /* interface TOStudyTypeEntity */



/**
 *  促销动作。
 
 @author Debenson
 @since 0.1
 
 */
@interface Action : JSONModel
@end /* interface Action */



/**
 * (no documentation provided)
 */
@interface IdEntity : JSONModel
/**
 * (no documentation provided)
 *
 *
 */
@property (nonatomic, copy) NSString *fid;
@end /* interface IdEntity */



/**
 *  UUID + CODE + NAME
 
 @author Debenson
 @since 0.1
 
 */
@interface UCN : JSONModel
/**
 * (no documentation provided)
 *
 *
 */
@property (nonatomic, copy) NSString *uuid;
/**
 * (no documentation provided)
 *
 *
 */
@property (nonatomic, copy) NSString *code;
/**
 * (no documentation provided)
 *
 *
 */
@property (nonatomic, copy) NSString *name;
@end /* interface UCN */



/**
 *  @Title: Entity
 @Description: t_o_shopcart
 @author onlineGenerator
 @date 2016-05-13 14:26:57
 @version V1.0
 
 
 */
@interface TOShopcartEntity : JSONModel
/**
 * 商品详情
 *
 *
 */
@property (nonatomic, strong) VOResellerGoodsEntity *goods;
/**
 * 方法: 取得java.lang.String
 *
 *
 */
@property (nonatomic, copy) NSString *fid;
/**
 * 方法: 取得java.lang.String
 *
 *
 */
@property (nonatomic, copy) NSString *createName;
/**
 * 方法: 取得java.lang.String
 *
 *
 */
@property (nonatomic, copy) NSString *createBy;
/**
 * 方法: 取得java.util.Date
 *
 *
 */
@property (nonatomic, copy) NSString *createDate;
/**
 * 方法: 取得java.lang.String
 *
 *
 */
@property (nonatomic, copy) NSString *updateName;
/**
 * 方法: 取得java.lang.String
 *
 *
 */
@property (nonatomic, copy) NSString *updateBy;
/**
 * 方法: 取得java.util.Date
 *
 *
 */
@property (nonatomic, copy) NSString *updateDate;
/**
 * 方法: 取得java.lang.String
 *
 *
 */
@property (nonatomic, copy) NSString *goodsId;
/**
 * 方法: 取得java.lang.Integer
 *
 *
 */
@property (nonatomic, assign) NSInteger goodsNum;
/**
 * 方法: 取得java.lang.String
 *
 *
 */
@property (nonatomic, copy) NSString *consumerId;
/**
 * 方法: 取得java.lang.String
 *
 *
 */
@property (nonatomic, copy) NSString *resellerId;
/**
 * 方法: 取得java.lang.String
 *
 *
 */
@property (nonatomic, strong) NSNumber *costPrice;
@end /* interface TOShopcartEntity */



/**
 *  积分变更记录
 
 @author wolv
 
 */
@interface TOScoreRecordEntity : JSONModel
/**
 *
 *
 *
 */
@property (nonatomic, copy) NSString *fid;
/**
 *
 *
 *
 */
@property (nonatomic, copy) NSString *createDate;
/**
 *
 *
 *
 */
@property (nonatomic, copy) NSString *employeeId;
/**
 *
 *
 *
 */
@property (nonatomic, assign) double score;
/**
 *
 *
 *
 */
@property (nonatomic, copy) NSString *sourceId;
/**
 *
 *
 *
 */
@property (nonatomic, copy) NSString *sourceType;
/**
 *
 *
 *
 */
@property (nonatomic, copy) NSString *sourceReason;
@end /* interface TOScoreRecordEntity */



/**
 *  奖品
 
 @author wolv
 
 */
@interface TOPrizeEntity : JSONModel
/**
 *
 *
 *
 */
@property (nonatomic, copy) NSString *fid;
/**
 *
 *
 *
 */
@property (nonatomic, copy) NSString *picture;
/**
 *
 *
 *
 */
@property (nonatomic, copy) NSString *createName;
/**
 *
 *
 *
 */
@property (nonatomic, copy) NSString *createBy;
/**
 *
 *
 *
 */
@property (nonatomic, copy) NSString *updateName;
/**
 *
 *
 *
 */
@property (nonatomic, copy) NSString *updateBy;
/**
 *
 *
 *
 */
@property (nonatomic, copy) NSString *code;
/**
 *
 *
 *
 */
@property (nonatomic, copy) NSString *name;
/**
 *
 *
 *
 */
@property (nonatomic, copy) NSString *createDate;
/**
 *
 *
 *
 */
@property (nonatomic, copy) NSString *updateDate;
@end /* interface TOPrizeEntity */



/**
 *  兑奖单实体
 
 @author wolv
 
 */
@interface TOPrizeBillEntity : JSONModel
/**
 *
 *
 *
 */
@property (nonatomic, copy) NSString *fid;
/**
 *
 *
 *
 */
@property (nonatomic, copy) NSString *createName;
/**
 *
 *
 *
 */
@property (nonatomic, copy) NSString *createBy;
/**
 *
 *
 *
 */
@property (nonatomic, copy) NSString *createDate;
/**
 *
 *
 *
 */
@property (nonatomic, copy) NSString *updateName;
/**
 *
 *
 *
 */
@property (nonatomic, copy) NSString *updateBy;
/**
 *
 *
 *
 */
@property (nonatomic, copy) NSString *updateDate;
/**
 *
 *
 *
 */
@property (nonatomic, copy) NSString *billnumber;
/**
 *
 *
 * 取值: TOPRIZEBILLENTITYSTATE_REQUESTED, TOPRIZEBILLENTITYSTATE_SHIPPED, TOPRIZEBILLENTITYSTATE_DONE,
 */
@property (nonatomic, copy) NSString *state;
/**
 *
 *
 *
 */
@property (nonatomic, copy) NSString *receiver;
/**
 *
 *
 *
 */
@property (nonatomic, copy) NSString *mobilephone;
/**
 *
 *
 *
 */
@property (nonatomic, copy) NSString *receiveAddress;
/**
 *
 *
 *
 */
@property (nonatomic, copy) NSString *employee;
/**
 *
 *
 *
 */
@property (nonatomic, copy) NSString *logisticsCompany;
/**
 *
 *
 *
 */
@property (nonatomic, copy) NSString *trackingNumber;
@end /* interface TOPrizeBillEntity */



/**
 *  @Title: Entity
 @Description: 经销商员工职位
 @author onlineGenerator
 @date 2016-05-02 17:39:21
 @version V1.0
 
 
 */
@interface TOPositionEntity : JSONModel
/**
 * 方法: 取得java.lang.String
 *
 *
 */
@property (nonatomic, copy) NSString *fid;
/**
 * 方法: 取得java.lang.String
 *
 *
 */
@property (nonatomic, copy) NSString *code;
/**
 * 方法: 取得java.lang.String
 *
 *
 */
@property (nonatomic, copy) NSString *name;
/**
 * 方法: 取得java.math.BigDecimal
 *
 *
 */
@property (nonatomic, strong) NSNumber *commission;
/**
 * (no documentation provided)
 *
 *
 */
@property (nonatomic, strong) NSNumber *lowestDiscount;
/**
 * 方法: 取得java.lang.String
 *
 *
 */
@property (nonatomic, copy) NSString *resellerCode;
@end /* interface TOPositionEntity */



/**
 *  @Title: Entity
 @Description: 闯关题目
 @author onlineGenerator
 @date 2016-11-13 20:47:49
 @version V1.0
 
 */
@interface TOPassLevelTopicEntity : JSONModel
/**
 * 方法: 取得主键
 *
 *
 */
@property (nonatomic, copy) NSString *fid;
/**
 * 方法: 取得题目类型
 *
 * 取值: PASSLEVELTOPICTYPE_SINGLE, PASSLEVELTOPICTYPE_MULTIPLE, PASSLEVELTOPICTYPE_TRUEORFALSE, PASSLEVELTOPICTYPE_GAPFILLING, PASSLEVELTOPICTYPE_SHORTANSWER,
 */
@property (nonatomic, copy) NSString *topicType;
/**
 * 方法: 取得行号
 *
 *
 */
@property (nonatomic, assign) NSInteger lineNo;
/**
 * 方法: 取得标题
 *
 *
 */
@property (nonatomic, copy) NSString *title;
/**
 * 方法: 取得答案
 *
 *
 */
@property (nonatomic, copy) NSString *answer;
/**
 * 方法: 取得分数
 *
 *
 */
@property (nonatomic, strong) NSNumber *grade;
/**
 * 方法: 取得闯关id
 *
 *
 */
@property (nonatomic, copy) NSString *passLevelId;
/**
 * 选项
 * @see TOPassLevelTopicOptionEntity
 *
 */
@property (nonatomic, strong) NSArray<TOPassLevelTopicOptionEntity> *options;
@end /* interface TOPassLevelTopicEntity */



/**
 *  @Title: Entity
 @Description: 订油单的促销事件记录
 @author onlineGenerator
 @date 2016-10-19 17:43:12
 @version V1.0
 
 
 */
@interface TOOrderPromotionEntity : JSONModel
/**
 * 方法: 主键
 *
 *
 */
@property (nonatomic, copy) NSString *fid;
/**
 * 方法: 创建人名称
 *
 *
 */
@property (nonatomic, copy) NSString *createName;
/**
 * 方法: 创建人登录名称
 *
 *
 */
@property (nonatomic, copy) NSString *createBy;
/**
 * 方法: 创建日期
 *
 *
 */
@property (nonatomic, copy) NSString *createDate;
/**
 * 方法: 更新人名称
 *
 *
 */
@property (nonatomic, copy) NSString *updateName;
/**
 * 方法: 更新人登录名称
 *
 *
 */
@property (nonatomic, copy) NSString *updateBy;
/**
 * 方法: 更新日期
 *
 *
 */
@property (nonatomic, copy) NSString *updateDate;
/**
 * 方法: 所属部门
 *
 *
 */
@property (nonatomic, copy) NSString *sysOrgCode;
/**
 * 方法: 商品标识
 *
 *
 */
@property (nonatomic, copy) NSString *goodsId;
/**
 * 方法: 商品代码
 *
 *
 */
@property (nonatomic, copy) NSString *goodsCode;
/**
 * 方法: 商品名称
 *
 *
 */
@property (nonatomic, copy) NSString *goodsName;
/**
 * 方法: 促销商品数量
 *
 *
 */
@property (nonatomic, strong) NSNumber *promotionNumber;
/**
 * 方法: 促销金额
 *
 *
 */
@property (nonatomic, strong) NSNumber *promotionMoney;
/**
 * 方法: 订单号
 *
 *
 */
@property (nonatomic, copy) NSString *orderNumber;
/**
 * 方法: 折扣率
 *
 *
 */
@property (nonatomic, strong) NSNumber *discountRate;
/**
 * 方法: 抽奖红包
 *
 *
 */
@property (nonatomic, copy) NSString *lotteryPackage;
/**
 * 方法: 微信卡号
 *
 *
 */
@property (nonatomic, copy) NSString *wxcardNumber;
/**
 * 方法: 微信卡券面额
 *
 *
 */
@property (nonatomic, copy) NSString *wxcardDenomation;
/**
 * 方法: 微信卡券实际减免
 *
 *
 */
@property (nonatomic, copy) NSString *wxcardRealDeduction;
/**
 * 方法: 京东E卡面额
 *
 *
 */
@property (nonatomic, strong) NSNumber *jdEcardDenomation;
/**
 * 方法: 红包面额
 *
 *
 */
@property (nonatomic, strong) NSNumber *redPackageNumber;
/**
 * 方法: 红包次数
 *
 *
 */
@property (nonatomic, strong) NSNumber *redPackageCount;
/**
 * 方法: 取得优先级
 *
 *
 */
@property (nonatomic, assign) NSInteger prority;
@end /* interface TOOrderPromotionEntity */



/**
 *  @Title: Entity
 @Description: 订单
 @author onlineGenerator
 @date 2016-05-06 12:53:09
 @version V1.0
 
 
 */
@interface TOOrderEntity : JSONModel
/**
 * 方法: 取得java.lang.String
 *
 *
 */
@property (nonatomic, copy) NSString *fid;
/**
 * 方法: 取得java.lang.String
 *
 *
 */
@property (nonatomic, copy) NSString *createName;
/**
 * 方法: 取得java.lang.String
 *
 *
 */
@property (nonatomic, copy) NSString *createBy;
/**
 * 方法: 取得java.util.Date
 *
 *
 */
@property (nonatomic, copy) NSString *createDate;
/**
 * 方法: 取得java.lang.String
 *
 *
 */
@property (nonatomic, copy) NSString *updateName;
/**
 * 方法: 取得java.lang.String
 *
 *
 */
@property (nonatomic, copy) NSString *updateBy;
/**
 * 方法: 取得java.util.Date
 *
 *
 */
@property (nonatomic, copy) NSString *updateDate;
/**
 * 方法: 取得java.lang.String
 *
 *
 */
@property (nonatomic, copy) NSString *sysOrgCode;
/**
 * 方法: 取得java.lang.String
 *
 *
 */
@property (nonatomic, copy) NSString *orderNumber;
/**
 * 方法: 取得java.util.Date
 *
 *
 */
@property (nonatomic, copy) NSString *orderTime;
/**
 * 方法: 取得java.lang.String
 *
 *
 */
@property (nonatomic, copy) NSString *guideId;
/**
 * 方法: 取得java.lang.String
 *
 *
 */
@property (nonatomic, copy) NSString *orderState;
/**
 * 方法: 取得java.lang.String
 *
 *
 */
@property (nonatomic, copy) NSString *consumerId;
/**
 * 方法: 取得java.lang.String
 *
 *
 */
@property (nonatomic, copy) NSString *goodsNum;
/**
 * 方法: 取得java.math.BigDecimal
 *
 *
 */
@property (nonatomic, strong) NSNumber *orderPrice;
/**
 * 方法: 取得java.lang.String
 *
 *
 */
@property (nonatomic, copy) NSString *receiverName;
/**
 * 方法: 取得java.lang.String
 *
 *
 */
@property (nonatomic, copy) NSString *receiverMobile;
/**
 * 方法: 取得java.lang.String
 *
 *
 */
@property (nonatomic, copy) NSString *receiverAddress;
/**
 * 方法: 取得java.lang.String
 *
 *
 */
@property (nonatomic, copy) NSString *isBill;
/**
 * 方法: 取得java.lang.String
 *
 *
 */
@property (nonatomic, copy) NSString *billType;
/**
 * 方法: 取得java.lang.String
 *
 *
 */
@property (nonatomic, copy) NSString *billTitle;
/**
 * 方法: 取得java.lang.String
 *
 *
 */
@property (nonatomic, copy) NSString *payType;
/**
 * (no documentation provided)
 *
 *
 */
@property (nonatomic, copy) NSString *consumerName;
/**
 * (no documentation provided)
 *
 *
 */
@property (nonatomic, copy) NSString *guideName;
/**
 * (no documentation provided)
 *
 *
 */
@property (nonatomic, copy) NSString *resellerName;
/**
 * 方法: 取得java.math.BigDecimal
 *
 *
 */
@property (nonatomic, strong) NSNumber *oldPrice;
@end /* interface TOOrderEntity */



/**
 *
 @Title: Entity
 @Description: 奖品详情
 @author onlineGenerator
 @date 2016-11-09 18:13:23
 @version V1.0
 
 
 */
@interface TOAwardEntity : JSONModel
/**
 * 方法: 取得java.lang.String
 *
 *
 */
@property (nonatomic, copy) NSString *fid;
/**
 * 方法: 取得java.lang.String
 *
 *
 */
@property (nonatomic, copy) NSString *createName;
/**
 * 方法: 取得java.lang.String
 *
 *
 */
@property (nonatomic, copy) NSString *createBy;
/**
 * 方法: 取得java.util.Date
 *
 *
 */
@property (nonatomic, copy) NSString *createDate;
/**
 * 方法: 取得java.lang.String
 *
 *
 */
@property (nonatomic, copy) NSString *updateName;
/**
 * 方法: 取得java.lang.String
 *
 *
 */
@property (nonatomic, copy) NSString *updateBy;
/**
 * 方法: 取得java.util.Date
 *
 *
 */
@property (nonatomic, copy) NSString *updateDate;
/**
 * 方法: 取得java.lang.String
 *
 *
 */
@property (nonatomic, copy) NSString *sysOrgCode;
/**
 * 方法: 取得java.lang.Integer
 *
 *
 */
@property (nonatomic, assign) NSInteger remainTotal;
/**
 * 方法: 取得java.math.BigDecimal
 *
 *
 */
@property (nonatomic, strong) NSNumber *drawRate;
/**
 * 方法: 取得java.lang.String
 *
 *
 */
@property (nonatomic, copy) NSString *type;
/**
 * 方法: 取得java.math.BigDecimal
 *
 *
 */
@property (nonatomic, strong) NSNumber *number;
/**
 * 方法: 取得java.lang.String
 *
 *
 */
@property (nonatomic, copy) NSString *fdescription;
/**
 * 方法: 取得java.lang.String
 *
 *
 */
@property (nonatomic, copy) NSString *lotteryId;
@end /* interface TOAwardEntity */



/**
 *  @Title: Entity
 @Description: 商品标签分类
 @author onlineGenerator
 @date 2016-05-05 16:57:27
 @version V1.0
 
 
 */
@interface TOGoodsLabelCategoryEntity : JSONModel
/**
 * 方法: 取得java.lang.String
 *
 *
 */
@property (nonatomic, copy) NSString *fid;
/**
 * 方法: 取得java.lang.String
 *
 *
 */
@property (nonatomic, copy) NSString *sysOrgCode;
/**
 * 方法: 取得java.lang.String
 *
 *
 */
@property (nonatomic, copy) NSString *sysCompanyCode;
/**
 * 方法: 取得java.lang.String
 *
 *
 */
@property (nonatomic, copy) NSString *code;
/**
 * 方法: 取得java.lang.String
 *
 *
 */
@property (nonatomic, copy) NSString *name;
@end /* interface TOGoodsLabelCategoryEntity */



/**
 *  @Title: Entity
 @Description: 商品分类
 @author onlineGenerator
 @date 2016-05-10 10:17:53
 @version V1.0
 
 
 */
@interface TOGoodsCategoryEntity : JSONModel
/**
 * (no documentation provided)
 *
 *
 */
@property (nonatomic, copy) NSString *upperName;
/**
 * 方法: 取得java.lang.String
 *
 *
 */
@property (nonatomic, copy) NSString *fid;
/**
 * 方法: 取得java.lang.String
 *
 *
 */
@property (nonatomic, copy) NSString *code;
/**
 * 方法: 取得java.lang.String
 *
 *
 */
@property (nonatomic, copy) NSString *name;
/**
 * 方法: 取得java.lang.String
 *
 *
 */
@property (nonatomic, copy) NSString *upperId;
/**
 * 方法: 取得java.lang.Integer
 *
 *
 */
@property (nonatomic, assign) NSInteger level;
@end /* interface TOGoodsCategoryEntity */



/**
 *  经销商和商品关系表。
 
 @author Debenson
 @since 0.1
 
 */
@interface VOResellerGoodsEntity : JSONModel
/**
 * 方法: 取得java.lang.String
 *
 *
 */
@property (nonatomic, copy) NSString *fid;
/**
 * 方法: 取得java.util.Date
 *
 *
 */
@property (nonatomic, copy) NSString *createDate;
/**
 * 方法: 取得java.util.Date
 *
 *
 */
@property (nonatomic, copy) NSString *onlineTime;
/**
 * 方法: 取得java.lang.String
 *
 *
 */
@property (nonatomic, copy) NSString *company;
/**
 * 方法: 取得java.lang.String
 *
 *
 */
@property (nonatomic, copy) NSString *code;
/**
 * 方法: 取得java.lang.String
 *
 *
 */
@property (nonatomic, copy) NSString *name;
/**
 * 方法: 取得java.lang.String
 *
 *
 */
@property (nonatomic, copy) NSString *number;
/**
 * 方法: 取得java.lang.String
 *
 *
 */
@property (nonatomic, copy) NSString *categoryId;
/**
 * 方法: 取得java.lang.String
 *
 *
 */
@property (nonatomic, copy) NSString *brandId;
/**
 * 方法: 取得java.lang.String
 *
 *
 */
@property (nonatomic, copy) NSString *keyword;
/**
 * 方法: 取得java.math.BigDecimal
 *
 *
 */
@property (nonatomic, strong) NSNumber *guidePrice;
/**
 * 方法: 取得java.math.BigDecimal
 *
 *
 */
@property (nonatomic, strong) NSNumber *tagPrice;
/**
 * 方法: 取得java.math.BigDecimal
 *
 *
 */
@property (nonatomic, strong) NSNumber *costPrice;
/**
 * 方法: 取得java.lang.String
 *
 *
 */
@property (nonatomic, copy) NSString *state;
/**
 * 方法: 取得java.lang.Integer
 *
 *
 */
@property (nonatomic, assign) NSInteger inv;
/**
 * 方法: 取得java.lang.String
 *
 *
 */
@property (nonatomic, copy) NSString *detailedIntro;
/**
 * 方法: 取得java.lang.Double
 *
 *
 */
@property (nonatomic, assign) double weight;
/**
 * 方法: 取得java.lang.String
 *
 *
 */
@property (nonatomic, copy) NSString *unit;
/**
 * 方法: 取得java.lang.String
 *
 *
 */
@property (nonatomic, copy) NSString *productProfile;
/**
 * 方法: 取得java.lang.String
 *
 *
 */
@property (nonatomic, copy) NSString *power;
/**
 * 方法: 取得java.lang.String
 *
 *
 */
@property (nonatomic, copy) NSString *colorTemperature;
/**
 * 方法: 取得java.lang.String
 *
 *
 */
@property (nonatomic, copy) NSString *spec;
/**
 * 方法: 取得java.lang.String
 *
 *
 */
@property (nonatomic, copy) NSString *function;
/**
 * 方法: 取得java.lang.String
 *
 *
 */
@property (nonatomic, copy) NSString *material;
/**
 * 方法: 取得java.lang.String
 *
 *
 */
@property (nonatomic, copy) NSString *lightSource;
/**
 * 方法: 取得java.lang.String
 *
 *
 */
@property (nonatomic, copy) NSString *goodsStyle;
/**
 * 方法: 取得java.lang.String
 *
 *
 */
@property (nonatomic, copy) NSString *series;
/**
 * 方法: 取得java.lang.String
 *
 *
 */
@property (nonatomic, copy) NSString *area;
/**
 * 方法: 取得java.lang.String
 *
 *
 */
@property (nonatomic, copy) NSString *size;
/**
 * 方法: 取得java.lang.String
 *
 *
 */
@property (nonatomic, copy) NSString *space;
/**
 * 方法: 取得java.lang.String
 *
 *
 */
@property (nonatomic, copy) NSString *installMethod;
/**
 * 方法: 取得java.lang.String
 *
 *
 */
@property (nonatomic, copy) NSString *lightNumber;
/**
 * 方法: 取得java.lang.String
 *
 *
 */
@property (nonatomic, copy) NSString *pictures;
/**
 * 方法: 取得java.lang.String
 *
 *
 */
@property (nonatomic, copy) NSString *barcode;
/**
 * 方法: 取得java.lang.String
 *
 *
 */
@property (nonatomic, copy) NSString *resellerId;
/**
 * (no documentation provided)
 *
 *
 */
@property (nonatomic, copy) NSString *categoryName;
/**
 * (no documentation provided)
 *
 *
 */
@property (nonatomic, copy) NSString *brandName;
@end /* interface VOResellerGoodsEntity */



/**
 *  @Title: Entity
 @Description: t_o_goods
 @author onlineGenerator
 @date 2016-05-12 15:44:01
 @version V1.0
 
 
 */
@interface TOGoodsEntity : JSONModel
/**
 * (no documentation provided)
 *
 *
 */
@property (nonatomic, assign) NSInteger resellerInv;
/**
 * (no documentation provided)
 *
 *
 */
@property (nonatomic, strong) NSNumber *resellerTagPrice;
/**
 * (no documentation provided)
 *
 *
 */
@property (nonatomic, copy) NSString *resellerState;
/**
 * (no documentation provided)
 *
 *
 */
@property (nonatomic, copy) NSString *categoryName;
/**
 * (no documentation provided)
 *
 *
 */
@property (nonatomic, copy) NSString *brandName;
/**
 * 方法: 取得java.lang.String
 *
 *
 */
@property (nonatomic, copy) NSString *fid;
/**
 * 方法: 取得java.util.Date
 *
 *
 */
@property (nonatomic, copy) NSString *createDate;
/**
 * 方法: 取得java.util.Date
 *
 *
 */
@property (nonatomic, copy) NSString *onlineTime;
/**
 * 方法: 取得java.lang.String
 *
 *
 */
@property (nonatomic, copy) NSString *company;
/**
 * 方法: 取得java.lang.String
 *
 *
 */
@property (nonatomic, copy) NSString *code;
/**
 * 方法: 取得java.lang.String
 *
 *
 */
@property (nonatomic, copy) NSString *name;
/**
 * 方法: 取得java.lang.String
 *
 *
 */
@property (nonatomic, copy) NSString *number;
/**
 * 方法: 取得java.lang.String
 *
 *
 */
@property (nonatomic, copy) NSString *categoryId;
/**
 * 方法: 取得java.lang.String
 *
 *
 */
@property (nonatomic, copy) NSString *brandId;
/**
 * 方法: 取得java.lang.String
 *
 *
 */
@property (nonatomic, copy) NSString *keyword;
/**
 * 方法: 取得java.math.BigDecimal
 *
 *
 */
@property (nonatomic, strong) NSNumber *guidePrice;
/**
 * 方法: 取得java.math.BigDecimal
 *
 *
 */
@property (nonatomic, strong) NSNumber *tagPrice;
/**
 * 方法: 取得java.math.BigDecimal
 *
 *
 */
@property (nonatomic, strong) NSNumber *costPrice;
/**
 * 方法: 取得java.lang.String
 *
 *
 */
@property (nonatomic, copy) NSString *state;
/**
 * 方法: 取得java.lang.Integer
 *
 *
 */
@property (nonatomic, assign) NSInteger inv;
/**
 * 方法: 取得java.lang.String
 *
 *
 */
@property (nonatomic, copy) NSString *detailedIntro;
/**
 * 方法: 取得java.lang.Double
 *
 *
 */
@property (nonatomic, assign) double weight;
/**
 * 方法: 取得java.lang.String
 *
 *
 */
@property (nonatomic, copy) NSString *unit;
/**
 * 方法: 取得java.lang.String
 *
 *
 */
@property (nonatomic, copy) NSString *productProfile;
/**
 * 方法: 取得java.lang.String
 *
 *
 */
@property (nonatomic, copy) NSString *power;
/**
 * 方法: 取得java.lang.String
 *
 *
 */
@property (nonatomic, copy) NSString *colorTemperature;
/**
 * 方法: 取得java.lang.String
 *
 *
 */
@property (nonatomic, copy) NSString *spec;
/**
 * 方法: 取得java.lang.String
 *
 *
 */
@property (nonatomic, copy) NSString *function;
/**
 * 方法: 取得java.lang.String
 *
 *
 */
@property (nonatomic, copy) NSString *material;
/**
 * 方法: 取得java.lang.String
 *
 *
 */
@property (nonatomic, copy) NSString *lightSource;
/**
 * 方法: 取得java.lang.String
 *
 *
 */
@property (nonatomic, copy) NSString *goodsStyle;
/**
 * 方法: 取得java.lang.String
 *
 *
 */
@property (nonatomic, copy) NSString *series;
/**
 * 方法: 取得java.lang.String
 *
 *
 */
@property (nonatomic, copy) NSString *area;
/**
 * 方法: 取得java.lang.String
 *
 *
 */
@property (nonatomic, copy) NSString *size;
/**
 * 方法: 取得java.lang.String
 *
 *
 */
@property (nonatomic, copy) NSString *space;
/**
 * 方法: 取得java.lang.String
 *
 *
 */
@property (nonatomic, copy) NSString *installMethod;
/**
 * 方法: 取得java.lang.String
 *
 *
 */
@property (nonatomic, copy) NSString *lightNumber;
/**
 * 方法: 取得java.lang.String
 *
 *
 */
@property (nonatomic, copy) NSString *pictures;
/**
 * 方法: 取得java.lang.String
 *
 *
 */
@property (nonatomic, copy) NSString *barcode;
/**
 * (no documentation provided)
 * @see TOGoodsForResellerEntity
 *
 */
@property (nonatomic, strong) NSArray<TOGoodsForResellerEntity> *goodsResellerList;
@end /* interface TOGoodsEntity */



/**
 *  @Title: Entity
 @Description: 导购分成表
 @author onlineGenerator
 @date 2016-05-16 16:15:27
 @version V1.0
 
 
 */
@interface TOCommissionHistEntity : JSONModel
/**
 * 方法: 取得java.lang.String
 *
 *
 */
@property (nonatomic, copy) NSString *fid;
/**
 * 方法: 取得java.lang.String
 *
 *
 */
@property (nonatomic, copy) NSString *createName;
/**
 * 方法: 取得java.util.Date
 *
 *
 */
@property (nonatomic, copy) NSString *createDate;
/**
 * 方法: 取得java.lang.String
 *
 *
 */
@property (nonatomic, copy) NSString *updateName;
/**
 * 方法: 取得java.lang.String
 *
 *
 */
@property (nonatomic, copy) NSString *updateBy;
/**
 * 方法: 取得java.util.Date
 *
 *
 */
@property (nonatomic, copy) NSString *updateDate;
/**
 * 方法: 取得java.lang.String
 *
 *
 */
@property (nonatomic, copy) NSString *resellerCode;
/**
 * 方法: 取得java.lang.String
 *
 *
 */
@property (nonatomic, copy) NSString *employeeId;
/**
 * 方法: 取得java.lang.String
 *
 *
 */
@property (nonatomic, copy) NSString *orderId;
/**
 * 方法: 取得java.math.BigDecimal
 *
 *
 */
@property (nonatomic, strong) NSNumber *amount;
/**
 * 方法: 取得java.math.BigDecimal
 *
 *
 */
@property (nonatomic, strong) NSNumber *afteramount;
/**
 * 方法: 取得java.lang.String
 *
 *
 */
@property (nonatomic, copy) NSString *remark;
/**
 * 方法: 设置java.lang.String
 *
 *
 */
@property (nonatomic, copy) NSString *orderNumber;
/**
 * (no documentation provided)
 *
 *
 */
@property (nonatomic, copy) NSString *employeeName;
/**
 * 方法: 设置java.lang.String
 *
 *
 */
@property (nonatomic, copy) NSString *state;
@end /* interface TOCommissionHistEntity */



/**
 *
 @Title: Entity
 @Description: 提现申请
 @author onlineGenerator
 @date 2016-08-24 09:40:02
 @version V1.0
 
 
 */
@interface TOApplyBillEntity : JSONModel
/**
 * 方法: 取得java.lang.String
 *
 *
 */
@property (nonatomic, copy) NSString *fid;
/**
 * 方法: 取得java.lang.String
 *
 *
 */
@property (nonatomic, copy) NSString *createName;
/**
 * 方法: 取得java.lang.String
 *
 *
 */
@property (nonatomic, copy) NSString *createBy;
/**
 * 方法: 取得java.util.Date
 *
 *
 */
@property (nonatomic, copy) NSString *createDate;
/**
 * 方法: 取得java.lang.String
 *
 *
 */
@property (nonatomic, copy) NSString *updateName;
/**
 * 方法: 取得java.lang.String
 *
 *
 */
@property (nonatomic, copy) NSString *updateBy;
/**
 * 方法: 取得java.util.Date
 *
 *
 */
@property (nonatomic, copy) NSString *updateDate;
/**
 * 方法: 取得java.lang.String
 *
 *
 */
@property (nonatomic, copy) NSString *sysOrgCode;
/**
 * 方法: 取得java.lang.String
 *
 *
 */
@property (nonatomic, copy) NSString *billNumber;
/**
 * 方法: 取得java.lang.String
 *
 *
 */
@property (nonatomic, copy) NSString *guideId;
/**
 * 方法: 取得java.lang.String
 *
 *
 */
@property (nonatomic, copy) NSString *guideName;
/**
 * 方法: 取得java.math.BigDecimal
 *
 *
 */
@property (nonatomic, strong) NSNumber *applyMoney;
/**
 * 方法: 取得java.math.BigDecimal
 *
 *
 */
@property (nonatomic, strong) NSNumber *beforeMoney;
/**
 * 方法: 取得java.math.BigDecimal
 *
 *
 */
@property (nonatomic, strong) NSNumber *afterMoney;
/**
 * 方法: 取得java.lang.String
 *
 *
 */
@property (nonatomic, copy) NSString *billStates;
@end /* interface TOApplyBillEntity */



/**
 *  商品分享返回数据。
 
 @author Debenson
 @since 0.1
 
 */
@interface RsShareResponse : JSONModel
/**
 * 分享记录标识
 *
 *
 */
@property (nonatomic, copy) NSString *shareId;
/**
 * 分享页面链接
 *
 *
 */
@property (nonatomic, copy) NSString *url;
@end /* interface RsShareResponse */



/**
 *  学习任务查询条件。
 
 @author thor
 
 
 */
@interface StudyTaskCondition : JSONModel
/**
 * (no documentation provided)
 *
 *
 */
@property (nonatomic, copy) NSString *typeEquals;
/**
 * (no documentation provided)
 *
 *
 */
@property (nonatomic, copy) NSString *stateEquals;
/**
 * (no documentation provided)
 *
 *
 */
@property (nonatomic, copy) NSString *titleLike;
/**
 * (no documentation provided)
 *
 *
 */
@property (nonatomic, copy) NSString *employeeIdEquals;
/**
 * (no documentation provided)
 *
 *
 */
@property (nonatomic, strong) DataPage *page;
@end /* interface StudyTaskCondition */



/**
 *  @author Debenson
 @since 0.1
 
 */
@interface DeleteCartRequest : JSONModel
/**
 * 购物车标识列表
 * @see NSString
 *
 */
@property (nonatomic, strong) NSArray<NSString *> *cartIds;
@end /* interface DeleteCartRequest */



/**
 *  积分详情
 
 @author wolv
 
 
 */
@interface RsScoreDetails : JSONModel
/**
 *
 *
 *
 */
@property (nonatomic, assign) double currentScore;
/**
 *
 *
 *
 */
@property (nonatomic, assign) NSInteger quarterlyRanking;
/**
 *
 *
 *
 */
@property (nonatomic, assign) NSInteger annualRanking;
/**
 * (no documentation provided)
 * @see TOScoreRecordEntity
 *
 */
@property (nonatomic, strong) NSArray<TOScoreRecordEntity> *recoreds;
@end /* interface RsScoreDetails */



/**
 *  促销计算结果。
 
 @author Debenson
 @since 0.1
 
 */
@interface RsActionResult : JSONModel
/**
 * 结果集合，空集合表示没有促销。
 * @see Action
 *
 */
@property (nonatomic, strong) NSArray<Action> *actions;
@end /* interface RsActionResult */



/**
 *  兑奖单
 
 @author wolv
 
 
 */
@interface RsPrizeBill : JSONModel
/**
 *
 *
 *
 */
@property (nonatomic, strong) TOPrizeBillEntity *bill;
/**
 *
 * @see TOPrizeBillDetailsEntity
 *
 */
@property (nonatomic, strong) NSArray<TOPrizeBillDetailsEntity> *details;
@end /* interface RsPrizeBill */



/**
 *  订单筛选条件。
 
 @author Debenson
 @since 0.1
 
 */
@interface OrderFilter : JSONModel
/**
 * 经销商代码
 *
 *
 */
@property (nonatomic, copy) NSString *resellerCodeEquals;
/**
 *
 *
 *
 */
@property (nonatomic, copy) NSString *orderStateEquals;
/**
 * 消费者名称或手机号等于
 *
 *
 */
@property (nonatomic, copy) NSString *consumerNameOrMobileEquals;
/**
 * 客户标识等于
 *
 *
 */
@property (nonatomic, copy) NSString *consumerIdEquals;
/**
 * 分页数据
 *
 *
 */
@property (nonatomic, strong) DataPage *dp;
@end /* interface OrderFilter */



/**
 *  查询京东E卡对象
 
 @author nevermore
 @since 0.1
 
 */
@interface Draw : JSONModel
/**
 * (no documentation provided)
 *
 *
 */
@property (nonatomic, copy) NSString *fid;
/**
 * (no documentation provided)
 *
 *
 */
@property (nonatomic, copy) NSString *lotteryId;
/**
 * (no documentation provided)
 *
 *
 */
@property (nonatomic, copy) NSString *drawDate;
/**
 * (no documentation provided)
 *
 *
 */
@property (nonatomic, copy) NSString *winnerId;
/**
 * (no documentation provided)
 *
 *
 */
@property (nonatomic, copy) NSString *awardId;
/**
 * (no documentation provided)
 *
 *
 */
@property (nonatomic, copy) NSString *awardDescription;
/**
 * (no documentation provided)
 *
 *
 */
@property (nonatomic, copy) NSString *orderNumber;
/**
 * (no documentation provided)
 *
 *
 */
@property (nonatomic, copy) NSString *state;
@end /* interface Draw */



/**
 *  @author Administrator
 @since 0.1
 
 */
@interface HotFilter : JSONModel
/**
 * (no documentation provided)
 * @see DataDict
 *
 */
@property (nonatomic, strong) NSArray<DataDict> *list;
@end /* interface HotFilter */



/**
 *  @author Debenson
 @since 0.1
 
 */
@interface GoodsCategory : JSONModel
/**
 * 分类id
 *
 *
 */
@property (nonatomic, copy) NSString *fid;
/**
 * 分类名称
 *
 *
 */
@property (nonatomic, copy) NSString *name;
/**
 * 下级分类列表
 * @see GoodsCategory
 *
 */
@property (nonatomic, strong) NSArray<GoodsCategory> *children;
@end /* interface GoodsCategory */



/**
 *  @author MHk
 @since 0.1
 
 */
@interface RsEmployeeRequest : JSONModel
/**
 * (no documentation provided)
 *
 *
 */
@property (nonatomic, strong) TOEmployee *employee;
@end /* interface RsEmployeeRequest */



/**
 *  修改密码请求。
 
 @author Debenson
 @since 0.1
 
 */
@interface ModifyPasswordRequest : JSONModel
/**
 * 员工标识。
 *
 *
 */
@property (nonatomic, copy) NSString *employeeId;
/**
 * 原密码。
 *
 *
 */
@property (nonatomic, copy) NSString *oldPassword;
/**
 * 新密码
 *
 *
 */
@property (nonatomic, copy) NSString *fnewPassword;
@end /* interface ModifyPasswordRequest */



/**
 *  经销商用户登录信息。
 
 @author Debenson
 @since 0.1
 
 */
@interface LoginInfo : JSONModel
/**
 * 用户名
 *
 *
 */
@property (nonatomic, copy) NSString *username;
/**
 * 密码
 *
 *
 */
@property (nonatomic, copy) NSString *password;
@end /* interface LoginInfo */



/**
 *  客户查询条件。
 
 @author Debenson
 @since 0.1
 
 */
@interface ConsumerQueryCondition : JSONModel
/**
 * 经销商代码等于
 *
 *
 */
@property (nonatomic, copy) NSString *resellerCodeEquals;
/**
 * 名称等于
 *
 *
 */
@property (nonatomic, copy) NSString *nameEquals;
/**
 * 手机号等于
 *
 *
 */
@property (nonatomic, copy) NSString *mobileEquals;
/**
 * 创建时间起始于，格式: yyyy-MM-dd HH:mm:ss
 *
 *
 */
@property (nonatomic, copy) NSString *createTimeBegin;
/**
 * 创建时间截止于，格式: yyyy-MM-dd HH:mm:ss
 *
 *
 */
@property (nonatomic, copy) NSString *createTimeEnd;
/**
 * 分布查询条件， 可空
 *
 *
 */
@property (nonatomic, strong) DataPage *page;
@end /* interface ConsumerQueryCondition */



/**
 *  异常代码。
 
 @author Debenson
 @since 0.1
 
 */
@interface ExceptionCode : JSONModel
/**
 * 异常代码
 *
 *
 */
@property (nonatomic, assign) NSInteger code;
/**
 * 异常信息
 *
 *
 */
@property (nonatomic, copy) NSString *message;
@end /* interface ExceptionCode */



/**
 * (no documentation provided)
 */
@interface EarningsResponse : JSONModel
/**
 * (no documentation provided)
 *
 *
 */
@property (nonatomic, strong) NSNumber *accountTotal;
/**
 * (no documentation provided)
 *
 *
 */
@property (nonatomic, strong) NSNumber *yesterdayEarnings;
/**
 * (no documentation provided)
 *
 *
 */
@property (nonatomic, strong) NSNumber *historyEarning;
/**
 * (no documentation provided)
 *
 *
 */
@property (nonatomic, strong) NSNumber *applytotal;
@end /* interface EarningsResponse */



/**
 *  公告筛选条件
 
 @author thor
 @date 2016年11月16日 上午11:53:21
 @version 0.1
 
 */
@interface AfficheCondition : JSONModel
/**
 * (no documentation provided)
 *
 *
 */
@property (nonatomic, strong) DataPage *page;
/**
 * (no documentation provided)
 *
 *
 */
@property (nonatomic, copy) NSString *userIdEquals;
/**
 * (no documentation provided)
 *
 *
 */
@property (nonatomic, assign) NSInteger dayCountEquals;
/**
 * (no documentation provided)
 *
 *
 */
@property (nonatomic, copy) NSString *afficheTypeEuals;
/**
 * (no documentation provided)
 *
 *
 */
@property (nonatomic, copy) NSString *order;
/**
 * (no documentation provided)
 *
 *
 */
@property (nonatomic, copy) NSString *sort;
@end /* interface AfficheCondition */



/**
 *  @author NuoSa
 
 @since 0.1
 
 */
@interface GoodsResponse : PageRows
/**
 * 商品列表
 * @see TOGoodsEntity
 *
 */
@property (nonatomic, strong) NSArray<TOGoodsEntity> *goodsEntity;
@end /* interface GoodsResponse */



/**
 *  查询京东E卡分页
 
 @author nevermore
 @since 0.1
 
 */
@interface RsJingDongECardResponse : PageRows
/**
 * (no documentation provided)
 * @see GroupByOrderNumber
 *
 */
@property (nonatomic, strong) NSArray<GroupByOrderNumber> *list;
@end /* interface RsJingDongECardResponse */



/**
 *  系统用户父类表
 @author  张代浩
 
 */
@interface TSBaseUser : IdEntity
/**
 * (no documentation provided)
 *
 *
 */
@property (nonatomic, copy) NSString *departid;
/**
 * (no documentation provided)
 *
 *
 */
@property (nonatomic, strong) NSData *signature;
/**
 * (no documentation provided)
 *
 *
 */
@property (nonatomic, copy) NSString *browser;
/**
 * (no documentation provided)
 *
 *
 */
@property (nonatomic, copy) NSString *userKey;
/**
 * (no documentation provided)
 *
 *
 */
@property (nonatomic, assign) short status;
/**
 * (no documentation provided)
 *
 *
 */
@property (nonatomic, assign) short activitiSync;
/**
 * (no documentation provided)
 *
 *
 */
@property (nonatomic, copy) NSString *password;
/**
 * (no documentation provided)
 *
 *
 */
@property (nonatomic, copy) NSString *userName;
/**
 * (no documentation provided)
 *
 *
 */
@property (nonatomic, copy) NSString *realName;
/**
 * (no documentation provided)
 *
 *
 */
@property (nonatomic, strong) TSDepart *currentDepart;
/**
 * (no documentation provided)
 * @see TSUserOrg
 *
 */
@property (nonatomic, strong) NSArray<TSUserOrg> *userOrgList;
@end /* interface TSBaseUser */



/**
 *  部门机构表
 @author  张代浩
 
 */
@interface TSDepart : IdEntity
/**
 * (no documentation provided)
 *
 *
 */
@property (nonatomic, strong) TSDepart *TSPDepart;
/**
 * (no documentation provided)
 *
 *
 */
@property (nonatomic, copy) NSString *departname;
/**
 * (no documentation provided)
 *
 *
 */
@property (nonatomic, copy) NSString *fdescription;
/**
 * (no documentation provided)
 * @see TSDepart
 *
 */
@property (nonatomic, strong) NSArray<TSDepart> *TSDeparts;
/**
 * (no documentation provided)
 *
 *
 */
@property (nonatomic, copy) NSString *orgCode;
/**
 * (no documentation provided)
 *
 *
 */
@property (nonatomic, copy) NSString *orgType;
/**
 * (no documentation provided)
 *
 *
 */
@property (nonatomic, copy) NSString *mobile;
/**
 * (no documentation provided)
 *
 *
 */
@property (nonatomic, copy) NSString *fax;
/**
 * (no documentation provided)
 *
 *
 */
@property (nonatomic, copy) NSString *address;
@end /* interface TSDepart */



/**
 *  查询抽奖结果分页
 
 @author nevermore
 @since 0.1
 
 */
@interface RsAwardDraw : PageRows
/**
 * (no documentation provided)
 *
 *
 */
@property (nonatomic, strong) TODrawEntity *draw;
/**
 * (no documentation provided)
 *
 *
 */
@property (nonatomic, strong) TOAwardEntity *award;
@end /* interface RsAwardDraw */



/**
 *  用户-组织机构 实体
 <p/>
 <p><b>User:</b> zhanggm <a href="mailto:guomingzhang2008@gmail.com">guomingzhang2008@gmail.com</a></p>
 <p><b>Date:</b> 2014-08-22 15:39</p>
 
 @author 张国明
 
 */
@interface TSUserOrg : IdEntity
/**
 * (no documentation provided)
 *
 *
 */
@property (nonatomic, strong) TSUser *tsUser;
/**
 * (no documentation provided)
 *
 *
 */
@property (nonatomic, strong) TSDepart *tsDepart;
@end /* interface TSUserOrg */



/**
 *  查询抽奖结果分页
 
 @author nevermore
 @since 0.1
 
 */
@interface RsLotteryResponse : PageRows
/**
 * (no documentation provided)
 * @see RsAwardDraw
 *
 */
@property (nonatomic, strong) NSArray<RsAwardDraw> *list;
@end /* interface RsLotteryResponse */



/**
 * (no documentation provided)
 */
@interface PassLevelResponse : PageRows
/**
 * 闯关列表
 * @see TOPassLevelEntity
 *
 */
@property (nonatomic, strong) NSArray<TOPassLevelEntity> *passLevelEntity;
@end /* interface PassLevelResponse */



/**
 *  购物车返回对象
 
 @author Flash
 @since 0.1
 
 */
@interface ShopCartResponse : PageRows
/**
 * (no documentation provided)
 * @see TOShopcartEntity
 *
 */
@property (nonatomic, strong) NSArray<TOShopcartEntity> *shopcart;
@end /* interface ShopCartResponse */



/**
 *  @author Administrator
 @since 0.1
 
 */
@interface SceneResponse : PageRows
/**
 * (no documentation provided)
 * @see TOSceneEntity
 *
 */
@property (nonatomic, strong) NSArray<TOSceneEntity> *list;
@end /* interface SceneResponse */



/**
 *  奖品查询结果
 
 @author wolv
 
 
 */
@interface PrizeResponse : PageRows
/**
 *
 * @see TOPrizeEntity
 *
 */
@property (nonatomic, strong) NSArray<TOPrizeEntity> *prizes;
@end /* interface PrizeResponse */



/**
 *  订单返回对象
 
 @author wsx
 @since 0.1
 
 */
@interface OrderResponse : PageRows
/**
 * (no documentation provided)
 * @see OrderBill
 *
 */
@property (nonatomic, strong) NSArray<OrderBill> *orderBillList;
@end /* interface OrderResponse */



/**
 *  查询京东E卡分页
 
 @author nevermore
 @since 0.1
 
 */
@interface RsSimpleJingDongECardResponse : PageRows
/**
 * (no documentation provided)
 * @see TOJingdongEcardEntity
 *
 */
@property (nonatomic, strong) NSArray<TOJingdongEcardEntity> *list;
@end /* interface RsSimpleJingDongECardResponse */



/**
 *  流水明细分页查询结果
 
 @author nevermore
 @since 0.1
 
 */
@interface RsCommissionResponse : PageRows
/**
 * (no documentation provided)
 * @see TOCommissionHistEntity
 *
 */
@property (nonatomic, strong) NSArray<TOCommissionHistEntity> *list;
@end /* interface RsCommissionResponse */



/**
 *  客户分页查询结果。
 
 @author Debenson
 @since 0.1
 
 */
@interface ConsumerPageResult : PageRows
/**
 * 客户列表
 * @see TOConsumerEntity
 *
 */
@property (nonatomic, strong) NSArray<TOConsumerEntity> *results;
@end /* interface ConsumerPageResult */



/**
 *  查询提现进度分页
 
 @author nevermore
 @since 0.1
 
 */
@interface RsApplyBillResponse : PageRows
/**
 * (no documentation provided)
 * @see TOApplyBillEntity
 *
 */
@property (nonatomic, strong) NSArray<TOApplyBillEntity> *list;
@end /* interface RsApplyBillResponse */



/**
 * (no documentation provided)
 */
@interface AfficheResponse : PageRows
/**
 * (no documentation provided)
 * @see TOAfficheEntity
 *
 */
@property (nonatomic, strong) NSArray<TOAfficheEntity> *afficheEntity;
@end /* interface AfficheResponse */



/**
 *  系统用户表
 
 @author 张代浩
 
 */
@interface TSUser : TSBaseUser
/**
 * (no documentation provided)
 *
 *
 */
@property (nonatomic, copy) NSString *signatureFile;
/**
 * (no documentation provided)
 *
 *
 */
@property (nonatomic, copy) NSString *mobilePhone;
/**
 * (no documentation provided)
 *
 *
 */
@property (nonatomic, copy) NSString *officePhone;
/**
 * (no documentation provided)
 *
 *
 */
@property (nonatomic, copy) NSString *email;
/**
 * 方法: 取得java.util.Date
 *
 *
 */
@property (nonatomic, copy) NSString *createDate;
/**
 * 方法: 取得java.lang.String
 *
 *
 */
@property (nonatomic, copy) NSString *createBy;
/**
 * 方法: 取得java.lang.String
 *
 *
 */
@property (nonatomic, copy) NSString *createName;
/**
 * 方法: 取得java.util.Date
 *
 *
 */
@property (nonatomic, copy) NSString *updateDate;
/**
 * 方法: 取得java.lang.String
 *
 *
 */
@property (nonatomic, copy) NSString *updateBy;
/**
 * 方法: ���得java.lang.String
 *
 *
 */
@property (nonatomic, copy) NSString *updateName;
/**
 * (no documentation provided)
 *
 *
 */
@property (nonatomic, copy) NSString *position;
/**
 * 备注
 *
 *
 */
@property (nonatomic, copy) NSString *note;
@end /* interface TSUser */



/**
 *  经销商员工。
 
 @author Debenson
 @since 0.1
 
 */
@interface TOEmployee : TSUser
/**
 * 职位编码列表， (多个职位编码用逗号分隔，非必填)
 *
 *
 */
@property (nonatomic, copy) NSString *positions;
/**
 * 个人头像
 *
 *
 */
@property (nonatomic, copy) NSString *picture;
/**
 * (no documentation provided)
 * 
 * 
 */
@property (nonatomic, copy) NSString *positionsName;
@end /* interface TOEmployee */


