//
//  ShoppingBagViewController.m
//  Lighting
//
//  Created by 曹云霄 on 16/6/6.
//  Copyright © 2016年 上海勾芒科技有限公司. All rights reserved.
//

#import "ShoppingBagViewController.h"
#import "ShoppingTableViewCell.h"
#import "TOGoodsEntityModel.h"
#import "ShopcarModel.h"
@interface ShoppingBagViewController ()<UITableViewDelegate,UITableViewDataSource,UIGestureRecognizerDelegate,DZNEmptyDataSetSource,ChangeGoodsNumberDelegate,UIImagePickerControllerDelegate>

@end

@implementation ShoppingBagViewController

- (void)viewDidLoad {
    [super viewDidLoad];
    
    [self uiConfigAction];
    [self setDelegateandDataSource];
}

#pragma mark -UI
- (void)uiConfigAction
{
    self.view.backgroundColor = [UIColor clearColor];
    UITapGestureRecognizer *tap = [[UITapGestureRecognizer alloc]initWithTarget:self action:@selector(dismissAction:)];
    tap.delegate = self;
    [self.view addGestureRecognizer:tap];
    self.sureButton.layer.masksToBounds = YES;
    self.sureButton.layer.cornerRadius = kCornerRadius;
}

#pragma mark -数据源
- (void)setDatasArray:(NSMutableArray *)datasArray
{
    NSMutableArray *array = [NSMutableArray array];
    for (TOGoodsEntityModel *model in datasArray) {
        ShopcarModel *shopModel = [[ShopcarModel alloc]init];
        VOResellerGoodsEntity *newModel = [[VOResellerGoodsEntity alloc]init];
        newModel.categoryName = model.categoryName;
        newModel.brandName = model.brandName;
        newModel.fid = model.fid;
        newModel.createDate = model.createDate;
        newModel.onlineTime = model.onlineTime;
        newModel.company = model.company;
        newModel.code = model.code;
        newModel.name = model.name;
        newModel.number = model.number;
        newModel.categoryId = model.categoryId;
        newModel.brandId = model.brandId;
        newModel.keyword = model.keyword;
        newModel.guidePrice = model.guidePrice;
        newModel.tagPrice = model.tagPrice;
        newModel.costPrice = model.costPrice;
        newModel.state = model.state;
        newModel.inv = model.inv;
        newModel.detailedIntro = model.detailedIntro;
        newModel.weight = model.weight;
        newModel.unit = model.unit;
        newModel.productProfile = model.productProfile;
        newModel.power = model.power;
        newModel.colorTemperature = model.colorTemperature;
        newModel.spec = model.spec;
        newModel.function = model.function;
        newModel.material = model.material;
        newModel.lightSource = model.lightSource;
        newModel.goodsStyle = model.goodsStyle;
        newModel.series = model.series;
        newModel.area = model.area;
        newModel.size = model.size;
        newModel.space = model.space;
        newModel.installMethod = model.installMethod;
        newModel.lightNumber = model.lightNumber;
        newModel.pictures = model.pictures;
        newModel.barcode = model.barcode;
        shopModel.goods = newModel;
        shopModel.costPrice = model.costPrice;
        shopModel.goodsNum = model.goodsNumber;
        [array addObject:shopModel];
    }
    _datasArray = [NSMutableArray arrayWithArray:array];
    [self.shoppingBagTableView reloadData];
}

#pragma mark -tableview
- (void)setDelegateandDataSource
{
    self.shoppingBagTableView.delegate = self;
    self.shoppingBagTableView.dataSource = self;
    self.shoppingBagTableView.emptyDataSetSource = self;
    self.shoppingBagTableView.tableFooterView = [UIView new];
}

- (UITableViewCell *)tableView:(UITableView *)tableView cellForRowAtIndexPath:(NSIndexPath *)indexPath
{
    ShoppingTableViewCell *cell = [tableView dequeueReusableCellWithIdentifier:@"Shopping" forIndexPath:indexPath];
    cell.selectionStyle = UITableViewCellSelectionStyleNone;
    cell.model = [self.datasArray objectAtIndex_opple:indexPath.row];
    cell.delegate = self;
    cell.cellindex = indexPath.row;
    cell.clinchTextfield.userInteractionEnabled = NO;
    cell.ClinchPriceBackView.backgroundColor = cell.backgroundColor;
    //cell选中回调
    WS(weakSelf);
    [cell setReturnCellblock:^(NSInteger index) {
        
        [weakSelf setSelectedButton:index];
    }];
    //提示框回调
    [cell setPromptStringBlock:^(NSString *string) {
        [weakSelf promptCustomerWithString:string];
    }];
    return cell;
}

- (NSInteger)tableView:(UITableView *)tableView numberOfRowsInSection:(NSInteger)section
{
    return self.datasArray.count;
}

- (CGFloat)tableView:(UITableView *)tableView heightForRowAtIndexPath:(NSIndexPath *)indexPath
{
    return 80;
}


#pragma mark -选中商品回调
- (void)setSelectedButton:(NSInteger)index;
{
    ShopcarModel *model = [self.datasArray objectAtIndex_opple:index];
    model.isSelected = !model.isSelected;
    
    NSInteger goodsNumber = 0;
    for (ShopcarModel *model in self.datasArray) {
        if (model.isSelected) {
            goodsNumber ++;
        }
    }
    if (goodsNumber == self.datasArray.count) {
        self.totalSelectedButton.selected = YES;
    }else
    {
        self.totalSelectedButton.selected = NO;
    }
    [self CalculateSelectedGoodsAllprice];
    [self.sureButton setTitle:[NSString stringWithFormat:@"确认添加(%ld)",goodsNumber] forState:UIControlStateNormal];
}

#pragma mark -计算选中后的商品总金额
- (void)CalculateSelectedGoodsAllprice
{
    CGFloat allPrice = 0;
    for (ShopcarModel *model in self.datasArray) {
        if (model.isSelected) {
            allPrice += ([model.costPrice floatValue]?[model.costPrice floatValue]:[model.goods.tagPrice floatValue]) * model.goodsNum;
        }
    }
    self.totalPriceLabe.text = [NSString stringWithFormat:@"￥%.2f",allPrice];
}


#pragma mark -全选
- (IBAction)totalButtonSelectedAction:(UIButton *)sender {
    
    sender.selected = !sender.selected;
    if (sender.selected) {
        
        //全部选中
        for (ShoppingTableViewCell *cell in self.shoppingBagTableView.visibleCells) {
            
            cell.selectedButton.selected = YES;
        }
        for (ShopcarModel *model in self.datasArray) {
            
            model.isSelected = YES;
        }
        [self.sureButton setTitle:[NSString stringWithFormat:@"确认添加(%ld)",self.datasArray.count] forState:UIControlStateNormal];
    }else
    {
        //取消全部选中
        for (ShoppingTableViewCell *cell in self.shoppingBagTableView.visibleCells) {
            
            cell.selectedButton.selected = NO;
        }
        for (ShopcarModel *model in self.datasArray) {
            
            model.isSelected = NO;
        }
        [self.sureButton setTitle:@"确认添加(0)" forState:UIControlStateNormal];
    }
    //计算总金额
    [self CalculateSelectedGoodsAllprice];
}

#pragma mark -删除
- (IBAction)delectedButtonSelectedAction:(UIButton *)sender {
    
    NSMutableArray *indexpathArray = [NSMutableArray array];
    NSMutableArray *delectedModelArray = [NSMutableArray array];
    for (int i=0; i < self.datasArray.count; i++) {
        ShopcarModel *model = [self.datasArray objectAtIndex_opple:i];
        if (model.isSelected) {
            NSIndexPath *indexPath = [NSIndexPath indexPathForRow:i inSection:0];
            [indexpathArray addObject:indexPath];
            [delectedModelArray addObject:model];
        }
    }
    if (!indexpathArray.count) {
        [self ErrorMBProgressView:@"未选中任何商品"];
    }else
    {
        for (ShopcarModel *model in delectedModelArray) {
            [self.datasArray removeObject:model];
        }
        [self.sureButton setTitle:@"确认添加(0)" forState:UIControlStateNormal];
        self.totalSelectedButton.selected = NO;
        self.totalPriceLabe.text = nil;
       [self.shoppingBagTableView deleteRowsAtIndexPaths:indexpathArray withRowAnimation:UITableViewRowAnimationLeft];
        dispatch_after(dispatch_time(DISPATCH_TIME_NOW, (int64_t)(1 * NSEC_PER_SEC)), dispatch_get_main_queue(), ^{
            [self.shoppingBagTableView reloadData];
        });
    }
}

#pragma mark -添加至购物车
- (IBAction)addShoppingBagButtonClickAction:(UIButton *)sender {
    
    NSMutableArray *array = [NSMutableArray array];
    for (int i=0; i<self.datasArray.count; i++) {
        ShopcarModel *model = [self.datasArray objectAtIndex_opple:i];
        if (model.isSelected) {
            [array addObject:model];
        }
    }
    if (!array.count) {
        [self ErrorMBProgressView:@"请先勾选商品"];
        return;
    }
    
    [self CreateMBProgressHUDLoding];
    NSMutableString *goodsIds = [[NSMutableString alloc]init];
    NSMutableString *goodsCounts = [[NSMutableString alloc]init];
    for (ShopcarModel *model in self.datasArray) {
        if (model.isSelected) {
            [goodsIds appendFormat:@"%@,",model.goods.fid];
            [goodsCounts appendFormat:@"%ld,",(long)model.goodsNum];
        }
    }
    SaveShoppingCartRequest *shopCar = [[SaveShoppingCartRequest alloc]init];
    shopCar.consumerId = [Customermanager manager].model.fid;
    shopCar.goodsId = [goodsIds substringToIndex:goodsIds.length-1];
    shopCar.count = [goodsCounts substringToIndex:goodsCounts.length-1];
    WS(weakSelf);
    [[NetworkRequestClassManager Manager] NetworkRequestWithURL:SERVERREQUESTURL(ADDSHOPPINGBAG) WithCallClass:weakSelf WithRequestType:0 WithParameter:shopCar WithReturnValueBlock:^(id returnValue) {
        
        [weakSelf RemoveMBProgressHUDLoding];
        if ([returnValue[@"code"] isEqualToNumber:@0]) {
            if (weakSelf.dismissBlock) {
                weakSelf.dismissBlock();
            }
            [weakSelf dismissViewControllerAnimated:YES completion:nil];
            [weakSelf QueryShoppingCarNumber];
            [weakSelf SuccessMBProgressView:@"加入购物车成功"];
        }else
        {
            [weakSelf ErrorMBProgressView:returnValue[@"message"]];
        }
        
    } WithErrorCodeBlock:^(id errorCodeValue) {
        [weakSelf ErrorMBProgressView:NETWORK];
    } WithFailureBlock:^(NSError *error) {
        [weakSelf ErrorMBProgressView:error.localizedDescription];
    }];
}


#pragma mark -系统提示框
- (void)promptCustomerWithString:(NSString *)message
{
    UIAlertController *alertVC = [UIAlertController alertControllerWithTitle:@"提示" message:message preferredStyle:UIAlertControllerStyleAlert];
    [alertVC addAction:[UIAlertAction actionWithTitle:@"我知道了" style:UIAlertActionStyleDefault handler:^(UIAlertAction * _Nonnull action) {
        [alertVC dismissViewControllerAnimated:YES completion:nil];
    }]];
    [self presentViewController:alertVC animated:YES completion:nil];
}

#pragma mark -修改单个商品数量、价格
- (void)changeGoodsNumber:(NSInteger)goodsNumber WithcostPrice:(CGFloat)costprice Withcellindex:(NSInteger)cellindex returnValue:(void (^)(id))result
{
    [self CreateMBProgressHUDLoding];
    //保存商品数量
    ShopcarModel *model = [self.datasArray objectAtIndex_opple:cellindex];
    model.goodsNum = goodsNumber;
    //保存成交价格
    model.costPrice = [NSNumber numberWithFloat:costprice];
    //在服务器保存数量、成交价
    //购物车ID
    NSString *carid = model.fid;
    //商品id
    NSString *goodsis = model.goodsId;
    //成交价
    NSString *costpriceString = [NSString stringWithFormat:@"%.2f",costprice];
    //商品数量
    NSString *goodsNumberString = [NSString stringWithFormat:@"%ld",(long)goodsNumber];
    WS(weakSelf);
    [[NetworkRequestClassManager Manager] NetworkWithDictionaryRequestWithURL:[NSString stringWithFormat:@"%@%@/%@/%@/%@",SERVERREQUESTURL(CHANGESHOPPINGBAGNUMBERPRICE),carid,goodsis,costpriceString,goodsNumberString] WithCallClass:weakSelf WithRequestType:1 WithParameter:nil WithReturnValueBlock:^(id returnValue) {
        
        [weakSelf RemoveMBProgressHUDLoding];
        result(returnValue);//提供是否支持修改的参数
        if ([returnValue[@"code"] isEqualToNumber:@0]) {
            [weakSelf CalculateSelectedGoodsAllprice];
            [weakSelf QueryShoppingCarNumber];
        }else{
            
            [weakSelf ErrorMBProgressView:returnValue[@"message"]];
        }
        
    } WithErrorCodeBlock:^(id errorCodeValue) {
        [weakSelf ErrorMBProgressView:NETWORK];
    } WithFailureBlock:^(NSError *error) {
        [weakSelf ErrorMBProgressView:error.localizedDescription];
    }];
}

#pragma mark -销毁
- (void)dismissAction:(UITapGestureRecognizer *)tap
{
    if (self.dismissBlock) {
        self.dismissBlock();
    }
    [self dismissViewControllerAnimated:YES completion:nil];
}

#pragma mark -UIGestureRecognizerDelegate代理
- (BOOL)gestureRecognizer:(UIGestureRecognizer *)gestureRecognizer shouldReceiveTouch:(UITouch *)touch
{
    //取消子视图的的时间穿透，否则子视图的点击无效，会被传递到父视图响应
    if (CGRectContainsPoint(self.shoppingBagBackView.frame, [touch locationInView:self.view.window])) {
        
        return NO;
    }
    return YES;
}

#pragma mark -友好界面
- (UIImage *)imageForEmptyDataSet:(UIScrollView *)scrollView
{
    return kNoDataImage;
}

- (NSAttributedString *)titleForEmptyDataSet:(UIScrollView *)scrollView
{
    return [[NSAttributedString alloc]initWithString:@"暂无数据" attributes:nil];
}


- (void)didReceiveMemoryWarning {
    [super didReceiveMemoryWarning];
    // Dispose of any resources that can be recreated.
}

/*
#pragma mark - Navigation

// In a storyboard-based application, you will often want to do a little preparation before navigation
- (void)prepareForSegue:(UIStoryboardSegue *)segue sender:(id)sender {
    // Get the new view controller using [segue destinationViewController].
    // Pass the selected object to the new view controller.
}
*/

@end
