//
//  BaseViewController.m
//  Lighting
//
//  Created by 曹云霄 on 16/4/27.
//  Copyright © 2016年 上海勾芒科技有限公司. All rights reserved.
//

#import "BaseViewController.h"
#import "LoginViewController.h"
#import <WebKit/WebKit.h>
#import <AVFoundation/AVFoundation.h>

@interface BaseViewController ()<UIPrintInteractionControllerDelegate,UIWebViewDelegate,WKNavigationDelegate>


@property (nonatomic,strong) WKWebView *webView;

/**
 *  提示框
 */
@property (nonatomic,strong) PromptinformationView *promptView;

@property (nonatomic,strong) UIPrintInteractionController *printControl;


@end

@implementation BaseViewController


/**
 *  创建MBProgressHUD对象
 *
 *  @return MBProgressHUD
 */
- (MBProgressHUD *)TCHud
{
    if (_TCHud == nil) {
        
        _TCHud = [MBProgressHUD showHUDAddedTo:SHARED_APPDELEGATE.window animated:YES];
    }
    return _TCHud;
}


/**
 *  初始化提示框
 *
 *  @return PromptinformationView
 */
- (PromptinformationView *)promptView
{
    if (_promptView == nil) {
        
        _promptView = [[[NSBundle mainBundle] loadNibNamed:@"PromptinformationView" owner:self options:nil] firstObject];
    }
    return _promptView;
}


- (WKWebView *)webView
{
    if (_webView == nil) {
        
        _webView = [[WKWebView alloc]initWithFrame:CGRectMake(0, 0, ScreenWidth, ScreenHeight)];
    }
    return _webView;
}



- (void)viewDidLoad {
    [super viewDidLoad];
    // Do any additional setup after loading the view.
    self.automaticallyAdjustsScrollViewInsets = NO;
    //检测登陆超时通知
    [[NSNotificationCenter defaultCenter] addObserver:self selector:@selector(logintimeoutNotification:) name:LOGINTIMEOUT object:nil];
}


#pragma mark -登陆超时回调
- (void)logintimeoutNotification:(NSNotification *)not
{
    WS(weakSelf);
    UIAlertController *alert = [UIAlertController alertControllerWithTitle:@"提示" message:@"登陆超时，请重新登陆" preferredStyle:UIAlertControllerStyleAlert];
    [alert addAction:[UIAlertAction actionWithTitle:@"我知道了" style:UIAlertActionStyleDestructive handler:^(UIAlertAction * _Nonnull action) {
        [weakSelf dismissViewControllerAnimated:YES completion:nil];
        [Shoppersmanager manager].currentCustomer = NO;
        [Customermanager manager].model = nil;
        UIStoryboard *storyboard = [UIStoryboard storyboardWithName:@"OppleMain" bundle:nil];
        LoginViewController *loginVC = [storyboard instantiateViewControllerWithIdentifier:@"Login"];
        [[NSUserDefaults standardUserDefaults] removeObjectForKey:USERNAME];
        [[NSUserDefaults standardUserDefaults] removeObjectForKey:PASSWORD];
        [weakSelf restoreRootViewController:loginVC];
    }]];
    dispatch_async(dispatch_get_main_queue(), ^{
        [weakSelf presentViewController:alert animated:YES completion:nil];
    });
}


#pragma mark -切换rootViewcontroller
- (void)restoreRootViewController:(UIViewController *)rootViewController
{
    typedef void (^Animation)(void);
    UIWindow* window = SHARED_APPDELEGATE.window;
    rootViewController.modalTransitionStyle = UIModalTransitionStyleCrossDissolve;
    Animation animation = ^{
        BOOL oldState = [UIView areAnimationsEnabled];
        [UIView setAnimationsEnabled:NO];
        window.rootViewController = rootViewController;
        [UIView setAnimationsEnabled:oldState];
    };
    
    [UIView transitionWithView:window
                      duration:0.5f
                       options:UIViewAnimationOptionTransitionFlipFromBottom
                    animations:animation
                    completion:nil];
}



#pragma mark -渐隐提示框回调
- (void)SHOWPrompttext:(NSString *)Text ComcpleteBlock:(void(^)())completed
{
    MBProgressHUD *hud = [MBProgressHUD showHUDAddedTo:self.view.window animated:YES];
    hud.labelText = Text;
    hud.animationType = MBProgressHUDAnimationZoom;
    hud.mode = MBProgressHUDModeText;
    hud.color = [[UIColor blackColor] colorWithAlphaComponent:0.6];
    hud.removeFromSuperViewOnHide = YES;
    [hud hide:YES afterDelay:2.0f];
    dispatch_after(dispatch_time(DISPATCH_TIME_NOW, (int64_t)(2 * NSEC_PER_SEC)), dispatch_get_main_queue(), ^{
        if (completed) {
            completed();
        }
    });
}

#pragma mark -显示MBProgressHUD等待视图
- (void)CreateMBProgressHUDLoding
{
    self.TCHud.animationType = MBProgressHUDAnimationZoom;
    self.TCHud.mode = MBProgressHUDModeIndeterminate;
    self.TCHud.color = [UIColor clearColor];
    self.TCHud.activityIndicatorColor = kMainBlueColor;
    self.TCHud.removeFromSuperViewOnHide = YES;
}



#pragma mark -进度条
- (void)ShowProgressView:(double)progress
{
    dispatch_async(dispatch_get_main_queue(), ^{
        self.TCHud.mode = MBProgressHUDModeDeterminate;
        self.TCHud.labelText = @"上传中....";
        self.TCHud.labelFont = [UIFont systemFontOfSize:12];
        self.TCHud.progress = progress;
        self.TCHud.removeFromSuperViewOnHide = YES;
    });
}

#pragma mark -移除MBProgressHUD等待视图
- (void)RemoveMBProgressHUDLoding;
{
    dispatch_async(dispatch_get_main_queue(), ^{
        if (_TCHud) {
            [_TCHud hide:YES];
            _TCHud = nil;
        }
    });
}


#pragma mark -显示成功的提示框
- (void)SuccessMBProgressView:(NSString *)successString
{
    MBProgressHUD *hud = [MBProgressHUD showHUDAddedTo:SHARED_APPDELEGATE.window animated:YES];
    hud.mode = MBProgressHUDModeCustomView;
    UIImage *image = [[UIImage imageNamed:@"Checkmark"] imageWithRenderingMode:UIImageRenderingModeAlwaysOriginal];
    hud.customView = [[UIImageView alloc] initWithImage:image];
    hud.color = [[UIColor blackColor] colorWithAlphaComponent:0.6];
    hud.labelFont = [UIFont systemFontOfSize:15];
    hud.labelText = successString;
    [hud hide:YES afterDelay:3];
}

#pragma mark -显示信息的提示框
- (void)ErrorMBProgressView:(NSString *)errorString
{
    [self RemoveMBProgressHUDLoding];
    MBProgressHUD *hud = [MBProgressHUD showHUDAddedTo:SHARED_APPDELEGATE.window animated:YES];
    hud.labelText = errorString;
    hud.margin = 10.f;
    hud.color = [[UIColor blackColor] colorWithAlphaComponent:0.5];
    hud.minSize = CGSizeMake(250, 70);
    hud.animationType = MBProgressHUDAnimationZoom;
    hud.mode = MBProgressHUDModeText;
    hud.removeFromSuperViewOnHide = YES;
    [hud hide:YES afterDelay:3.0f];
}

#pragma mark - 获取当前时间之前或者之后的时间（之前传入负数）
+ (NSString *)getTimeby:(NSInteger)day
{
    NSDate*nowDate = [NSDate date];
    NSDate* theDate;
    if(day!=0){
        NSTimeInterval  oneDay = 24*60*60*1;  //1天的长度
        theDate = [nowDate initWithTimeIntervalSinceNow: oneDay*day];
    }else{
        theDate = nowDate;
    }
    NSDateFormatter *date_formatter = [[NSDateFormatter alloc] init];
    [date_formatter setDateFormat:@"yyyy-MM-dd 00:00:00"];
    NSString *the_date_str = [date_formatter stringFromDate:theDate];
    return the_date_str;
}



#pragma mark -渐隐提示框
- (void)SHOWPrompttext:(NSString *)Text
{
    MBProgressHUD *hud = [MBProgressHUD showHUDAddedTo:SHARED_APPDELEGATE.window animated:YES];
    hud.labelText = Text;
    hud.margin = 10.f;
    hud.color = [[UIColor blackColor] colorWithAlphaComponent:0.5];
    hud.minSize = CGSizeMake(200, 50);
    hud.animationType = MBProgressHUDAnimationZoom;
    hud.mode = MBProgressHUDModeText;
    hud.removeFromSuperViewOnHide = YES;
    [hud hide:YES afterDelay:3.0f];
}


#pragma mark -结束MJRfresh刷新
- (void)endRefreshingForTableView:(UIScrollView *)TableView
{
    if (TableView.mj_header.isRefreshing) {
        
        [TableView.mj_header endRefreshing];
    }
    else if (TableView.mj_footer.isRefreshing)
    {
        [TableView.mj_footer endRefreshing];
    }
}

#pragma mark -获得我的storyboard对象
+ (UIStoryboard *)getMainStoryboardClass
{
    UIStoryboard *storyboard = [UIStoryboard storyboardWithName:@"OppleMain" bundle:nil];
    return storyboard;
}

#pragma mark - 获得公告storyboard对象
+ (UIStoryboard *)getAnnouncementStoryboardClass
{
    UIStoryboard *storyboard = [UIStoryboard storyboardWithName:@"Announcement" bundle:nil];
    return storyboard;
}

#pragma mark - 获得学习中心storyboard对象
+ (UIStoryboard *)getLearningCenterStoryboardClass
{
    UIStoryboard *storyboard = [UIStoryboard storyboardWithName:@"LearningCenter" bundle:nil];
    return storyboard;
}

#pragma mark -获得积分storyboard对象
+ (UIStoryboard *)getGuideIntegralStoryboardClass
{
    UIStoryboard *storyboard = [UIStoryboard storyboardWithName:@"GuideIntegral" bundle:nil];
    return storyboard;
}

#pragma mark - 判断相机权限
+ (BOOL)determineCameraPermissions
{
    NSString *mediaType = AVMediaTypeVideo;//读取媒体类型
    AVAuthorizationStatus authStatus = [AVCaptureDevice authorizationStatusForMediaType:mediaType];//读取设备授权状态
    if(authStatus == AVAuthorizationStatusRestricted || authStatus == AVAuthorizationStatusDenied){
        return NO;
    }else {
        return YES;
    }
}

#pragma mark 调用airPrint无线打印机
- (void)callAirprintWithdata:(NSString *)PDFpath SuccessBlock:(void(^)())success ErrorBlock:(void(^)())failed
{
    NSData *mypdfdata = [NSData dataWithContentsOfFile:PDFpath];
    UIPrintInteractionController *pic = [UIPrintInteractionController sharedPrintController];
    if  (pic && [UIPrintInteractionController canPrintData: mypdfdata] ) {
        pic.delegate = self;
        UIPrintInfo *printInfo = [UIPrintInfo printInfo];
        printInfo.outputType = UIPrintInfoOutputGeneral;
        printInfo.jobName = @"订单明细";
        printInfo.duplex = UIPrintInfoDuplexLongEdge;
        pic.printInfo = printInfo;
        pic.showsPageRange = YES;
        pic.printingItem = mypdfdata;
        void (^completionHandler)(UIPrintInteractionController *, BOOL, NSError *) = ^(UIPrintInteractionController *pic, BOOL completed, NSError *error) {
            if (completed)
            {
                // 执行成功后的处理
                success();
            }
            else if (!completed && error)
            {
                // 执行失败后的处理
                failed();
            }
        };
        if ([[UIDevice currentDevice] userInterfaceIdiom] == UIUserInterfaceIdiomPad) {
            [pic presentAnimated:YES completionHandler:completionHandler];
        }
    }
}


#pragma mark -提示文本,图片
- (void)PromptinformationViewWithimage:(UIImage *)image withTitle:(NSString *)title withpoint:(CGPoint)point
{
    self.promptView.tipsImage.image = image;
    self.promptView.tipsTitle.text = title;
    self.promptView.frame = CGRectMake(point.x, point.y, 250, 170);
    [self.view addSubview:self.promptView];
}

#pragma mark - 提示框
- (void)promptCustomerTitle:(NSString *)title withMessage:(NSString *)message finish:(void (^)())complete
{
    UIAlertController *alertVC = [UIAlertController alertControllerWithTitle:nil message:message preferredStyle:UIAlertControllerStyleAlert];
    [alertVC addAction:[UIAlertAction actionWithTitle:title style:UIAlertActionStyleDefault handler:^(UIAlertAction * _Nonnull action) {
        if (complete) {
            complete();
        }
    }]];
    [self presentViewController:alertVC animated:YES completion:nil];
}

#pragma mark -删除提示文本、图片
- (void)RemovePromptinformationView
{
    [self.promptView removeFromSuperview];
    self.promptView = nil;
}

#pragma mark -传入订单状态，返回当前状态图片
+ (UIImage *)ReturnOrderStateImageWithStateCode:(NSInteger)ordercode
{
    const NSArray *imageArray = [NSArray arrayWithObjects:@"已撤销",@"已完成",@"已退货", nil];
    switch (ordercode) {
        case 4://退货
        {
            return TCImage([imageArray objectAtIndex_opple:2]);
        }
            break;
        case 5://作废
        {
            return TCImage([imageArray objectAtIndex_opple:0]);
        }
            break;
        case 6://完成
        {
            return TCImage([imageArray objectAtIndex_opple:1]);
        }
            break;
            
        default:
            break;
    }
    return nil;
}


#pragma mark -传入订单状态，返回订单文本信息,字体颜色
+ (id)ReturnOrderStateTitleWithStateCode:(NSInteger)ordercode withPoint:(CGPoint)point WithCode:(NSInteger)code
{
    
    switch (ordercode) {
        case 001://未付款
        {
            if (code) {
                return kTCColor(241, 81, 83);
            }
            return @"待支付";
        }
            break;
        case 002://已付款
        {
            
            if (code) {
                return kTCColor(126, 191, 53);
            }
            return @"已支付";
        }
            break;
        case 003://已发货
        {
            
            if (code) {
                return kTCColor(240, 180, 51);
            }
            return @"已发货";
        }
            break;
        case 004://已退货
        {
            
            if (code) {
                return kTCColor(153, 153, 153);
            }
            return @"已退货";
        }
            break;
        case 005://已作废
        {
            
            if (code) {
                return kTCColor(153, 153, 153);
            }
            return @"已撤销";
        }
            break;
        case 006://已完成
        {
            
            if (code) {
                return kTCColor(89, 172, 220);
            }
            return @"已完成";
        }
            break;
            
        default:
            break;
    }
    return nil;
}


#pragma mark - <##>查询兑奖单state对应文字
+ (id)returnPrizeBillStateTitleColor:(NSString *)stateCode
{
    NSDictionary *dict;
    if ([stateCode isEqualToString:@"requested"]) {
        dict = @{@"title":@"已申请",@"color":RGB(127, 192, 62, 1)};
    }else if ([stateCode isEqualToString:@"requested"]) {
        dict = @{@"title":@"已发货",@"color":RGB(245, 185, 74, 1)};
    }
    return dict;
}

#pragma mark -查询购物车数量
- (void)QueryShoppingCarNumber
{
    WS(weakSelf);
    [[NetworkRequestClassManager Manager] NetworkWithDictionaryRequestWithURL:[NSString stringWithFormat:@"%@%@",SERVERREQUESTURL(QUERYSHOPPINGBAGNUMBER),[Customermanager manager].model.fid] WithCallClass:weakSelf WithRequestType:1 WithParameter:nil WithReturnValueBlock:^(id returnValue) {
        
        if ([returnValue[@"code"] isEqualToNumber:@0]) {
            NSLog(@"更新购物车数量成功");
            [[NSNotificationCenter defaultCenter]postNotificationName:ADDSHOPPINGCAR object:returnValue[@"data"]];
        }
    } WithErrorCodeBlock:^(id errorCodeValue) {
        [weakSelf ErrorMBProgressView:NETWORK];
    } WithFailureBlock:^(NSError *error) {
        [weakSelf ErrorMBProgressView:error.localizedDescription];
    }];
}

#pragma mark - 查询购物车商品
- (void)queryShoppingCarGoods
{
    [[NSNotificationCenter defaultCenter] postNotificationName:SHOPPINGCARGOODS object:nil];
}

#pragma mark -系统提示框
- (void)promptCustomerWithString:(NSString *)message
{
    UIAlertController *alertVC = [UIAlertController alertControllerWithTitle:@"提示" message:message preferredStyle:UIAlertControllerStyleAlert];
    [alertVC addAction:[UIAlertAction actionWithTitle:@"我知道了" style:UIAlertActionStyleDefault handler:^(UIAlertAction * _Nonnull action) {
        
        [self dismissViewControllerAnimated:YES completion:nil];
    }]];
    dispatch_async(dispatch_get_main_queue(), ^{
        [self presentViewController:alertVC animated:YES completion:nil];
    });
}

#pragma mark -友好化时间
+ (NSString *) compareCurrentTime:(NSString *)str
{
    
    //把字符串转为NSdate
    NSDateFormatter *dateFormatter = [[NSDateFormatter alloc] init];
    [dateFormatter setDateFormat:@"yyyy-MM-dd HH:mm:ss.SSS"];
    NSDate *timeDate = [dateFormatter dateFromString:str];
    
    //得到与当前时间差
    NSTimeInterval  timeInterval = [timeDate timeIntervalSinceNow];
    timeInterval = -timeInterval;
    //标准时间和北京时间差8个小时
    timeInterval = timeInterval - 8*60*60;
    long temp = 0;
    NSString *result;
    if (timeInterval < 60) {
        result = [NSString stringWithFormat:@"刚刚"];
    }
    else if((temp = timeInterval/60) <60){
        result = [NSString stringWithFormat:@"%ld分钟前",temp];
    }
    
    else if((temp = temp/60) <24){
        result = [NSString stringWithFormat:@"%ld小时前",temp];
    }
    
    else if((temp = temp/24) <30){
        result = [NSString stringWithFormat:@"%ld天前",temp];
    }
    
    else if((temp = temp/30) <12){
        result = [NSString stringWithFormat:@"%ld月前",temp];
    }
    else{
        temp = temp/12;
        result = [NSString stringWithFormat:@"%ld年前",temp];
    }
    
    return  result;
}

#pragma mark - 获取版本号
- (NSString*)getAppVersion
{
    NSString *ver = [[[NSBundle mainBundle] infoDictionary]
                     objectForKey:@"CFBundleShortVersionString"];
    return [NSString stringWithFormat:@"Version %@",ver];
}

#pragma mark - 通过面额获取相应的图片
+ (UIImage *)getCorrespondingPictures:(NSInteger)total
{
    UIImage *image = nil;
    switch (total) {
        case 50:
        {
            image = TCImage(@"fifty");
        }
            break;
        case 100:
        {
            image = TCImage(@"onehundred");
        }
            break;
        case 200:
        {
            image = TCImage(@"twohundred");
        }
            break;
            
        default:
            break;
    }
    return image;
}

+ (BOOL)isBlankString:(NSString *)string
{
    if (string == nil || string == NULL) {
        return YES;
    }
    if ([string isKindOfClass:[NSNull class]]) {
        return YES;
    }
    if ([[string stringByTrimmingCharactersInSet:[NSCharacterSet whitespaceCharacterSet]] length]==0) {
        return YES;
    }
    return NO;
}

/**
 选择框
 
 @param message 文本
 @param cancel  取消
 @param sure    确认
 */
- (void)promptBoxWithMessage:(NSString *)message cancelBlock:(void(^)())cancel sureBlock:(void(^)())sure
{
    UIAlertController *alertVC = [UIAlertController alertControllerWithTitle:@"提示" message:message preferredStyle:UIAlertControllerStyleAlert];
    [alertVC addAction:[UIAlertAction actionWithTitle:@"取消" style:UIAlertActionStyleCancel handler:^(UIAlertAction * _Nonnull action) {
        if (cancel) {
            cancel();
        }
    }]];
    [alertVC addAction:[UIAlertAction actionWithTitle:@"确认" style:UIAlertActionStyleDestructive handler:^(UIAlertAction * _Nonnull action) {
        if (sure) {
            sure();
        }
    }]];
    [self presentViewController:alertVC animated:YES completion:nil];
}


- (void)dealloc
{
    NSLog(@"释放%@控制器",self);
}





@end
