//
//  screeningSecondView.h
//  Lighting
//
//  Created by 曹云霄 on 16/5/8.
//  Copyright © 2016年 上海勾芒科技有限公司. All rights reserved.
//

#import <UIKit/UIKit.h>
#import "ScreeningFirstCollectionViewCell.h"
#import "ScreeningSecondCollectionReusableView.h"

/**
 *  tableview模块的选中
 */
@protocol TableviewSelectedIndexdelegate <NSObject>


//UITableview
- (void)tableSelectedindex:(NSInteger)index;


//UICollectionView选中后返回所有被选中的类型
- (void)collectionSelectedindexWithStyleCode:(NSString *)styleCode withCategories:(NSString *)categoriesCode withSpace:(NSString *)spaceCode withMaterial:(NSString *)materialCode withPrice:(NSString *)priceTitle;

//显示筛选结果
- (void)ShowScreeningResponse;

@end






@interface screeningSecondView : UIView<UITableViewDelegate,UITableViewDataSource,UICollectionViewDelegate,UICollectionViewDataSource,ButtonClickActiondelegate>





/**
 *  筛选tableview
 */
@property (weak, nonatomic) IBOutlet UITableView *screeningTableview;


/**
 *  筛选collectionView
 */
@property (weak, nonatomic) IBOutlet UICollectionView *screeningCollectionView;


/**
 *  筛选layout
 */
@property (weak, nonatomic) IBOutlet UICollectionViewFlowLayout *screeningLayout;

/**
 *  筛选数据源
 */
@property (nonatomic,strong) NSArray *datasArray;


/**
 *  筛选结果显示
 */
@property (weak, nonatomic) IBOutlet UIButton *screeningResultButton;



/**
 *  tableview选中代理
 */
@property (nonatomic,assign) id<TableviewSelectedIndexdelegate>delegate;


/**
 *  筛选按钮选中的index
 */
@property (nonatomic) NSInteger selectedIndex;



/**
 *  通过复选搜索到的总条数
 */
@property (nonatomic,assign) NSInteger totalNumber;


/**
 *  默认数据源
 */
@property (nonatomic,strong) NSMutableArray *defaultDatasArray;

@end
