//
//  WithdrawalViewController.m
//  Lighting
//
//  Created by 曹云霄 on 16/8/26.
//  Copyright © 2016年 上海勾芒科技有限公司. All rights reserved.
//

#import "WithdrawalViewController.h"
#import "WithdrawalTableViewCell.h"
#import "WithdrawalTableViewController.h"

@interface WithdrawalViewController ()<UITableViewDelegate,UITableViewDataSource,DZNEmptyDataSetDelegate,DZNEmptyDataSetSource>

@property (weak, nonatomic) IBOutlet UITableView *withdrawalTableView;

/**
 *  上传参数
 */
@property (nonatomic,strong) RsApplyBillRequest *model;

/**
 *  数据源
 */
@property (nonatomic,strong) NSMutableArray *resultArray;

/**
 *  总页数
 */
@property (nonatomic,assign) NSInteger totalPage;

@end

@implementation WithdrawalViewController

#pragma mark - lazy
- (RsApplyBillRequest *)model
{
    if (!_model) {
        _model = [[RsApplyBillRequest alloc]init];
        DataPage *page = [[DataPage alloc]init];
        page.page = ONE;
        page.rows = KROWS;
        _model.page = page;
        _model.employeeId = [Shoppersmanager manager].Shoppers.employee.fid;
    }
    return _model;
}

- (NSMutableArray *)resultArray
{
    if (!_resultArray) {
        _resultArray = [NSMutableArray array];
    }
    return _resultArray;
}

- (void)viewDidLoad {
    [super viewDidLoad];
    
    self.withdrawalTableView.tableFooterView = [UIView new];
    [self setupRefreshing];
}

- (void)viewDidAppear:(BOOL)animated
{
    [super viewDidAppear:animated];
    [self.withdrawalTableView.mj_header beginRefreshing];
}

#pragma mark - 设置刷新
- (void)setupRefreshing
{
    WS(weakSelf);
    MjRefreshHeaderCustom *headerRefresh = [MjRefreshHeaderCustom headerWithRefreshingBlock:^{
        weakSelf.model.page.page = ONE;
        [weakSelf.withdrawalTableView.mj_footer resetNoMoreData];
        [weakSelf getDatasAction:YES];
    }];
    headerRefresh.stateLabel.hidden = YES;
    headerRefresh.lastUpdatedTimeLabel.hidden = YES;
    self.withdrawalTableView.mj_header = headerRefresh;
    
    MJRefreshAutoNormalFooter *footer = [MJRefreshAutoNormalFooter footerWithRefreshingBlock:^{
        if (++ weakSelf.model.page.page >= weakSelf.totalPage) {
            [weakSelf.withdrawalTableView.mj_footer endRefreshingWithNoMoreData];
        }else
        {
            [weakSelf getDatasAction:NO];
        }
    }];
    footer.automaticallyHidden = YES;
    self.withdrawalTableView.mj_footer = footer;
}

#pragma mark - 获取提现进度
- (void)getDatasAction:(BOOL)isRemoveAll
{
    WS(weakSelf);
    [self CreateMBProgressHUDLoding];
    [[NetworkRequestClassManager Manager] NetworkRequestWithURL:SERVERREQUESTURL(WITHDRAWALPROGRESS) WithCallClass:weakSelf WithRequestType:0 WithParameter:self.model WithReturnValueBlock:^(id returnValue) {
        
        weakSelf.withdrawalTableView.emptyDataSetSource = self;
        weakSelf.withdrawalTableView.emptyDataSetDelegate = self;
        [weakSelf endRefreshingForTableView:weakSelf.withdrawalTableView];
        [weakSelf RemoveMBProgressHUDLoding];
        if ([returnValue[@"code"] isEqualToNumber:@0]) {
            if (isRemoveAll) {
                [weakSelf.resultArray removeAllObjects];
            }
            RsApplyBillResponse *result = [[RsApplyBillResponse alloc]initWithDictionary:returnValue[@"data"] error:nil];
            weakSelf.totalPage = result.totalpages;
            for (TOApplyBillEntity *entity in result.list) {
                [weakSelf.resultArray addObject:entity];
            }
            [weakSelf.withdrawalTableView reloadData];
        }else
        {
            [weakSelf SHOWPrompttext:returnValue[@"message"]];
        }
        
    } WithErrorCodeBlock:^(id errorCodeValue) {
        [weakSelf endRefreshingForTableView:weakSelf.withdrawalTableView];
        [weakSelf RemoveMBProgressHUDLoding];
        [weakSelf SHOWPrompttext:NETWORK];
    } WithFailureBlock:^(NSError *error) {
        [weakSelf endRefreshingForTableView:weakSelf.withdrawalTableView];
        [weakSelf RemoveMBProgressHUDLoding];
        [weakSelf SHOWPrompttext:error.localizedDescription];
    }];
}

#pragma mark - <UITableViewDataSource,UITableViewDelegate>
- (UITableViewCell *)tableView:(UITableView *)tableView cellForRowAtIndexPath:(NSIndexPath *)indexPath
{
    WithdrawalTableViewCell *cell = [tableView dequeueReusableCellWithIdentifier:@"WithdrawalTableViewCell" forIndexPath:indexPath];
    TOApplyBillEntity *entity = self.resultArray[indexPath.row];
    cell.amountLabel.text = [NSString stringWithFormat:@"%.2f",[entity.applyMoney floatValue]];
    cell.createTimeLabel.text = entity.createDate;
    cell.progressLabel.textColor = [self setupLabelColor:entity.billStates];
    cell.progressLabel.text = entity.billStates;
    return cell;
}

- (NSInteger)tableView:(UITableView *)tableView numberOfRowsInSection:(NSInteger)section
{
    return self.resultArray.count;
}

- (CGFloat)tableView:(UITableView *)tableView heightForRowAtIndexPath:(NSIndexPath *)indexPath
{
    return 70;
}

- (void)tableView:(UITableView *)tableView didSelectRowAtIndexPath:(NSIndexPath *)indexPath
{
    [tableView deselectRowAtIndexPath:indexPath animated:YES];
    WithdrawalTableViewController *paymentsDetailsVC = [[[self class] getMainStoryboardClass] instantiateViewControllerWithIdentifier:@"WithdrawalTableViewController"];
    paymentsDetailsVC.model = self.resultArray[indexPath.row];
    [self.navigationController pushViewController:paymentsDetailsVC animated:YES];
}

#pragma mark - 设置字体颜色
- (UIColor *)setupLabelColor:(NSString *)text
{
    if ([text isEqualToString:@"到账成功"]) {
        return RGB(89, 172, 220, 1);
    }
    if ([text isEqualToString:@"申请已提交"]) {
        return RGB(128, 189, 51, 1);
    }
    return nil;
}

#pragma mark - 释放
- (void)dealloc
{
    [[NSNotificationCenter defaultCenter]removeObserver:self];
}


#pragma mark -友好界面
- (UIImage *)imageForEmptyDataSet:(UIScrollView *)scrollView
{
    return kNoDataImage;
}

- (BOOL)emptyDataSetShouldAllowScroll:(UIScrollView *)scrollView
{
    return YES;
}

- (NSAttributedString *)titleForEmptyDataSet:(UIScrollView *)scrollView
{
    return [[NSAttributedString alloc]initWithString:@"暂无数据" attributes:nil];
}

- (CGFloat)verticalOffsetForEmptyDataSet:(UIScrollView *)scrollView
{
    return 64;
}



@end
