//
//  ShoppingViewController.m
//  Lighting
//
//  Created by 曹云霄 on 16/4/27.
//  Copyright © 2016年 上海勾芒科技有限公司. All rights reserved.
//

#import "ShoppingViewController.h"
#import "ShoppingTableViewCell.h"
#import "AppDelegate.h"
#import "GenerateOrdersViewController.h"
#import "ShopcarModel.h"
#import "AddressModel.h"
#import "ProductDetailsViewController.h"

@interface ShoppingViewController ()<UITableViewDelegate,UITableViewDataSource,ChangeGoodsNumberDelegate,DZNEmptyDataSetSource,UITextFieldDelegate>

@property (weak, nonatomic) IBOutlet UITableView *shoppingTableview;

/**
 *  购物车数据源
 */
@property (nonatomic,strong) NSMutableArray *shopResponseArray;

/**
 *  折扣比例输入
 */
@property (nonatomic,strong) UITextField *textField;


@end

@implementation ShoppingViewController


/**
 *  数据源
 */
- (NSMutableArray *)shopResponseArray
{
    if (_shopResponseArray == nil) {
        
        _shopResponseArray = [NSMutableArray array];
    }
    return _shopResponseArray;
}

- (void)viewDidLoad {
    [super viewDidLoad];
    
    [self uiConfigAction];
}

#pragma mark -渲染完成
- (void)viewDidAppear:(BOOL)animated
{
    [super viewDidAppear:animated];
    self.navigationController.fd_fullscreenPopGestureRecognizer.enabled = NO;
    if ([self.navigationController respondsToSelector:@selector(interactivePopGestureRecognizer)]) {
        self.navigationController.interactivePopGestureRecognizer.enabled = NO;
    }
    [self.shopResponseArray removeAllObjects];
    [self InitializeState];
    [self getShoppingCardata];
    [self QueryShoppingCarNumber];
}

#pragma mark -视图即将消失
- (void)viewWillDisappear:(BOOL)animated
{
    [super viewWillDisappear:animated];
    self.navigationController.fd_fullscreenPopGestureRecognizer.enabled = YES;
    if ([self.navigationController respondsToSelector:@selector(interactivePopGestureRecognizer)]) {
        self.navigationController.interactivePopGestureRecognizer.enabled = YES;
    }
}

#pragma mark -初始化状态
- (void)InitializeState
{
    [self.settlementButton setTitle:@"去结算(0)" forState:UIControlStateNormal];
    self.allSelectedButton.selected = NO;
    self.totalpriceLabe.text = nil;
    self.discountTextField.text = nil;
}

#pragma mark - UI
- (void)uiConfigAction
{
    self.settlementButton.layer.masksToBounds = YES;
    self.settlementButton.layer.cornerRadius = kCornerRadius;
    self.view.backgroundColor = kTCColor(238, 238, 238);
    self.shoppingTableview.dataSource = self;
    self.shoppingTableview.delegate = self;
    self.shoppingTableview.backgroundColor = [UIColor clearColor];
    self.shoppingTableview.tableFooterView = [UIView new];
    self.discountTextField.delegate = self;
}

#pragma mark -<UITextFieldDelegate>
- (BOOL)textFieldShouldBeginEditing:(UITextField *)textField
{
    if (![textField isEqual:self.discountTextField]) {
        return YES;
    }
    if (self.shopResponseArray.count == 0) {
        [self ErrorMBProgressView:@"请先添加商品到购物车"];return NO;
    }
    NSMutableArray *array = [NSMutableArray array];
    for (ShopcarModel *model in self.shopResponseArray) {
        if (model.isSelected) {
            [array addObject:model];
        }
    }
    if (array.count == 0) {
        [self ErrorMBProgressView:@"没有选中任何商品"];return NO;
    }
    [self inputDiscountNumber];
    return NO;
}

#pragma mark - 输入折扣金额
- (void)inputDiscountNumber
{
    WS(weakSelf);
    UIAlertController *alertControl = [UIAlertController alertControllerWithTitle:@"提示" message:@"请输入折扣比例(%)" preferredStyle:UIAlertControllerStyleAlert];
    [alertControl addAction:[UIAlertAction actionWithTitle:@"取消" style:UIAlertActionStyleCancel handler:^(UIAlertAction * _Nonnull action) {
        weakSelf.textField.text = nil;
         [weakSelf textFieldEndEditing];
    }]];
    [alertControl addTextFieldWithConfigurationHandler:^(UITextField * _Nonnull textField) {
        
        weakSelf.textField = textField;
        textField.placeholder = @"请输入";
        textField.keyboardType = UIKeyboardTypeNumberPad;
        textField.delegate = self;
    }];
    [alertControl addAction:[UIAlertAction actionWithTitle:@"确认" style:UIAlertActionStyleDestructive handler:^(UIAlertAction * _Nonnull action) {
        [weakSelf textFieldEndEditing];
    }]];
    [self presentViewController:alertControl animated:YES completion:nil];
}

#pragma mark - 结束编辑
- (void)textFieldEndEditing
{
    if ([BaseViewController isBlankString:self.textField.text]) {
        return;
    }
    Shoppersmanager *user = [Shoppersmanager manager];
    if ([self.textField.text integerValue] < [user.Shoppers.lowestDiscount integerValue] && ![[self class] isBlankString:self.textField.text])
    {
        [self SHOWPrompttext:@"当前价格低于你的价格权限!"];
        self.textField.text = nil;
    }else {
        self.discountTextField.text = self.textField.text;
        [self unifiedChangeDiscount:self.textField.text];
    }
}

#pragma mark - 输入折扣比例
- (BOOL)textField:(UITextField *)textField shouldChangeCharactersInRange:(NSRange)range replacementString:(NSString *)string
{
    return [self validateNumber:string];
}

#pragma mark - 判断输入是否有效<两位整数、第一位不能为0>
- (BOOL)validateNumber:(NSString*)number
{
    BOOL res = YES;
    if ([number isEqualToString:@""]) {
        return YES;
    }
    if (self.textField.text.length == 2) {
        return NO;
    }
    if([[self class] isBlankString:self.textField.text] && [number isEqualToString:@"0"])
    {
        if([number isEqualToString:@"0"]){
            return NO;
        }
    }
    NSCharacterSet* tmpSet = [NSCharacterSet characterSetWithCharactersInString:@"0123456789"];
    int i = 0;
    while (i < number.length) {
        NSString * string = [number substringWithRange:NSMakeRange(i, 1)];
        NSRange range = [string rangeOfCharacterFromSet:tmpSet];
        if (range.length == 0) {
            res = NO;
            break;
        }
        i++;
    }
    return res;
}

#pragma mark - 统一修改折扣率
- (void)unifiedChangeDiscount:(NSString *)discount
{
    WS(weakSelf);
    NSLog(@"----->%@",discount);
    NSDecimalNumber *discountNumber = [NSDecimalNumber decimalNumberWithString:discount];
    NSDecimalNumber *number = [discountNumber decimalNumberByDividingBy:[NSDecimalNumber decimalNumberWithString:@"100"]];
    for (ShopcarModel *model in self.shopResponseArray) {
        if (model.isSelected) {
            NSNumber *constPrice = model.goods.tagPrice;
            model.costPrice = [number decimalNumberByMultiplyingBy:[NSDecimalNumber decimalNumberWithString:[constPrice stringValue]]];
        }
    }
    //** boolValue为false表示修改失败 */
    [self modifyMultipleGoodsNnumberOrPrice:self.shopResponseArray completeModify:^(BOOL boolValue) {
        if (!boolValue) {
            for (ShopcarModel *model in weakSelf.shopResponseArray) {
                if (model.isSelected) {
                    model.costPrice = model.goods.tagPrice;
                    model.goodsNum = 1;
                }
            }
        }
        [weakSelf.shoppingTableview reloadData];
    }];
}

#pragma mark -获取购物车商品
- (void)getShoppingCardata
{
    //判断是否需要请求数据-通过当前客户ID
    if (![Shoppersmanager manager].currentCustomer) {
        return;
    }
    ShopCartFilter *shopcarNumber = [[ShopCartFilter alloc]init];
    shopcarNumber.consumerId = [Customermanager manager].model.fid;
    DataPage *Newpage = [[DataPage alloc]init];
    Newpage.page = 1;
    Newpage.rows = 99999;
    shopcarNumber.dp = Newpage;
    [self CreateMBProgressHUDLoding];
    WS(weakSelf);
    [[NetworkRequestClassManager Manager] NetworkRequestWithURL:SERVERREQUESTURL(SHOPPINGBAG) WithCallClass:weakSelf WithRequestType:0 WithParameter:shopcarNumber WithReturnValueBlock:^(id returnValue) {
        
        weakSelf.shoppingTableview.emptyDataSetSource = weakSelf;
        [weakSelf endRefreshingForTableView:weakSelf.shoppingTableview];
        [weakSelf RemoveMBProgressHUDLoding];
        if ([returnValue[@"code"] isEqualToNumber:@0]) {
  
            ShopCartResponse *shopcar = [[ShopCartResponse alloc]initWithDictionary:returnValue[@"data"] error:nil];
            //自定义属性
            for (TOShopcartEntity *objc in shopcar.shopcart) {
                
                ShopcarModel *model = [[ShopcarModel alloc]init];
                model.goods = objc.goods;
                model.fid = objc.fid;
                model.createName = objc.createName;
                model.createBy = objc.createBy;
                model.createDate = objc.createDate;
                model.updateName = objc.updateName;
                model.updateBy = objc.updateBy;
                model.updateDate = objc.updateDate;
                model.goodsId = objc.goodsId;
                model.goodsNum = objc.goodsNum;
                model.consumerId = objc.consumerId;
                model.costPrice = objc.costPrice;
                [weakSelf.shopResponseArray addObject:model];
            }
            [weakSelf.shoppingTableview reloadData];
        }else
        {
            [weakSelf ErrorMBProgressView:returnValue[@"message"]];
        }
    } WithErrorCodeBlock:^(id errorCodeValue) {
        [weakSelf endRefreshingForTableView:weakSelf.shoppingTableview];
        [weakSelf ErrorMBProgressView:NETWORK];
    } WithFailureBlock:^(NSError *error) {
        [weakSelf endRefreshingForTableView:weakSelf.shoppingTableview];
        [weakSelf ErrorMBProgressView:error.localizedDescription];
    }];
}


- (UITableViewCell *)tableView:(UITableView *)tableView cellForRowAtIndexPath:(NSIndexPath *)indexPath
{
    ShoppingTableViewCell *cell = [tableView dequeueReusableCellWithIdentifier:@"Shopping" forIndexPath:indexPath];
    cell.selectionStyle = UITableViewCellSelectionStyleNone;
    cell.model = [self.shopResponseArray objectAtIndex_opple:indexPath.row];
    cell.delegate = self;
    cell.cellindex = indexPath.row;
    //cell选中回调
    __weak typeof(cell) weakCell = cell;
    WS(weakSelf);
    [cell setReturnCellblock:^(NSInteger index) {
        [weakSelf setSelectedButton:index];
    }];
    //提示框回调
    [cell setPromptStringBlock:^(NSString *string) {
        [weakSelf SHOWPrompttext:string ComcpleteBlock:^{
            [weakCell.clinchTextfield becomeFirstResponder];
        }];
    }];
    return  cell;
}

- (NSInteger)tableView:(UITableView *)tableView numberOfRowsInSection:(NSInteger)section
{
    return self.shopResponseArray.count;
}


- (CGFloat)tableView:(UITableView *)tableView heightForRowAtIndexPath:(NSIndexPath *)indexPath
{
    return 80;
}

- (void)tableView:(UITableView *)tableView didSelectRowAtIndexPath:(NSIndexPath *)indexPath
{
    ProductDetailsViewController *productDetails = [[[self class] getMainStoryboardClass] instantiateViewControllerWithIdentifier:@"productdetails"];
    productDetails.goodsID = [[self.shopResponseArray objectAtIndex_opple:indexPath.row] goodsId];
    [self.navigationController pushViewController:productDetails animated:YES];
}

- (void)tableView:(UITableView *)tableView didDeselectRowAtIndexPath:(NSIndexPath *)indexPath
{
    [self.shoppingTableview deselectRowAtIndexPath:indexPath animated:YES];
}

#pragma mark -选中商品回调
- (void)setSelectedButton:(NSInteger)index;
{
    ShopcarModel *model = [self.shopResponseArray objectAtIndex_opple:index];
    model.isSelected = !model.isSelected;
    
    NSInteger goodsNumber = 0;
    for (ShopcarModel *model in self.shopResponseArray) {
        if (model.isSelected) {
            goodsNumber ++;
        }
    }
    if (goodsNumber == self.shopResponseArray.count) {
        self.allSelectedButton.selected = YES;
    }else
    {
        self.allSelectedButton.selected = NO;
    }
    [self CalculateSelectedGoodsAllprice];
    [self.settlementButton setTitle:[NSString stringWithFormat:@"去结算(%ld)",goodsNumber] forState:UIControlStateNormal];
}


#pragma mark -结算
- (IBAction)settlementButtonClick:(UIButton *)sender {
    
    NSMutableArray *array = [NSMutableArray array];
    for (ShopcarModel *model in self.shopResponseArray) {
        if (model.isSelected) {
            [array addObject:model];
        }
    }
    if (array.count == 0) {
        
        [self ErrorMBProgressView:@"没有选中任何商品"];
        return;
    }
    //商品总信息占位
     ShopcarModel*ZhanweiModel = [[ShopcarModel alloc]init];
    [array addObject:ZhanweiModel];
    GenerateOrdersViewController *generateOrder = [[[self class] getMainStoryboardClass] instantiateViewControllerWithIdentifier:@"generateorders"];
    generateOrder.settlementGoodsdatas = array;
    //清除已经生成订单的商品
    [generateOrder setDelecteSelectedGoods:^(NSArray *goodsCode) {
        
        DeleteCartRequest *delecteGoods = [[DeleteCartRequest alloc]init];
        delecteGoods.cartIds = goodsCode;
        WS(weakSelf);
        [[NetworkRequestClassManager Manager] NetworkRequestWithURL:SERVERREQUESTURL(REMOVESHOPPINGBAG) WithCallClass:weakSelf WithRequestType:0 WithParameter:delecteGoods WithReturnValueBlock:^(id returnValue) {
            
            [weakSelf RemoveMBProgressHUDLoding];
            if ([returnValue[@"code"] isEqualToNumber:@0]) {
                [weakSelf QueryShoppingCarNumber];
                //商品cell
                NSMutableArray *cellArray = [NSMutableArray array];
                //删除商品
                for (int i=0; i<weakSelf.shopResponseArray.count; i++) {
                    ShopcarModel *model = [weakSelf.shopResponseArray objectAtIndex_opple:i];
                    if ([goodsCode containsObject:model.fid]) {
                        [weakSelf.shopResponseArray removeObject:model];
                        NSIndexPath *indexpath = [NSIndexPath indexPathForRow:i inSection:0];
                        [cellArray addObject:indexpath];
                    }
                }
                [weakSelf.shoppingTableview deleteRowsAtIndexPaths:cellArray withRowAnimation:UITableViewRowAnimationTop];
            }else
            {
                [weakSelf ErrorMBProgressView:returnValue[@"message"]];
            }
            
        } WithErrorCodeBlock:^(id errorCodeValue) {
            [weakSelf ErrorMBProgressView:NETWORK];
        } WithFailureBlock:^(NSError *error) {
            [weakSelf ErrorMBProgressView:error.localizedDescription];
        }];
    }];
    [self.navigationController pushViewController:generateOrder animated:YES];
}

#pragma mark -全选
- (IBAction)allSelectedButtonClick:(UIButton *)sender {
    sender.selected = !sender.selected;
    if (sender.selected) {
        //全部选中
        for (ShoppingTableViewCell *cell in self.shoppingTableview.visibleCells) {
            cell.selectedButton.selected = YES;
        }
        for (ShopcarModel *model in self.shopResponseArray) {
            model.isSelected = YES;
        }
        [self.settlementButton setTitle:[NSString stringWithFormat:@"去结算(%ld)",self.shopResponseArray.count] forState:UIControlStateNormal];
    }else
    {
        //取消全部选中
        for (ShoppingTableViewCell *cell in self.shoppingTableview.visibleCells) {
            cell.selectedButton.selected = NO;
        }
        for (ShopcarModel *model in self.shopResponseArray) {
            model.isSelected = NO;
        }
        [self.settlementButton setTitle:@"去结算(0)" forState:UIControlStateNormal];
    }
    //计算总金额
    [self CalculateSelectedGoodsAllprice];
}

#pragma mark -计算选中后的商品总金额
- (void)CalculateSelectedGoodsAllprice
{
    CGFloat allPrice = 0;
    for (ShopcarModel *model in self.shopResponseArray) {
        if (model.isSelected) {
            allPrice += ([model.costPrice floatValue]?[model.costPrice floatValue]:[model.goods.tagPrice floatValue]) * model.goodsNum;
        }
    }
    self.totalpriceLabe.text = [NSString stringWithFormat:@"￥%.2f",allPrice];
}


#pragma mark -删除选中商品
- (IBAction)delecteSelectedGoods:(UIButton *)sender {

    [self CreateMBProgressHUDLoding];
    DeleteCartRequest *delecteGoods = [[DeleteCartRequest alloc]init];
    //code数组
    NSMutableArray *codeArr = [NSMutableArray array];
    //需要删除的cell数组indexpath
    NSMutableArray *delecteArray = [NSMutableArray array];
    //模型数组
    NSMutableArray *delectemodel = [NSMutableArray array];
    for (int i=0; i<self.shopResponseArray.count; i++) {
        ShopcarModel *model = [self.shopResponseArray objectAtIndex_opple:i];
        if (model.isSelected) {
            [codeArr addObject:model.fid];
            [delectemodel addObject:model];
            NSIndexPath *indexpath = [NSIndexPath indexPathForRow:i inSection:0];
            [delecteArray addObject:indexpath];
        }
    }
    //没有选中任何商品
    if (codeArr.count == 0) {
        [self RemoveMBProgressHUDLoding];
        [self SHOWPrompttext:@"未选中商品"];
        return;
    }
    delecteGoods.cartIds = codeArr;
    WS(weakSelf);
    [[NetworkRequestClassManager Manager] NetworkRequestWithURL:SERVERREQUESTURL(REMOVESHOPPINGBAG) WithCallClass:weakSelf WithRequestType:0 WithParameter:delecteGoods WithReturnValueBlock:^(id returnValue) {
        
        [weakSelf RemoveMBProgressHUDLoding];
        if ([returnValue[@"code"] isEqualToNumber:@0]) {
            
            [weakSelf QueryShoppingCarNumber];
            //删除商品
            for (ShopcarModel *model in delectemodel) {
                [weakSelf.shopResponseArray removeObject:model];
            }
            [weakSelf.shoppingTableview deleteRowsAtIndexPaths:delecteArray withRowAnimation:UITableViewRowAnimationLeft];
            dispatch_after(dispatch_time(DISPATCH_TIME_NOW, (int64_t)(1 * NSEC_PER_SEC)), dispatch_get_main_queue(), ^{
                [weakSelf.shoppingTableview reloadData];
            });
            [weakSelf SuccessMBProgressView:@"删除成功"];
            [weakSelf CalculateSelectedGoodsAllprice];
            weakSelf.allSelectedButton.selected = NO;
            [weakSelf.settlementButton setTitle:@"去结算(0)" forState:UIControlStateNormal];
        }else
        {
            [weakSelf ErrorMBProgressView:returnValue[@"message"]];
        }

    } WithErrorCodeBlock:^(id errorCodeValue) {
        [weakSelf ErrorMBProgressView:NETWORK];
    } WithFailureBlock:^(NSError *error) {
        [weakSelf ErrorMBProgressView:error.localizedDescription];
    }];
}

#pragma mark - 修改多个商品数量、价格
- (void)modifyMultipleGoodsNnumberOrPrice:(NSArray<ShopcarModel *> *)goodsArray completeModify:(void(^)(BOOL boolValue))finish
{
    WS(weakSelf);
    dispatch_group_t group = dispatch_group_create();
    static NSInteger number = ZERO;
    [self CreateMBProgressHUDLoding];
    [goodsArray enumerateObjectsUsingBlock:^(ShopcarModel * _Nonnull model, NSUInteger idx, BOOL * _Nonnull stop) {

        dispatch_group_enter(group);
        NSLog(@"%@",[NSString stringWithFormat:@"%@%@/%@/%@/%ld",SERVERREQUESTURL(CHANGESHOPPINGBAGNUMBERPRICE),model.fid,model.goodsId,[model.costPrice stringValue],model.goodsNum]);
        [[NetworkRequestClassManager Manager] NetworkWithDictionaryRequestWithURL:[NSString stringWithFormat:@"%@%@/%@/%@/%ld",SERVERREQUESTURL(CHANGESHOPPINGBAGNUMBERPRICE),model.fid,model.goodsId,[model.costPrice stringValue],model.goodsNum] WithCallClass:weakSelf WithRequestType:1 WithParameter:nil WithReturnValueBlock:^(id returnValue) {
            
            dispatch_group_leave(group);
            if ([returnValue[@"code"] isEqualToNumber:@0]) {
                number ++;
            }
        } WithErrorCodeBlock:^(id errorCodeValue) {
            dispatch_group_leave(group);
        } WithFailureBlock:^(NSError *error) {
            dispatch_group_leave(group);
        }];
    }];
    
    dispatch_group_notify(group, dispatch_get_main_queue(), ^{
        
        [weakSelf RemoveMBProgressHUDLoding];
        if (number == goodsArray.count) {
            [weakSelf CalculateSelectedGoodsAllprice];
            [weakSelf QueryShoppingCarNumber];
            finish(YES);
        }else {
            [self SHOWPrompttext:@"修改失败" ComcpleteBlock:^{
                finish(NO);
            }];
        }
        number = ZERO;
    });
}

#pragma mark -修改单个商品数量、价格
- (void)changeGoodsNumber:(NSInteger)goodsNumber WithcostPrice:(CGFloat)costprice Withcellindex:(NSInteger)cellindex returnValue:(void (^)(id))result
{
    [self CreateMBProgressHUDLoding];
    //保存商品数量
    ShopcarModel *model = [self.shopResponseArray objectAtIndex_opple:cellindex];
    model.goodsNum = goodsNumber;
    //保存成交价格
    model.costPrice = [NSNumber numberWithFloat:costprice];
    //在服务器保存数量、成交价
    //购物车ID
    NSString *carid = model.fid;
    //商品id
    NSString *goodsis = model.goodsId;
    //成交价
    NSString *costpriceString = [NSString stringWithFormat:@"%.2f",costprice];
    //商品数量
    NSString *goodsNumberString = [NSString stringWithFormat:@"%ld",(long)goodsNumber];
    WS(weakSelf);
    [[NetworkRequestClassManager Manager] NetworkWithDictionaryRequestWithURL:[NSString stringWithFormat:@"%@%@/%@/%@/%@",SERVERREQUESTURL(CHANGESHOPPINGBAGNUMBERPRICE),carid,goodsis,costpriceString,goodsNumberString] WithCallClass:weakSelf WithRequestType:1 WithParameter:nil WithReturnValueBlock:^(id returnValue) {
        
        [weakSelf RemoveMBProgressHUDLoding];
        result(returnValue);//提供是否支持修改的参数
        if ([returnValue[@"code"] isEqualToNumber:@0]) {
            [weakSelf CalculateSelectedGoodsAllprice];
            [weakSelf QueryShoppingCarNumber];
        }else{
            
            [weakSelf ErrorMBProgressView:returnValue[@"message"]];
        }
        
    } WithErrorCodeBlock:^(id errorCodeValue) {
        [weakSelf ErrorMBProgressView:NETWORK];
    } WithFailureBlock:^(NSError *error) {
        [weakSelf ErrorMBProgressView:error.localizedDescription];
    }];
}

#pragma mark -友好界面
- (UIImage *)imageForEmptyDataSet:(UIScrollView *)scrollView
{
    return kNoDataImage;
}

- (NSAttributedString *)titleForEmptyDataSet:(UIScrollView *)scrollView
{
    return [[NSAttributedString alloc]initWithString:@"暂无数据" attributes:nil];
}



@end
