//
//  AddressViewController.m
//  Lighting
//
//  Created by 曹云霄 on 16/5/10.
//  Copyright © 2016年 上海勾芒科技有限公司. All rights reserved.
//

#import "AddressViewController.h"
#import "ModifyShippingAddressView.h"

@interface AddressViewController ()<CityselectedDelegate>


/**
 *  城市选择器
 */
@property (nonatomic,strong) ModifyShippingAddressView *citySelecteview;

/**
 *  选中省
 */
@property (nonatomic,copy) NSString *provincesString;

/**
 * 选中城市
 */
@property (nonatomic,copy) NSString *cityString;

@end

@implementation AddressViewController


/**
 *  城市选择View
 *
 *  @return ModifyShippingAddressView
 */
- (ModifyShippingAddressView *)citySelecteview
{
    if (_citySelecteview == nil) {
        
        _citySelecteview = [[[NSBundle mainBundle] loadNibNamed:@"ModifyShippingAddressView"
                                                          owner:self options:nil] lastObject];
    }
    return _citySelecteview;
}


- (void)viewDidLoad {
    [super viewDidLoad];
    // Do any additional setup after loading the view from its nib.
    
    [self uiConfigAction];
}

#pragma mark -布局
- (void)uiConfigAction
{
    self.recipientUserBackview.layer.masksToBounds = YES;
    self.recipientUserBackview.layer.cornerRadius = kCornerRadius;
    self.phoneNumberBackview.layer.masksToBounds = YES;
    self.phoneNumberBackview.layer.cornerRadius = kCornerRadius;
    self.detailsAddressBackview.layer.masksToBounds = YES;
    self.detailsAddressBackview.layer.cornerRadius = kCornerRadius;
    self.citySelected.layer.masksToBounds = YES;
    self.citySelected.layer.cornerRadius = kCornerRadius;
    self.delectAddressButton.layer.masksToBounds = YES;
    self.delectAddressButton.layer.cornerRadius = kCornerRadius;
    self.modifyButton.layer.masksToBounds = YES;
    self.modifyButton.layer.cornerRadius = kCornerRadius;
    [self.citySelected addTarget:self action:@selector(SelectedCityButtonClick) forControlEvents:UIControlEventTouchUpInside];
    //判断是修改还是新增
    if (_isChange) {
        self.changAddressLabe.text = @"修改收货地址";
        [self.delectAddressButton setTitle:@"删除" forState:UIControlStateNormal];
        [self.modifyButton setTitle:@"保存" forState:UIControlStateNormal];
    }else
    {
        self.changAddressLabe.text = @"新增收货地址";
    }
    self.recipientPerson.text = _model.name;
    self.PhoneNumber.text = _model.miblephone;
    [self.citySelected setTitle:_model.city forState:UIControlStateNormal];
    self.detailsAddress.text = _model.address;
}

#pragma mark -取消弹出的圆角
- (void)viewWillAppear:(BOOL)animated
{
    [super viewWillAppear:animated];
    self.view.superview.layer.cornerRadius = 0;
}

#pragma mark -城市选择器
- (void)SelectedCityButtonClick
{
    
    self.citySelecteview.frame = CGRectMake(0, self.view.frame.size.height, self.view.frame.size.width, 160);
    [self.view addSubview:self.citySelecteview];
    self.citySelecteview.delegate = self;
    [self.citySelecteview.selectedCityButton addTarget:self action:@selector(CompleteButton) forControlEvents:UIControlEventTouchUpInside];
    [UIView animateWithDuration:0.2 animations:^{
        self.citySelecteview.frame = CGRectMake(0, self.view.frame.size.height-160, self.view.frame.size.width, 160);
    }completion:^(BOOL finished) {
        self.citySelected.enabled = NO;
    }];
}


#pragma mark -完成按钮点击
- (void)CompleteButton
{
    [UIView animateWithDuration:0.2 animations:^{
        
        self.citySelecteview.frame = CGRectMake(0, ScreenHeight, self.view.frame.size.width, 160);
    }completion:^(BOOL finished) {
        
        [self.citySelecteview removeFromSuperview];
        self.citySelecteview = nil;
        self.citySelected.enabled = YES;
    }];
}


#pragma mark -关闭地址输入框
- (IBAction)turnoffAddressView:(UIButton *)sender {
    
    [self dismissViewControllerAnimated:YES completion:nil];
}


#pragma mark 完成城市选择后
- (void)citySelected:(NSString *)cityString WithprovincesString:(NSString *)provincesString
{
    self.cityString = cityString;
    self.provincesString = provincesString;
    [self.citySelected setTitle:cityString forState:UIControlStateNormal];
}


#pragma mark 新增按钮点击，或者保存
- (IBAction)addAddressButtonClick:(UIButton *)sender {
    
    NSString *phoneNumber = self.PhoneNumber.text;
    if ([BaseViewController isBlankString:self.recipientPerson.text]) {
        [self ErrorMBProgressView:@"请输入收货人姓名"];
        return;
    }
    if ([BaseViewController isBlankString:phoneNumber]) {
        [self ErrorMBProgressView:@"手机号码不能为空"];
        return;
    }
    if (![HENLENSONG isValidateMobile:phoneNumber]) {
        
        [self ErrorMBProgressView:@"手机号码格式不正确"];
        return;
    }
    if ([BaseViewController isBlankString:self.detailsAddress.text]) {
        [self ErrorMBProgressView:@"请输入详细地址"];
        return;
    }
    if ([sender.currentTitle isEqualToString:@"新增"]) {
       
        [self addAddressInformationRequest];
    }
    else if ([sender.currentTitle isEqualToString:@"保存"])
    {
        [self ChangeAddressInformationRequest];
    }
}


#pragma mark -新增地址信息
- (void)addAddressInformationRequest
{
    TOShippingAddrEntity *address = [[TOShippingAddrEntity alloc]init];
    address.consumerId = [Customermanager manager].model.fid;
    address.name = self.recipientPerson.text;
    address.miblephone = self.PhoneNumber.text;
    address.city = [self.citySelected currentTitle];
    if (![self.provincesString isEqualToString:[self.citySelected currentTitle]]) {
      address.province = self.provincesString;
    }
    address.address = self.detailsAddress.text;
    [self CreateMBProgressHUDLoding];
    WS(weakSelf);
    [[NetworkRequestClassManager Manager] NetworkRequestWithURL:SERVERREQUESTURL(ADDADDRESS) WithCallClass:weakSelf WithRequestType:0 WithParameter:address WithReturnValueBlock:^(id returnValue) {
        
        [weakSelf RemoveMBProgressHUDLoding];
        if ([returnValue[@"code"] isEqualToNumber:@0]) {
            
            AddressModel *model = [[AddressModel alloc]init];
            model.name = weakSelf.recipientPerson.text;
            model.miblephone = weakSelf.PhoneNumber.text;
            if ([[weakSelf.citySelected currentTitle] isEqualToString:weakSelf.provincesString]) {
                model.city = weakSelf.citySelected.currentTitle;
                model.province = nil;
            }else
            {
                model.city = weakSelf.citySelected.currentTitle;
                model.province = weakSelf.provincesString;
            }
            model.address = weakSelf.detailsAddress.text;
            model.consumerId = [Customermanager manager].model.fid;
            model.fid = returnValue[@"data"];
            model.isSelected = NO;
            //增加地址
            if ([weakSelf.delegate respondsToSelector:@selector(addAddressCell:)]) {
                
                [weakSelf.delegate addAddressCell:model];
            }
        }
        else
        {
            [weakSelf ErrorMBProgressView:returnValue[@"message"]];
        }
        
    } WithErrorCodeBlock:^(id errorCodeValue) {
        [weakSelf ErrorMBProgressView:NETWORK];
        
    } WithFailureBlock:^(id error) {
    }];
}


#pragma mark -更改地址
- (void)ChangeAddressInformationRequest
{
    
    TOShippingAddrEntity *address = [[TOShippingAddrEntity alloc]init];
    address.consumerId = [Customermanager manager].model.fid;
    address.name = self.recipientPerson.text;
    address.miblephone = self.PhoneNumber.text;
    address.city = [self.citySelected currentTitle];
    address.address = self.detailsAddress.text;
    if (![self.provincesString isEqualToString:[self.citySelected currentTitle]]) {
        address.province = self.provincesString;
    }
    address.fid = self.model.fid;
    [self CreateMBProgressHUDLoding];
    WS(weakSelf);
    [[NetworkRequestClassManager Manager] NetworkRequestWithURL:SERVERREQUESTURL(CHANGEADDRESS) WithCallClass:weakSelf WithRequestType:0 WithParameter:address WithReturnValueBlock:^(id returnValue) {
        
        [self RemoveMBProgressHUDLoding];
        if ([returnValue[@"code"] isEqualToNumber:@0]) {
            
            AddressModel *model = [[AddressModel alloc]init];
            model.name = weakSelf.recipientPerson.text;
            model.miblephone = weakSelf.PhoneNumber.text;
            model.city = weakSelf.citySelected.currentTitle;
            model.consumerId = [Customermanager manager].model.fid;
            model.province = weakSelf.provincesString?weakSelf.provincesString:@"";
            model.fid = weakSelf.model.fid;
            model.isSelected = NO;
            //地址拼接
            if (![weakSelf.provincesString isEqualToString:[weakSelf.citySelected currentTitle]]) {
                model.address = [NSString stringWithFormat:@"%@",weakSelf.detailsAddress.text];
            }else
            {
                model.address = [NSString stringWithFormat:@"%@",weakSelf.detailsAddress.text];
            }
            //修改地址
            if ([weakSelf.delegate respondsToSelector:@selector(ChangeAddresscell:Withcellindex:)]) {
                
                [weakSelf.delegate ChangeAddresscell:model Withcellindex:_cellindex];
            }
        }
        else
        {
            [self ErrorMBProgressView:returnValue[@"message"]];
        }
        
    } WithErrorCodeBlock:^(id errorCodeValue) {
        [weakSelf RemoveMBProgressHUDLoding];
        [weakSelf ErrorMBProgressView:@"无网络"];
        
    } WithFailureBlock:^(id error) {
        
        NSLog(@"%@",error);
        [weakSelf RemoveMBProgressHUDLoding];
    }];
}


#pragma mark -取消新增地址，或者删除
- (IBAction)cancelButtonClick:(UIButton *)sender {
    
    if ([sender.currentTitle isEqualToString:@"取消"]) {
        
        [self dismissViewControllerAnimated:YES completion:nil];
    }
    else if ([sender.currentTitle isEqualToString:@"删除"])
    {
        [self deleteAddressButtonClick];
    }
}


#pragma mark -删除收货地址
- (void)deleteAddressButtonClick
{
    [self CreateMBProgressHUDLoding];
    WS(weakSelf);
    [[NetworkRequestClassManager Manager] NetworkRequestWithURL:[NSString stringWithFormat:@"%@%@",SERVERREQUESTURL(REMOVEADDRESS),_model.fid] WithCallClass:weakSelf WithRequestType:ONE WithParameter:nil WithReturnValueBlock:^(id returnValue) {
        
        [weakSelf RemoveMBProgressHUDLoding];
        if ([returnValue[@"code"] isEqualToNumber:@0]) {
            
            [weakSelf SuccessMBProgressView:@"删除成功"];
            if ([weakSelf.delegate respondsToSelector:@selector(delecteCell:)]) {
                
                [weakSelf.delegate delecteCell:_model.fid];
            }
        }else
        {
            [weakSelf ErrorMBProgressView:returnValue[@"message"]];
        }
        
    } WithErrorCodeBlock:^(id errorCodeValue) {
        [weakSelf ErrorMBProgressView:@"无网络"];
    } WithFailureBlock:^(id error) {
    }];
}


/*
#pragma mark - Navigation

// In a storyboard-based application, you will often want to do a little preparation before navigation
- (void)prepareForSegue:(UIStoryboardSegue *)segue sender:(id)sender {
    // Get the new view controller using [segue destinationViewController].
    // Pass the selected object to the new view controller.
}
*/

@end
