//
//  PrizeListCollectionViewCell.m
//  Lighting
//
//  Created by 曹云霄 on 2016/11/22.
//  Copyright © 2016年 上海勾芒科技有限公司. All rights reserved.
//

#import "PrizeListCollectionViewCell.h"

@implementation PrizeListCollectionViewCell

- (void)setPrizeModel:(PrizeListModel *)prizeModel
{
    _prizeModel = prizeModel;
    [self.prizeImageView sd_setImageWithURL:[NSURL URLWithString:_prizeModel.picture] placeholderImage:REPLACEIMAGE];
    self.prizeDescribeLabel.text = _prizeModel.name;
    self.isSelectButton.selected = _prizeModel.isSelect;
    self.backgroundColor = _prizeModel.isAllowSelect?[UIColor whiteColor]:[UIColor lightGrayColor];
}

#pragma mark - 选中
- (IBAction)isSelectButton:(UIButton *)sender {
    
    if (_prizeModel.isAllowSelect) {
        sender.selected = !sender.selected;
        _prizeModel.isSelect = sender.selected;
    }
}

@end
