//
//  EmigratedMainViewController.m
//  Lighting
//
//  Created by 曹云霄 on 2016/11/28.
//  Copyright © 2016年 上海勾芒科技有限公司. All rights reserved.
//

#import "EmigratedMainViewController.h"
#import "ThroughHistoryView.h"
#import "InstructionsViewController.h"

@interface EmigratedMainViewController ()

@property (nonatomic,strong) WYPopoverController *popover;

/**
 闯关数据
 */
@property (nonatomic,strong) PassLevelResponse *emigratedResponse;

@end

@implementation EmigratedMainViewController

- (void)viewDidLoad {
    [super viewDidLoad];
    
    [self getThroughHistoryDatasAction];
}

#pragma mark - 获取闯关信息
- (void)getThroughHistoryDatasAction
{
    WS(weakSelf);
    PassLevelCondition *emigrated = [[PassLevelCondition alloc]init];
    emigrated.employeeIdEquals = [Shoppersmanager manager].Shoppers.employee.fid;
    emigrated.beginDateFrom = [[self class] getTimeby:-7];
    emigrated.endDateTo = [[self class] getTimeby:0];
    DataPage *page = [[DataPage alloc]init];
    page.page = ONE;
    page.rows = KROWS;
    emigrated.page = page;
    [self CreateMBProgressHUDLoding];
    NSLog(@"%@",[emigrated toDictionary]);
    [[NetworkRequestClassManager Manager] NetworkRequestWithURL:SERVERREQUESTURL(THROUGHLIST) WithCallClass:weakSelf WithRequestType:ZERO WithParameter:emigrated WithReturnValueBlock:^(id returnValue) {
        
        NSLog(@"%@",returnValue);
        if ([returnValue[@"code"] isEqualToNumber:@0]) {
            weakSelf.emigratedResponse = [[PassLevelResponse alloc]initWithDictionary:returnValue[@"data"] error:nil];
        }else {
            [weakSelf RemoveMBProgressHUDLoding];
        }
        
    } WithErrorCodeBlock:^(id errorCodeValue) {
        [weakSelf ErrorMBProgressView:NETWORK];
    } WithFailureBlock:^(NSError *error) {
        [weakSelf ErrorMBProgressView:error.localizedDescription];
    }];
}

#pragma mark - 开始
- (IBAction)beginButtonClickAction:(UIButton *)sender {
    
    CGFloat width = 100;
    CGFloat height = 120;
    CGFloat interval = 30;
    for (int i=0; i<10; i++) {
        ThroughHistoryView *throughView = [ThroughHistoryView initializeView];
        throughView.frame = CGRectMake(i*width+i*interval, 0, width, height);
        [self.throughHistoryBackScrollView addSubview:throughView];
    }
    self.throughHistoryBackScrollView.contentSize = CGSizeMake(10*width+9*interval, 0);
    WS(weakSelf);
    [UIView animateWithDuration:0.2 animations:^{
        sender.alpha = 0;
        weakSelf.throughHistoryBackScrollView.alpha = 1;
    }];
}

#pragma mark - 闯关说明
- (IBAction)instructionsButtonClickAction:(UIButton *)sender {
    
    InstructionsViewController *instruction = [[[self class] getLearningCenterStoryboardClass] instantiateViewControllerWithIdentifier:@"InstructionsViewController"];
    WS(weakSelf);
    [instruction setDismissSyntonyBlock:^{
        [weakSelf.popover dismissPopoverAnimated:YES];
    }];
    instruction.preferredContentSize = CGSizeMake(ScreenWidth/2, ScreenHeight/2);
    self.popover = [[WYPopoverController alloc] initWithContentViewController:instruction];
    self.popover.theme.fillBottomColor = [UIColor clearColor];
    self.popover.theme.fillTopColor = [UIColor clearColor];
    self.popover.theme.glossShadowColor = [UIColor clearColor];
    [self.popover presentPopoverAsDialogAnimated:YES options:WYPopoverAnimationOptionFadeWithScale];
}


@end
