//
//  VideoListViewController.m
//  Lighting
//
//  Created by 曹云霄 on 2016/11/25.
//  Copyright © 2016年 上海勾芒科技有限公司. All rights reserved.
//

#import "VideoListViewController.h"
#import "VideoListItemTableViewCell.h"
#import "VideoListSectionHeaderView.h"

@interface VideoListViewController ()<UITableViewDelegate,UITableViewDataSource>


@property (weak, nonatomic) IBOutlet UIView *headerView;

@end

@implementation VideoListViewController

- (void)viewDidLoad {
    [super viewDidLoad];
    
    [self setUpTableView];
}

#pragma mark - UITableView
- (void)setUpTableView
{
    self.studyListTableView.tableFooterView = [UIView new];
    self.studyListTableView.rowHeight = 50;
    self.studyListTableView.sectionHeaderHeight = 60;
}

#pragma mark - <UITableViewDelegate,UITableViewDataSource>
- (UITableViewCell *)tableView:(UITableView *)tableView cellForRowAtIndexPath:(NSIndexPath *)indexPath
{
    VideoListItemTableViewCell *studyItemCell = [tableView dequeueReusableCellWithIdentifier:@"VideoListItemTableViewCell" forIndexPath:indexPath];
    return studyItemCell;
}

- (NSInteger)tableView:(UITableView *)tableView numberOfRowsInSection:(NSInteger)section
{
    return 10;
}

- (UIView *)tableView:(UITableView *)tableView viewForHeaderInSection:(NSInteger)section
{
    VideoListSectionHeaderView *headerView = [tableView dequeueReusableCellWithIdentifier:@"VideoListSectionHeaderView"];
    return headerView;
}

- (NSInteger)numberOfSectionsInTableView:(UITableView *)tableView
{
    return 2;
}

@end
