//
//  VideoDetailViewController.m
//  Lighting
//
//  Created by 曹云霄 on 2016/11/25.
//  Copyright © 2016年 上海勾芒科技有限公司. All rights reserved.
//

#import "VideoDetailViewController.h"
#import "VideoDetailIntroTableViewCell.h"
#import "VideoLecturerTableViewCell.h"
#import "WkWebViewViewController.h"


@interface VideoDetailViewController ()<UITableViewDataSource,UITableViewDelegate>

/**
 简介高度
 */
@property (nonatomic,assign) CGFloat introductionHeight;

@end

@implementation VideoDetailViewController

- (void)viewDidLoad {
    [super viewDidLoad];
    
    [self addChildWebViewController];
    [self setUpTableView];
}

#pragma mark - UITableView
- (void)setUpTableView
{
    self.studyItemDetailsTableView.tableFooterView = [UIView new];
}

#pragma mark - WKWebView
- (void)addChildWebViewController
{
    WS(weakSelf);
    WkWebViewViewController *webView = [[WkWebViewViewController alloc]initWithReturnContentSize:^(CGFloat contentHeight) {
        weakSelf.introductionHeight = contentHeight;
        webView.view.frame = CGRectMake(0, 0, ScreenWidth, contentHeight);
        [weakSelf.studyItemDetailsTableView reloadData];
    }];
    self.introductionHeight = 100;//默认值
    webView.view.frame = CGRectMake(0, 0, ScreenWidth, self.introductionHeight);
    [self addChildViewController:webView];
}

#pragma mark - <UITableViewDelegate,UITableViewDataSource>
- (UITableViewCell *)tableView:(UITableView *)tableView cellForRowAtIndexPath:(NSIndexPath *)indexPath
{
    switch (indexPath.row) {
        case StudyItemIntroCell:
        {
            VideoDetailIntroTableViewCell *itemDetailCell = [tableView dequeueReusableCellWithIdentifier:@"VideoDetailIntroTableViewCell" forIndexPath:indexPath];
            [itemDetailCell.contentView addSubview:self.childViewControllers[0].view];
            return itemDetailCell;
        }
            break;
        case LecturerIntroCell:
        {
            VideoLecturerTableViewCell *lectureCell = [tableView dequeueReusableCellWithIdentifier:@"VideoLecturerTableViewCell" forIndexPath:indexPath];
            return lectureCell;
        }
            break;
        case ContraposePersonCell:
        {
            VideoDetailIntroTableViewCell *scopeCell = [tableView dequeueReusableCellWithIdentifier:@"VideoDetailIntroTableViewCell" forIndexPath:indexPath];
            return scopeCell;
        }
            break;
            
        default:
            break;
    }
    return nil;
}

- (NSInteger)tableView:(UITableView *)tableView numberOfRowsInSection:(NSInteger)section
{
    return 3;
}

- (CGFloat)tableView:(UITableView *)tableView heightForRowAtIndexPath:(NSIndexPath *)indexPath
{
    switch (indexPath.row) {
        case StudyItemIntroCell:
        {
            return self.introductionHeight;
        }
            break;
        case LecturerIntroCell:
        {
            return 130;
        }
            break;
        case ContraposePersonCell:
        {
            return 100;
        }
            break;
            
        default:
            break;
    }
    return 0;
}

@end
