//
//  OnlineLearningViewController.m
//  Lighting
//
//  Created by 曹云霄 on 2016/11/16.
//  Copyright © 2016年 上海勾芒科技有限公司. All rights reserved.
//

#import "OnlineLearningViewController.h"
#import "OnlineLearningTableViewCell.h"
#import "OnlineLearningDetailViewController.h"
@interface OnlineLearningViewController ()<UICollectionViewDelegate,UICollectionViewDataSource>


/**
 学习类别
 */
@property (nonatomic,strong) NSMutableArray *studyTypeArray;

@end

@implementation OnlineLearningViewController

- (void)viewDidLoad {
    [super viewDidLoad];
    
    [self setUpCollectionView];
    [self getLearningModuleData];
}

#pragma mark - UICollectionView
- (void)setUpCollectionView
{
    self.onlineLearningFlowLayout.itemSize = CGSizeMake((ScreenWidth-100)/4.0, ((ScreenWidth-100)/4.0-50));
    self.onlineLearningFlowLayout.sectionInset = UIEdgeInsetsMake(20, 20, 20, 20);
    self.onlineLearningFlowLayout.minimumLineSpacing = 20;
    self.onlineLearningFlowLayout.minimumInteritemSpacing = 20;
}

#pragma mark - 学习模块数据
- (void)getLearningModuleData
{
  WS(weakSelf);
  [self CreateMBProgressHUDLoding];
  [[NetworkRequestClassManager Manager] NetworkWithDictionaryRequestWithURL:SERVERREQUESTURL(STUDYTYPES) WithCallClass:weakSelf WithRequestType:ONE WithParameter:nil WithReturnValueBlock:^(id returnValue) {
      
      [weakSelf RemoveMBProgressHUDLoding];
      if ([returnValue[@"code"] isEqualToNumber:@0]) {
          StudyTypeResponse *response = [[StudyTypeResponse alloc]initWithDictionary:returnValue[@"data"] error:nil];
          [weakSelf.studyTypeArray addObjectsFromArray:response.types];
      }else {
          [weakSelf ErrorMBProgressView:returnValue[@"message"]];
      }
      [weakSelf.onlineLearningCollectionView reloadData];
      
  } WithErrorCodeBlock:^(id errorCodeValue) {
      [weakSelf ErrorMBProgressView:NETWORK];
  } WithFailureBlock:^(NSError *error) {
      [weakSelf ErrorMBProgressView:error.localizedDescription];
  }];
}

#pragma mark - <UICollectionViewDelegate,UICollectionViewDataSource>
- (NSInteger)collectionView:(UICollectionView *)collectionView numberOfItemsInSection:(NSInteger)section
{
    return self.studyTypeArray.count;
}

- (UICollectionViewCell *)collectionView:(UICollectionView *)collectionView cellForItemAtIndexPath:(NSIndexPath *)indexPath
{
    OnlineLearningTableViewCell *learningCell = [collectionView dequeueReusableCellWithReuseIdentifier:@"OnlineLearningTableViewCell" forIndexPath:indexPath];
    learningCell.studeType = self.studyTypeArray[indexPath.row];
    return learningCell;
}

- (void)collectionView:(UICollectionView *)collectionView didSelectItemAtIndexPath:(NSIndexPath *)indexPath
{
    OnlineLearningDetailViewController *studyDetail = [[[self class] getLearningCenterStoryboardClass]instantiateViewControllerWithIdentifier:@"OnlineLearningDetailViewController"];
    studyDetail.studyTypeID = [self.studyTypeArray[indexPath.row] fid];
    [self.navigationController pushViewController:studyDetail animated:YES];
}


#pragma mark - lazy
- (NSMutableArray *)studyTypeArray
{
    if (!_studyTypeArray) {
        _studyTypeArray = [NSMutableArray array];
    }
    return _studyTypeArray;
}

@end
