//
//  OnlineLearningDetailViewController.m
//  Lighting
//
//  Created by 曹云霄 on 2016/11/25.
//  Copyright © 2016年 上海勾芒科技有限公司. All rights reserved.
//

#import "OnlineLearningDetailViewController.h"
#import "VideoHelperViewController.h"
#import "VideoListViewController.h"
#import "VideoDetailViewController.h"


@interface OnlineLearningDetailViewController ()


/**
 学习项详情
 */
@property (nonatomic,strong) StudyTypeResponse *studyResponse;

@end

@implementation OnlineLearningDetailViewController


#pragma mark -渲染完成
- (void)viewDidAppear:(BOOL)animated
{
    [super viewDidAppear:animated];
    self.navigationController.fd_fullscreenPopGestureRecognizer.enabled = NO;
    if ([self.navigationController respondsToSelector:@selector(interactivePopGestureRecognizer)]) {
        self.navigationController.interactivePopGestureRecognizer.enabled = NO;
    }
}

#pragma mark -视图即将消失
- (void)viewWillDisappear:(BOOL)animated
{
    [super viewWillDisappear:animated];
    // 开启
    self.navigationController.fd_fullscreenPopGestureRecognizer.enabled = YES;
    if ([self.navigationController respondsToSelector:@selector(interactivePopGestureRecognizer)]) {
        self.navigationController.interactivePopGestureRecognizer.enabled = YES;
    }
}

- (void)viewDidLoad {
    [super viewDidLoad];
    
    [self addChildViewController];
    [self getStudyItemDetailAction];
}

#pragma mark - 
- (void)addChildViewController
{
    //播放窗口
    VideoHelperViewController *videoWindow = [[[self class] getLearningCenterStoryboardClass] instantiateViewControllerWithIdentifier:@"VideoHelperViewController"];
    videoWindow.videoUrl = @"http://mpvideo-test.b0.upaiyun.com/5813998fb092e5771.mp4";
    videoWindow.view.frame = CGRectMake(0, NavigationHeight, ScreenWidth*2/3, ScreenHeight/2);
    [self addChildViewController:videoWindow];
    [self.view addSubview:videoWindow.view];
    //播放列表
    VideoListViewController *playList = [[[self class] getLearningCenterStoryboardClass] instantiateViewControllerWithIdentifier:@"VideoListViewController"];
    playList.view.frame = CGRectMake(ScreenWidth*2/3 + 5, NavigationHeight, ScreenWidth/3-5, ScreenHeight-64);
    [self addChildViewController:playList];
    [self.view addSubview:playList.view];
    //播放简介
    VideoDetailViewController *playDetail = [[[self class] getLearningCenterStoryboardClass] instantiateViewControllerWithIdentifier:@"VideoDetailViewController"];
    playDetail.view.frame = CGRectMake(0, ScreenHeight/2+NavigationHeight, ScreenWidth*2/3, ScreenHeight/2-NavigationHeight);
    [self addChildViewController:playDetail];
    [self.view addSubview:playDetail.view];
    __block VideoHelperViewController *weakVideWindow = videoWindow;
    //全屏
    WS(weakSelf);
    [videoWindow setZoomButtonClickBlock:^(BOOL boolValue) {
        if (boolValue) {
            [weakSelf.view.window addSubview:weakVideWindow.view];
            [UIView animateWithDuration:0.2 animations:^{
                weakVideWindow.view.frame = [UIScreen mainScreen].bounds;
                weakVideWindow.playerLayer.frame = [UIScreen mainScreen].bounds;
            }];
        }else{
            [weakSelf.view insertSubview:weakVideWindow.view atIndex:0];
            [UIView animateWithDuration:0.2 animations:^{
                weakVideWindow.view.frame = CGRectMake(0, NavigationHeight, ScreenWidth*2/3, ScreenHeight/2);
                weakVideWindow.playerLayer.frame = CGRectMake(0, 0, ScreenWidth*2/3, ScreenHeight/2);
            }completion:nil];
        }
    }];
}

#pragma mark - 获取学习项详情
- (void)getStudyItemDetailAction
{
    WS(weakSelf);
    StudyTaskCondition *studyListModel = [[StudyTaskCondition alloc]init];
    studyListModel.employeeIdEquals = [Shoppersmanager manager].Shoppers.employee.fid;
    studyListModel.typeEquals = self.studyTypeID;
    DataPage *page = [[DataPage alloc] init];
    page.page = ONE;
    page.rows = 9999;
    studyListModel.page = page;
    [self CreateMBProgressHUDLoding];
    [[NetworkRequestClassManager Manager] NetworkRequestWithURL:SERVERREQUESTURL(STUDYLIST) WithCallClass:weakSelf WithRequestType:ZERO WithParameter:studyListModel WithReturnValueBlock:^(id returnValue) {
        
        NSLog(@"%@",[returnValue JSONString]);
        [weakSelf RemoveMBProgressHUDLoding];
        if ([returnValue[@"code"] isEqualToNumber:@0]) {
            weakSelf.studyResponse = [[StudyTypeResponse alloc]initWithDictionary:returnValue[@"data"] error:nil];
        }else {
            [weakSelf ErrorMBProgressView:returnValue[@"message"]];
        }
        
    } WithErrorCodeBlock:^(id errorCodeValue) {
        [weakSelf ErrorMBProgressView:NETWORK];
    } WithFailureBlock:^(NSError *error) {
        [weakSelf ErrorMBProgressView:error.localizedDescription];
    }];
}


@end
