//
//  ForumViewController.m
//  Lighting
//
//  Created by 曹云霄 on 2016/11/24.
//  Copyright © 2016年 上海勾芒科技有限公司. All rights reserved.
//

#import "ForumViewController.h"
#import "ForumTableViewCell.h"

@interface ForumViewController ()<UITableViewDelegate,UITableViewDataSource>

@end

@implementation ForumViewController

- (void)viewDidLoad {
    [super viewDidLoad];
    
    [self setUpForumTableView];
    [self getForumAllTypeAction];
}

#pragma mark - UITableView
- (void)setUpForumTableView
{
    self.forumTableView.tableFooterView = [UIView new];
    self.forumTableView.rowHeight = 90;
}

#pragma mark - 获取论坛项Type
- (void)getForumAllTypeAction
{
    WS(weakSelf);
    [self CreateMBProgressHUDLoding];
    [[NetworkRequestClassManager Manager] NetworkWithDictionaryRequestWithURL:SERVERREQUESTURL(FORUMTYPS) WithCallClass:weakSelf WithRequestType:ONE WithParameter:nil WithReturnValueBlock:^(id returnValue) {
        
        NSLog(@"%@",returnValue);
        [weakSelf RemoveMBProgressHUDLoding];
        if ([returnValue[@"code"] isEqualToNumber:@0]) {
            
        }else{
            [weakSelf ErrorMBProgressView:returnValue[@"message"]];
        }
    } WithErrorCodeBlock:^(id errorCodeValue) {
        [weakSelf ErrorMBProgressView:NETWORK];
    } WithFailureBlock:^(NSError *error) {
        [weakSelf ErrorMBProgressView:error.localizedDescription];
    }];
}

#pragma mark - <UITableViewDelegate,UITableViewDataSource>
- (UITableViewCell *)tableView:(UITableView *)tableView cellForRowAtIndexPath:(NSIndexPath *)indexPath
{
    ForumTableViewCell *forumCell = [tableView dequeueReusableCellWithIdentifier:@"ForumTableViewCell" forIndexPath:indexPath];
    return forumCell;
}

- (NSInteger)tableView:(UITableView *)tableView numberOfRowsInSection:(NSInteger)section
{
    return 10;
}

- (void)tableView:(UITableView *)tableView didSelectRowAtIndexPath:(NSIndexPath *)indexPath
{
    
}


@end
