//
//  ClientShoppingCarViewController.m
//  Lighting
//
//  Created by 曹云霄 on 2016/10/25.
//  Copyright © 2016年 上海勾芒科技有限公司. All rights reserved.
//

#import "ClientShoppingCarViewController.h"
#import "ShopcarModel.h"
#import "ProductDetailsViewController.h"
#import "ClientDetailsTableViewCell.h"

@interface ClientShoppingCarViewController ()<UITableViewDelegate,UITableViewDataSource,DZNEmptyDataSetSource,DZNEmptyDataSetDelegate>

/**
 *  记录总页数
 */
@property (nonatomic,assign) NSInteger totalPage;

/**
 *  购物车数据源
 */
@property (nonatomic,strong) NSMutableArray *shopResponseArray;

/**
 *  购物袋请求
 */
@property (nonatomic,strong) ShopCartFilter *shoppingCarModel;

@end

@implementation ClientShoppingCarViewController

- (void)viewDidLoad {
    [super viewDidLoad];
    
    [self GetdatasAciton];
}

#pragma mark -获取数据
- (void)GetdatasAciton
{
    WS(weakSelf);
    //下拉刷新
    MjRefreshHeaderCustom *headerRefresh = [MjRefreshHeaderCustom headerWithRefreshingBlock:^{
        //购物袋
        weakSelf.shoppingCarModel.dp.page = 1;
        [weakSelf.clientShoppingCarTableView.mj_footer resetNoMoreData];
        [weakSelf getShoppingCardata:weakSelf.shoppingCarModel isRemove:YES];
    }];
    headerRefresh.stateLabel.hidden = YES;
    headerRefresh.lastUpdatedTimeLabel.hidden = YES;
    self.clientShoppingCarTableView.mj_header = headerRefresh;
    //进入刷新状态
    [self.clientShoppingCarTableView.mj_header beginRefreshing];
    //上拉加载
    self.clientShoppingCarTableView.mj_footer = [MJRefreshAutoNormalFooter footerWithRefreshingBlock:^{
        
        [weakSelf.clientShoppingCarTableView.mj_footer resetNoMoreData];
        //购物袋
        if (++ weakSelf.shoppingCarModel.dp.page > weakSelf.totalPage) {
            [weakSelf.clientShoppingCarTableView.mj_footer endRefreshingWithNoMoreData];
        }else
        {
            [weakSelf getShoppingCardata:weakSelf.shoppingCarModel isRemove:NO];
        }
    }];
    self.clientShoppingCarTableView.mj_footer.automaticallyHidden = YES;
    self.clientShoppingCarTableView.tableFooterView = [UIView new];
}

#pragma mark -获取购物车商品
- (void)getShoppingCardata:(ShopCartFilter *)shopCar isRemove:(BOOL)remove
{
    [self CreateMBProgressHUDLoding];
    WS(weakSelf);
    [[NetworkRequestClassManager Manager] NetworkRequestWithURL:SERVERREQUESTURL(SHOPPINGBAG) WithCallClass:weakSelf WithRequestType:0 WithParameter:shopCar WithReturnValueBlock:^(id returnValue) {
        
        weakSelf.clientShoppingCarTableView.emptyDataSetSource = weakSelf;
        weakSelf.clientShoppingCarTableView.emptyDataSetDelegate = weakSelf;
        [weakSelf endRefreshingForTableView:weakSelf.clientShoppingCarTableView];
        [weakSelf RemoveMBProgressHUDLoding];
        if ([returnValue[@"code"] isEqualToNumber:@0]) {
            if (remove) {
                [weakSelf.shopResponseArray removeAllObjects];
            }
            ShopCartResponse *shopcar = [[ShopCartResponse alloc]initWithDictionary:returnValue[@"data"] error:nil];
            weakSelf.totalPage = [returnValue[@"data"][@"totalpages"] intValue];
            //自定义属性
            for (TOShopcartEntity *objc in shopcar.shopcart) {
                ShopcarModel *model = [[ShopcarModel alloc]init];
                model.goods = objc.goods;
                model.fid = objc.fid;
                model.createName = objc.createName;
                model.createBy = objc.createBy;
                model.createDate = objc.createDate;
                model.updateName = objc.updateName;
                model.updateBy = objc.updateBy;
                model.updateDate = objc.updateDate;
                model.goodsId = objc.goodsId;
                model.goodsNum = objc.goodsNum;
                model.consumerId = objc.consumerId;
                [weakSelf.shopResponseArray addObject:model];
            }
            [weakSelf.clientShoppingCarTableView reloadData];
            
        }else
        {
            [weakSelf ErrorMBProgressView:returnValue[@"message"]];
        }
        
    } WithErrorCodeBlock:^(id errorCodeValue) {
        [weakSelf ErrorMBProgressView:NETWORK];
    } WithFailureBlock:^(NSError *error) {
        [weakSelf ErrorMBProgressView:error.localizedDescription];
    }];
}


- (UITableViewCell *)tableView:(UITableView *)tableView cellForRowAtIndexPath:(NSIndexPath *)indexPath
{
    ClientDetailsTableViewCell *cell = [tableView dequeueReusableCellWithIdentifier:@"ClientDetails" forIndexPath:indexPath];
    cell.selectionStyle = UITableViewCellSelectionStyleNone;
    cell.model = [self.shopResponseArray objectAtIndex_opple:indexPath.row];
    return cell;
}


- (NSInteger)tableView:(UITableView *)tableView numberOfRowsInSection:(NSInteger)section
{
    return self.shopResponseArray.count;
}

- (CGFloat)tableView:(UITableView *)tableView heightForRowAtIndexPath:(NSIndexPath *)indexPath
{
   return 100;
}

- (void)tableView:(UITableView *)tableView didSelectRowAtIndexPath:(NSIndexPath *)indexPath
{
    ProductDetailsViewController *productDetails = [[[self class] getMainStoryboardClass] instantiateViewControllerWithIdentifier:@"productdetails"];
    ShopcarModel *model = [self.shopResponseArray objectAtIndex_opple:indexPath.row];
    productDetails.goodsID = model.goods.fid;
    [self.navigationController pushViewController:productDetails animated:YES];
}

#pragma mark - lazy
- (NSMutableArray *)shopResponseArray
{
    if (_shopResponseArray == nil) {
        
        _shopResponseArray = [NSMutableArray array];
    }
    return _shopResponseArray;
}

- (ShopCartFilter *)shoppingCarModel
{
    if (!_shoppingCarModel) {
        _shoppingCarModel = [[ShopCartFilter alloc]init];
        DataPage *Newpage = [[DataPage alloc]init];
        Newpage.page = 1;
        Newpage.rows = KROWS;
        _shoppingCarModel.dp = Newpage;
        _shoppingCarModel.consumerId = self.model.fid;
    }
    return _shoppingCarModel;
}

#pragma mark -友好界面
- (UIImage *)imageForEmptyDataSet:(UIScrollView *)scrollView
{
    return kNoDataImage;
}

- (NSAttributedString *)titleForEmptyDataSet:(UIScrollView *)scrollView
{
    return [[NSAttributedString alloc]initWithString:@"暂无数据" attributes:nil];
}

- (BOOL)emptyDataSetShouldAllowScroll:(UIScrollView *)scrollView
{
    return YES;
}

- (CGFloat)verticalOffsetForEmptyDataSet:(UIScrollView *)scrollView
{
    return 100;
}



- (void)didReceiveMemoryWarning {
    [super didReceiveMemoryWarning];
}


@end
