//
//  WkWebViewViewController.m
//  Lighting
//
//  Created by 曹云霄 on 2016/11/24.
//  Copyright © 2016年 上海勾芒科技有限公司. All rights reserved.
//

#import "WkWebViewViewController.h"
@interface WkWebViewViewController ()<UIWebViewDelegate>

@end

@implementation WkWebViewViewController

- (void)viewDidLoad {
    [super viewDidLoad];
}

#pragma mark - 初始化
- (instancetype)initWithReturnContentSize:(void(^)(CGFloat contentHeight))block
{
    if (self = [super init]) {
        self.contentWebView = [[UIWebView alloc]initWithFrame:CGRectMake(27, 10, ScreenWidth-27*2, 0.01)];
        self.contentWebView.delegate = self;
        self.contentWebView.scrollView.scrollEnabled = NO;
        self.contentHeight = block;
        [self.view addSubview:self.contentWebView];
        //下划线
        UIView *lineView = [[UIView alloc]init];
        lineView.backgroundColor = RGB(237, 238, 239, 1);
        [self.view addSubview:lineView];
        [lineView mas_makeConstraints:^(MASConstraintMaker *make) {
            make.left.right.bottom.equalTo(self.view);
            make.size.mas_equalTo(CGSizeMake(ScreenWidth, 1));
        }];
    }
    return self;
}

- (void)setHtmlString:(NSString *)htmlString
{
    _htmlString = htmlString;
    [self.contentWebView loadHTMLString:_htmlString baseURL:nil];
}

#pragma mark - <UIWebViewDelegate>
- (void)webViewDidStartLoad:(UIWebView *)webView
{
    [self CreateMBProgressHUDLoding];
}
- (void)webViewDidFinishLoad:(UIWebView *)webView
{
    [self RemoveMBProgressHUDLoding];
    webView.height = webView.scrollView.contentSize.height;
    if (self.contentHeight) {
        self.contentHeight(webView.scrollView.contentSize.height+20);
    }
}

- (void)webView:(UIWebView *)webView didFailLoadWithError:(NSError *)error
{
    [self ErrorMBProgressView:@"加载失败"];
}



@end
