//
//  screeningFirstView.m
//  Lighting
//
//  Created by 曹云霄 on 16/5/8.
//  Copyright © 2016年 上海勾芒科技有限公司. All rights reserved.
//

#import "screeningFirstView.h"
#import "ScreeningFirstCollectionViewCell.h"
#import "ScreeningCollectionReusableView.h"
#define WIDTH self.frame.size.width

@implementation screeningFirstView

/*
// Only override drawRect: if you perform custom drawing.
// An empty implementation adversely affects performance during animation.
- (void)drawRect:(CGRect)rect {
    // Drawing code
}
*/



- (void)awakeFromNib
{
    [self uiConfigAction];
}

#pragma mark -更新
- (void)setDatasArray:(NSArray *)datasArray
{
    _datasArray = datasArray;
    [self.classificationCollectionView reloadData];
}





#pragma mark -UI
- (void)uiConfigAction
{
    
    self.classificationLayout.itemSize = CGSizeMake((WIDTH-120)/4, 35);
    self.classificationLayout.minimumLineSpacing = 30;
    self.classificationLayout.minimumInteritemSpacing = 10;
    self.classificationLayout.sectionInset = UIEdgeInsetsMake(20, 20, 20, 20);
    [self.classificationCollectionView registerClass:[ScreeningFirstCollectionViewCell class] forCellWithReuseIdentifier:@"cell"];
    //section
    [self.classificationCollectionView registerClass:[ScreeningCollectionReusableView class] forSupplementaryViewOfKind:UICollectionElementKindSectionHeader withReuseIdentifier:@"Sectioncell"];
    self.classificationCollectionView.dataSource = self;
    self.classificationCollectionView.delegate = self;
    self.classificationCollectionView.alwaysBounceVertical = YES;
    
    
}


- (UICollectionViewCell *)collectionView:(UICollectionView *)collectionView cellForItemAtIndexPath:(NSIndexPath *)indexPath
{
    ScreeningFirstCollectionViewCell *cell = [collectionView dequeueReusableCellWithReuseIdentifier:@"cell" forIndexPath:indexPath];
    if (self.selectedIndex == 1) {
        
        cell.titleLabe.text = [[[[self.datasArray objectAtIndex_opple:indexPath.section] children] objectAtIndex_opple:indexPath.row] name];
    }
    else
    {
        cell.titleLabe.text = [[self.datasArray objectAtIndex_opple:indexPath.row] typename];
    }
    
    return cell;
}




- (NSInteger)collectionView:(UICollectionView *)collectionView numberOfItemsInSection:(NSInteger)section
{
    if (self.selectedIndex == 1) {
        
        return [[[self.datasArray objectAtIndex_opple:section] children] count];
        
    }
    return self.datasArray.count;
}

- (void)collectionView:(UICollectionView *)collectionView didSelectItemAtIndexPath:(NSIndexPath *)indexPath
{
    if ([self.delegate respondsToSelector:@selector(selectedItem:)]) {
        
        if (self.selectedIndex == 1 ) {
            
            [self.delegate selectedItem:[[[self.datasArray objectAtIndex_opple:indexPath.section] children][indexPath.row] fid]];
            
        }else
        {
            [self.delegate selectedItem:[[self.datasArray objectAtIndex_opple:indexPath.row] typecode]];
        }
        
    }
}

- (NSInteger)numberOfSectionsInCollectionView:(UICollectionView *)collectionView
{
    if (self.selectedIndex == 1) {
        
      return  self.datasArray.count;
    }
    return 1;
}

- (CGSize)collectionView:(UICollectionView *)collectionView layout:(UICollectionViewLayout*)collectionViewLayout referenceSizeForHeaderInSection:(NSInteger)section{
    
    if (self.selectedIndex == 1) {
        
       return CGSizeMake(200, 75);
    }
    return CGSizeMake(0, 0);
}


- (UICollectionReusableView *)collectionView:(UICollectionView *)collectionView viewForSupplementaryElementOfKind:(NSString *)kind atIndexPath:(NSIndexPath *)indexPath
{
    
    ScreeningCollectionReusableView *sectionView = [collectionView dequeueReusableSupplementaryViewOfKind:UICollectionElementKindSectionHeader withReuseIdentifier:@"Sectioncell" forIndexPath:indexPath];
    sectionView.sectionLabe.text = [[self.datasArray objectAtIndex_opple:indexPath.section] name];
    return sectionView;
}






@end
