//
//  Toolview.m
//  Lighting
//
//  Created by 曹云霄 on 16/4/27.
//  Copyright © 2016年 上海勾芒科技有限公司. All rights reserved.
//

#import "Toolview.h"
#import "CustomButton.h"
#import "UserViewController.h"

#define ButtonWIDTH 80 //按钮宽度
#define Buttoninterval 20//按钮间隔
#define ButtonRIGHT 54//按钮高度


@implementation Toolview

/*
// Only override drawRect: if you perform custom drawing.
// An empty implementation adversely affects performance during animation.
- (void)drawRect:(CGRect)rect {
    // Drawing code
}
*/

- (instancetype)initWithFrame:(CGRect)frame
{
    if (self = [super initWithFrame:frame]) {
      
        self.backgroundColor = kTCColor(255, 255, 255);
        [self uiConfigAction];
    }
    return self;
}



#pragma mark -布局
- (void)uiConfigAction
{
    //阴影
    self.layer.shadowColor = [UIColor blackColor].CGColor;
    self.layer.shadowRadius = 4;
    self.layer.shadowOpacity = 0.5;
    self.layer.shadowOffset = CGSizeMake(0,0);

    //图标
    UIImageView *iconImage = [[UIImageView alloc]initWithFrame:CGRectMake(50, 10, 100, 45)];
    iconImage.image = TCImage(@"weibo");
    [self addSubview:iconImage];
    
    //输入框背景
    UIView *backView = [[UIView alloc]initWithFrame:CGRectMake(200, (NavigationHeight-35)/2, 220, 35)];
    backView.backgroundColor = kTCColor(242, 242, 242);
    backView.layer.masksToBounds = YES;;
    backView.layer.cornerRadius = kCornerRadius;
    backView.layer.borderWidth = 1;
    backView.layer.borderColor = kTCColor(209, 209, 209).CGColor;
    [self addSubview:backView];

    //搜索图标
    UIImageView *imageview = [[UIImageView alloc]initWithFrame:CGRectMake(10, 7.5, 20, 20)];
    imageview.image = TCImage(@"search");
    [backView addSubview:imageview];
    
    
    //输入框
    UITextField *inputField = [[UITextField alloc]initWithFrame:CGRectMake(45, 0, 170, 35)];
    inputField.borderStyle = UITextBorderStyleNone;
    inputField.placeholder = @"请输入关键字";
    inputField.font = [UIFont systemFontOfSize:12];
    [backView addSubview:inputField];
    
    
    //扫描二维码
    UIButton *button = [UIButton buttonWithType:UIButtonTypeCustom];
    button.frame = CGRectMake(backView.frame.size.width+backView.frame.origin.x+15, (NavigationHeight-20)/2, 25, 20);
    [button setBackgroundImage:TCImage(@"圆角矩形-3") forState:UIControlStateNormal];
    [button addTarget:self action:@selector(QrCodeButtonClickAction) forControlEvents:UIControlEventTouchUpInside];
    [self addSubview:button];
    

    //按钮
    NSArray *titleArray = [NSArray arrayWithObjects:@"右视图",@"某某用户",@"我的客户",@"购物车", nil];
    //图片
    NSArray *imageArray = [NSArray arrayWithObjects:@"dial",@"Cog",@"data",@"ablum", nil];
    for (int i=1; i<5; i++) {
        
        CustomButton *button = [CustomButton buttonWithType:UIButtonTypeCustom];
        button.frame = CGRectMake(ScreenWidth-(i*ButtonWIDTH + Buttoninterval*(i-1)), 10, ButtonWIDTH, ButtonRIGHT);
        [button setTitleColor:kMainBlueColor forState:UIControlStateNormal];
        [button setTitle:[titleArray objectAtIndex_opple:i-1] forState:UIControlStateNormal];
        button.tag = 100+i-1;
        [button addTarget:self action:@selector(ButtonClick:) forControlEvents:UIControlEventTouchUpInside];
        if (i == 4) {
          button.instructionsNumber = i;
        }
        [button setImage:TCImage([imageArray objectAtIndex_opple:i-1]) forState:UIControlStateNormal];
        [self addSubview:button];
    }
    
//    //创建下划线
//    CustomButton *button = (CustomButton *)[self viewWithTag:102];
//    self.underlineView = [[UIView alloc]initWithFrame:CGRectMake(button.frame.origin.x+(ButtonWIDTH-50)/2, ButtonRIGHT+9, 50, 1)];
//    _underlineView.backgroundColor = [UIColor redColor];
//    [self addSubview:self.underlineView];
    
}


#pragma mark -二维码扫描码
- (void)QrCodeButtonClickAction
{
    if ([self.delegate respondsToSelector:@selector(QrcodeButtonClick)]) {
        
        [self.delegate QrcodeButtonClick];
    }
}

#pragma mark -按钮事件响应
- (void)ButtonClick:(UIButton *)button
{
//    //下划线动画
//    [UIView animateWithDuration:0.2 animations:^{
//        
//        CGRect frame = self.underlineView.frame;
//        frame.origin.x = button.frame.origin.x+(ButtonWIDTH-50)/2;
//        self.underlineView.frame = frame;
//    }];
    

    
    //点击代理
    if ([self.delegate respondsToSelector:@selector(ButtonClickAction:withButton:)]) {
        
        [self.delegate ButtonClickAction:button.tag withButton:button];
    }
}




@end
