//
//  ProductLibraryViewController.m
//  Lighting
//
//  Created by 曹云霄 on 16/5/4.
//  Copyright © 2016年 上海勾芒科技有限公司. All rights reserved.
//

#import "ProductLibraryViewController.h"
#import "ProductCollectionViewCell.h"
#import "ProductDetailsViewController.h"
#import "ScreeningView.h"
#import "screeningFirstView.h"
#import "screeningSecondView.h"


@interface ProductLibraryViewController ()<UICollectionViewDelegate,UICollectionViewDataSource,UIGestureRecognizerDelegate,ScreeningButtonClickdelegate,TableviewSelectedIndexdelegate,SelectedCollectionItemDelegate>

/**
 *  筛选背景框View
 */
@property (nonatomic,strong) ScreeningView *screenView;


/**
 *  分类View
 */
@property (nonatomic,strong) screeningFirstView *screenFirstView;

/**
 *  筛选View
 */
@property (nonatomic,strong) screeningSecondView *screenSecondView;

/**
 *  筛选数据源
 */
@property (nonatomic,strong) NSMutableArray *screeningDatas;

/**
 *  当前筛选按钮选中状态
 */
@property (nonatomic,assign) NSInteger selectedIndex;

/**
 *  商品数据源对象
 */
@property (nonatomic,strong) GoodsResponse *datasArray;

/**
 *  复选返回时临时保存数据
 */
@property (nonatomic,strong) GoodsResponse *temporaryArray;

@end

@implementation ProductLibraryViewController

/**
 *  初始化筛选数据源
 */
- (NSMutableArray *)screeningDatas
{
    if (_screeningDatas == nil) {
        
        _screeningDatas = [NSMutableArray array];
    }
    return _screeningDatas;
}


- (void)viewWillAppear:(BOOL)animated
{
    if (self.productCollectionView != nil) {
        
        [self getGoodsListDatas];
    }
}

- (void)viewDidLoad {
    [super viewDidLoad];
    // Do any additional setup after loading the view.
    self.view.backgroundColor = [UIColor blueColor];
    
    [self uiConfigAction];
    [self getScreeningdatas];
}


#pragma mark -获取商品列表数据
- (void)getGoodsListDatas
{
    
    //默认数据
    GoodsCondition *conditon = [[GoodsCondition alloc]init];
    //分页数据
    DataPage *Newpage = [[DataPage alloc]init];
    Newpage.page = 0;
    conditon.page = Newpage;
    
    __weak typeof(self)weakSelf = self;
    [self getGoodsListdatas:conditon returnResponse:^(GoodsResponse *response) {
        
        if (response.goodsEntity.count == 0) {
            
            [self ErrorMBProgressView:@"暂无数据"];
            return ;
        }
        weakSelf.datasArray = response;
        [weakSelf.productCollectionView reloadData];
    }];
}

#pragma mark -获取产品筛选数据
- (void)getScreeningdatas
{
    
    
  [[NetworkRequestClassManager Manager] NetworkWithDictionaryRequestWithURL:[NSString stringWithFormat:@"%@%@",ServerAddress,@"/goods/getGoodsFilter"] WithRequestType:1 WithParameter:nil WithReturnValueBlock:^(id returnValue) {
      
      if ([returnValue[@"code"] isEqualToNumber:@0]) {
          
          GoodsFilter *goodsStyle = [[GoodsFilter alloc]initWithDictionary:returnValue[@"data"] error:nil];
          [self.screeningDatas addObject:goodsStyle.styles];
          [self.screeningDatas addObject:goodsStyle.categories];
          [self.screeningDatas addObject:goodsStyle.space];
          [self.screeningDatas addObject:goodsStyle.material];
          [self.screeningDatas addObject:goodsStyle.price];
    
//          NSLog(@"%@",self.screeningDatas);
      }
      else
      {
          [self ErrorMBProgressView:returnValue[@"message"]];
      }
      
  } WithErrorCodeBlock:^(id errorCodeValue) {
      
  } WithFailureBlock:^(id error) {
      
      NSLog(@"%@",error);
      
  }];
}

/*

{
    code = 0;
    data =     {
        categories =         (
                              {
                                  children =                 (
                                                              {
                                                                  children =                         (
                                                                  );
                                                                  id = 0b44439e54997ce201549986e02c0003;
                                                                  name = "\U5927\U706f";
                                                              },
                                                              {
                                                                  children =                         (
                                                                  );
                                                                  id = 0b44439e54997ce201549987c8550004;
                                                                  name = "\U5eca\U706f";
                                                              }
                                                              );
                                  id = 0b44439e54997ce20154998630210002;
                                  name = "\U73b0\U4ee3\U706f";
                              },
                              {
                                  children =                 (
                                                              {
                                                                  children =                         (
                                                                  );
                                                                  id = 0b44439e54997ce20154998a59450006;
                                                                  name = "\U53a8\U623f\U706f";
                                                              }
                                                              );
                                  id = 0b44439e54997ce201549989c8b10005;
                                  name = "\U7167\U660e\U706f";
                              }
                              );
        material =         (
                            {
                                typecode = 001;
                                typename = "\U91d1";
                            },
                            {
                                typecode = 002;
                                typename = "\U94f6";
                            },
                            {
                                typecode = 003;
                                typename = "\U6728\U8d28";
                            }
                            );
        price =         (
                         {
                             typecode = 001;
                             typename = "500\U4ee5\U4e0b";
                         },
                         {
                             typecode = 002;
                             typename = "500\U52301000";
                         },
                         {
                             typecode = 003;
                             typename = "1000\U52302000";
                         }
                         );
        space =         (
                         {
                             typecode = 001;
                             typename = "15\U5e73\U7c73";
                         },
                         {
                             typecode = 002;
                             typename = "20\U5e73\U7c73";
                         },
                         {
                             typecode = 003;
                             typename = "35\U5e73\U7c73";
                         }
                         );
        styles =         (
                          {
                              typecode = 001;
                              typename = "\U4e2d\U56fd\U98ce";
                          },
                          {
                              typecode = 002;
                              typename = "\U82f1\U56fd\U98ce";
                          }
                          );
    };
    message = "\U64cd\U4f5c\U6210\U529f";
}

*/


#pragma mark -获取商品列表数据
- (void)getGoodsListdatas:(GoodsCondition *)conditon returnResponse:(void(^)(GoodsResponse *))finish
{
   
    [self CreateMBProgressHUDLoding];
    [[NetworkRequestClassManager Manager] NetworkRequestWithURL:[NSString stringWithFormat:@"%@%@",ServerAddress,@"/goods/query"] WithRequestType:0 WithParameter:conditon WithReturnValueBlock:^(id returnValue) {
        
        [self RemoveMBProgressHUDLoding];
        if ([returnValue[@"code"] isEqualToNumber:@0]) {
            
            GoodsResponse *sponse = [[GoodsResponse alloc]initWithDictionary:returnValue[@"data"] error:nil];
            //返回结果
            finish(sponse);
        }
        else
        {
           [self ErrorMBProgressView:returnValue[@"message"]];
        }
        
    } WithErrorCodeBlock:^(id errorCodeValue) {
        
        
        
    } WithFailureBlock:^(id error) {
        
        [self RemoveMBProgressHUDLoding];
    }];
}


#pragma mark -布局
- (void)uiConfigAction
{
    
    self.productCollectionLayout.itemSize = CGSizeMake((ScreenWidth-100)/3, (ScreenWidth-100)/3);
    self.productCollectionLayout.sectionInset = UIEdgeInsetsMake(20, 30, 20, 30);
    self.productCollectionLayout.minimumLineSpacing = 20;
    self.productCollectionLayout.minimumInteritemSpacing = 20;
    self.productCollectionView.dataSource = self;
    self.productCollectionView.delegate = self;
    self.productCollectionView.alwaysBounceVertical = YES;
    [self CreatescreeningButton];
    
}



#pragma mark -筛选按钮
- (void)CreatescreeningButton
{
    UIButton *screeningbutton = [UIButton buttonWithType:UIButtonTypeSystem];
    screeningbutton.frame = CGRectMake(ScreenWidth-100, ScreenHeight*6/10, 50, 50);
    
    //阴影层
    CALayer *layer = [CALayer layer];
    layer.frame = CGRectMake(ScreenWidth-97.5, ScreenHeight*6/10+2.5, 45, 45);//保证layer的size比筛选按钮高宽都短5像素
    layer.backgroundColor = [UIColor blackColor].CGColor;
    layer.shadowOffset = CGSizeMake(0, 8);
    layer.shadowOpacity = 0.7;
    layer.cornerRadius = 25;
    [self.view.layer addSublayer:layer];
    
    //筛选按钮
    screeningbutton.layer.masksToBounds = YES;
    screeningbutton.layer.cornerRadius = 25;
    [screeningbutton setTitle:@"筛选" forState:UIControlStateNormal];
    screeningbutton.titleLabel.font = [UIFont systemFontOfSize:15];
    [screeningbutton setTitleColor:[UIColor whiteColor] forState:UIControlStateNormal];
    [screeningbutton setTitleColor:kMainBlueColor forState:UIControlStateSelected];
    [screeningbutton addTarget:self action:@selector(ScreeningButtonClick) forControlEvents:UIControlEventTouchUpInside];
    screeningbutton.backgroundColor = kMainBlueColor;
    [self.view addSubview:screeningbutton];
    
}


- (UICollectionViewCell *)collectionView:(UICollectionView *)collectionView cellForItemAtIndexPath:(NSIndexPath *)indexPath
{
    ProductCollectionViewCell *cell = [collectionView dequeueReusableCellWithReuseIdentifier:@"productcell" forIndexPath:indexPath];
    NSURL *url = [NSURL URLWithString:[NSString stringWithFormat:@"%@/%@",ServerAddress,[[self.datasArray.goodsEntity objectAtIndex_opple:indexPath.row] pictures]]];
    [cell.productImageView sd_setImageWithURL:url placeholderImage:nil];
    
    
    return cell;
}

- (NSInteger)collectionView:(UICollectionView *)collectionView numberOfItemsInSection:(NSInteger)section
{
    return self.datasArray.goodsEntity.count;
}

- (void)collectionView:(UICollectionView *)collectionView didSelectItemAtIndexPath:(NSIndexPath *)indexPath
{
    
    UIStoryboard *storyboard = [UIStoryboard storyboardWithName:@"StoryboardwithCYX" bundle:nil];
    ProductDetailsViewController *productDetails = [storyboard instantiateViewControllerWithIdentifier:@"productdetails"];
    [self.navigationController pushViewController:productDetails animated:YES];
}


#pragma mark -筛选
- (void)ScreeningButtonClick
{
    self.screenView = [[[NSBundle mainBundle] loadNibNamed:@"ScreeningView" owner:self options:nil]firstObject];
    self.screenView.frame = CGRectMake(0, 0, ScreenWidth, ScreenHeight);
    self.screenView.backgroundColor = [[UIColor blackColor] colorWithAlphaComponent:0.5];
    self.screenView.delegate = self;
    //点击手势
    UITapGestureRecognizer *tap = [[UITapGestureRecognizer alloc]initWithTarget:self action:@selector(DismissScreenView)];
    tap.delegate = self;
    tap.cancelsTouchesInView = NO;
    [self.screenView addGestureRecognizer:tap];
    self.screenView.frame = CGRectMake(0, 0, ScreenWidth, ScreenHeight);
    [self.view.window addSubview:self.screenView];
    self.screenView.alpha = 0;
    
    //监听Segmented菜单
    [self.screenView.sortingSegmented addTarget:self action:@selector(sortingSegmentedClick:) forControlEvents:UIControlEventValueChanged];
    
    [self CreateClassificationView];
    
    [UIView animateWithDuration:0.2 animations:^{
        
        self.screenView.alpha = 1;
    }];
}


#pragma mark -分类、筛选view切换
- (void)sortingSegmentedClick:(UISegmentedControl *)sender {
    
    switch (sender.selectedSegmentIndex) {
        case 0://分类
        {
            NSLog(@"分类");
            [self.screenSecondView removeFromSuperview];
            [self CreateClassificationView];
        }
            break;
        case 1://筛选
        {
            NSLog(@"筛选");
            [self.screenFirstView removeFromSuperview];
            [self CreateScreenSubView];
        }
            break;
            
        default:
            break;
    }
}

#pragma mark -创建分类View
- (void)CreateClassificationView
{
    //分类View
    self.screenFirstView = [[[NSBundle mainBundle] loadNibNamed:@"screeningFirstView" owner:self options:nil] firstObject];
    self.screenFirstView.frame = CGRectMake(0, 50, 470, 310);
    self.screenFirstView.delegate = self;
     [self screeningButtonClick:self.selectedIndex];
    [self.screenView.backgroundView addSubview:self.screenFirstView];
}


#pragma mark -创建筛选选项View
- (void)CreateScreenSubView
{
    self.screenSecondView = [[[NSBundle mainBundle] loadNibNamed:@"screeningSecondView" owner:self options:nil] firstObject];
    self.screenSecondView.frame = CGRectMake(0, 50, 470, 310);
    self.screenSecondView.delegate = self;
    [self screeningButtonClick:self.selectedIndex];
    self.screenSecondView.totalNumber = self.datasArray.total;
    [self.screenView.backgroundView addSubview:self.screenSecondView];
}



#pragma mark -ScreeningButtonClickdelegate代理
- (void)screeningButtonClick:(NSInteger)buttontag
{
    self.selectedIndex = buttontag;
    //分类
    if (self.screenView.sortingSegmented.selectedSegmentIndex == 0) {
        
        self.screenFirstView.selectedIndex = buttontag;
        self.screenFirstView.datasArray = [self.screeningDatas objectAtIndex_opple:buttontag];
    }
    //筛选
    else if (self.screenView.sortingSegmented.selectedSegmentIndex == 1)
    {
        self.screenSecondView.selectedIndex = buttontag;
        self.screenSecondView.datasArray = [self.screeningDatas objectAtIndex_opple:buttontag];
    }
}

#pragma mark -选中条件
- (void)selectedItem:(NSString *)typecode
{
    [self DismissScreenView];
    GoodsCondition *condition = [[GoodsCondition alloc]init];
    DataPage *page = [[DataPage alloc]init];
    page.page = 0;
    condition.page = page;
    condition.categoryEquals = typecode;
    //分类模块筛选
    __weak typeof(self)Weakself = self;
    [self getGoodsListdatas:condition returnResponse:^(GoodsResponse *response) {
        
        
        Weakself.datasArray = response;
        [Weakself.productCollectionView reloadData];
        if (response.goodsEntity.count == 0) {
            
            [self ErrorMBProgressView:@"暂无数据"];
        }
    }];
}




#pragma mark -筛选子模块的
- (void)tableSelectedindex:(NSInteger)index
{
    
    [self screeningButtonClick:index];
    self.screenView.indexselected = index;
    
}


#pragma mark -筛选复选模块选中的uicollection cell
- (void)collectionSelectedindexWithStyleCode:(NSString *)styleCode
                              withCategories:(NSString *)categoriesCode
                                   withSpace:(NSString *)spaceCode
                                withMaterial:(NSString *)materialCode
                                   withPrice:(NSString *)priceTitle
{
    
    GoodsCondition *condition = [[GoodsCondition alloc]init];
    DataPage *page = [[DataPage alloc]init];
    page.page = 0;
    condition.page = page;
    condition.styleEquals = styleCode;
    condition.categoryEquals = categoriesCode;
    condition.spaceEquals = spaceCode;
    condition.materialEqueals = materialCode;

    if (![priceTitle isEqualToString:@"全部"]) {
     
        //价格字符串切割
        NSArray *spacrArray = [priceTitle componentsSeparatedByString:@"到"];
        condition.startprice = [NSNumber numberWithInteger:[[spacrArray objectAtIndex_opple:0] integerValue]];
        condition.endprice = [NSNumber numberWithInteger:[[spacrArray objectAtIndex_opple:1] integerValue]];
    }

    
    __weak typeof (self) Weakself = self;
//    NSLog(@"%@",[condition toDictionary]);
    [self getGoodsListdatas:condition returnResponse:^(GoodsResponse *response) {
        
        Weakself.screenSecondView.totalNumber = response.total;
        //临时保存
        self.temporaryArray = response;
    }];
}


#pragma mark -显示筛选后的结果
- (void)ShowScreeningResponse
{
    if (self.temporaryArray.goodsEntity.count == 0) {
        
        [self ErrorMBProgressView:@"暂无数据"];
        return;
    }
    self.datasArray = self.temporaryArray;
    [self.productCollectionView reloadData];
    [self DismissScreenView];
}


#pragma mark -移除筛选框
- (void)DismissScreenView
{
    [UIView animateWithDuration:0.2 animations:^{
        
        self.screenView.alpha = 0;
        
    }completion:^(BOOL finished) {
        
        [self.screenView removeFromSuperview];
        
    }];
}


#pragma mark -UIGestureRecognizerDelegate代理方法
- (BOOL)gestureRecognizer:(UIGestureRecognizer *)gestureRecognizer shouldReceiveTouch:(UITouch *)touch
{
    //取消子视图的的时间穿透，否则子视图的点击无效，会被传递到父视图响应
    if (CGRectContainsPoint(self.screenView.backgroundView.frame, [touch locationInView:self.screenView])) {
        
        return NO;
    }
    return YES;
}


- (void)didReceiveMemoryWarning {
    [super didReceiveMemoryWarning];
    // Dispose of any resources that can be recreated.
}

/*
#pragma mark - Navigation

// In a storyboard-based application, you will often want to do a little preparation before navigation
- (void)prepareForSegue:(UIStoryboardSegue *)segue sender:(id)sender {
    // Get the new view controller using [segue destinationViewController].
    // Pass the selected object to the new view controller.
}
*/

@end
