//
//  FootSubView.m
//  Lighting
//
//  Created by mac on 16/5/10.
//  Copyright © 2016年 上海勾芒科技有限公司. All rights reserved.
//

#import "FootSubView.h"

@implementation FootSubView
- (instancetype)initWithFrame:(CGRect)frame
{
    if (self = [super initWithFrame:frame]) {
    
        [self initdata];
        [self initSubView];
    }
    return self;
}

-(void)initdata
{
    self.dataArray=[[NSMutableArray alloc]initWithObjects:@"1",@"2",@"3",nil];
    //    待接收
}
-(void)initSubView
{
    UIButton *button=[UIButton buttonWithType:UIButtonTypeCustom];
    button.frame=CGRectMake(30, 50, 60, 60);
    [button setBackgroundImage:[UIImage imageNamed:@"场景"] forState:UIControlStateNormal];
    button.tag=200;
    [button addTarget:self action:@selector(footBtnDidSelected:) forControlEvents:UIControlEventTouchUpInside];
    [self addSubview:button];
    self.scrollView=[[UIScrollView alloc]initWithFrame:CGRectMake(100, 0, self.frame.size.width-100, self.frame.size.height)];
    // contentSize的y值为0表示在垂直方向上不做滚动
    self.scrollView.contentSize = CGSizeMake((self.dataArray.count+1) * (100+10), 0);
    for (int i=0; i<self.dataArray.count; i++) {
        UIImageView *imageView = [[UIImageView alloc] init];
        // 定义图片名，通过循环把所有的图片添加到scrollView中
        NSString *imageName = [NSString stringWithFormat:@"backView" ];
        imageView.frame = CGRectMake(i*(100+10), 30, 100, 100);
        imageView.image = [UIImage imageNamed:imageName];
        [self.scrollView addSubview:imageView];
    }
    // 禁用滚动条，只设置水平方向的滚动条即可，竖直方向的滚动范围是0，所以没必要设置
    self.scrollView.showsHorizontalScrollIndicator = NO;
    [self addSubview:self.scrollView];
    
}
-(void)footBtnDidSelected:(UIButton *)sender
{
    if ([self.delegate respondsToSelector:@selector(buttonClick:withButton:)]) {
        
        [self.delegate buttonClick:sender.tag withButton:sender];
    }

}
/*
// Only override drawRect: if you perform custom drawing.
// An empty implementation adversely affects performance during animation.
- (void)drawRect:(CGRect)rect {
    // Drawing code
}
*/

@end
