//
//  CustomButton.m
//  Lighting
//
//  Created by 曹云霄 on 16/4/27.
//  Copyright © 2016年 上海勾芒科技有限公司. All rights reserved.
//

#import "CustomButton.h"
#import "instructionsLabe.h"
#define WIDTH self.frame.size.width


@implementation CustomButton


/*
// Only override drawRect: if you perform custom drawing.
// An empty implementation adversely affects performance during animation.
- (void)drawRect:(CGRect)rect {
    // Drawing code
}
*/



- (instancetype)initWithFrame:(CGRect)frame
{
    if (self = [super initWithFrame:frame]) {
        
        self.titleLabel.font = [UIFont systemFontOfSize:11];
        self.titleLabel.textAlignment = NSTextAlignmentCenter;
        
    }
    return self;
}


- (void)setInstructionsNumber:(NSInteger)instructionsNumber
{
    _instructionsNumber = instructionsNumber;
    for (UIView *subview in self.subviews) {
        
        if ([subview isKindOfClass:[instructionsLabe class]]) {
            
            [subview removeFromSuperview];
            break;
        }
    }
    if (_instructionsNumber) {
        instructionsLabe *labe = [[instructionsLabe alloc]initWithFrame:CGRectMake(WIDTH-35, 0, 13, 13)];
        labe.instructionsNumber = _instructionsNumber;
        [self addSubview:labe];
    }
}



- (CGRect)imageRectForContentRect:(CGRect)contentRect
{
    return CGRectMake((WIDTH-25)/2, 0, 25, 25);
}

- (CGRect)titleRectForContentRect:(CGRect)contentRect
{
    return CGRectMake(0, 30, WIDTH, 20);
}







@end
