//
//  ProductLibraryView.m
//  Lighting
//
//  Created by mac on 16/5/11.
//  Copyright © 2016年 上海勾芒科技有限公司. All rights reserved.
//

#import "ProductLibraryView.h"


@implementation ProductLibraryView
/**
 *  初始化商品数据源数组
 */
- (NSMutableArray *)datasArray
{
    if (_datasArray == nil) {
        
        _datasArray = [NSMutableArray array];
    }
    return _datasArray;
}
/**
 *  初始化筛选数据源
 */
- (NSMutableArray *)arrayData
{
    if (_arrayData == nil) {
        
        _arrayData = [NSMutableArray array];
    }
    return _arrayData;
}

- (void)viewDidLoad {
    [self initdata];
    [self initSubView];
    [self uiConfigAction];

}

-(void)initdata
{
    self.arrayData=[[NSMutableArray alloc]init];
    self.nameData=[[NSMutableArray alloc]initWithObjects:@"风格",@"类型",@"空间",@"材质",@"价格",nil];
    self.indexPage = 0;
    
}
- (void)uiConfigAction
{
    //下拉刷新
    MjRefreshHeaderCustom *headerRefresh = [MjRefreshHeaderCustom headerWithRefreshingBlock:^{
        //默认数据
        GoodsCondition *conditon = [[GoodsCondition alloc]init];
        //分页数据
        DataPage *Newpage = [[DataPage alloc]init];
        Newpage.page = self.indexPage;
        Newpage.rows = 10;
        conditon.page = Newpage;
        //搜索
        if (_selectedCode) {
            conditon.categoryEquals = _selectedCode;
            conditon.nameLike = _selectedCode;
        }
        [self getScreeningdatasisRemoveArray:YES];
        [self getGoodsListDatasisRemove:YES Withobject:conditon];
    }];
    headerRefresh.stateLabel.hidden = YES;
    headerRefresh.lastUpdatedTimeLabel.hidden = YES;
    self.collectionView.mj_header = headerRefresh;
    [self.collectionView.mj_header beginRefreshing];

    //上拉加载
    self.collectionView.mj_footer = [MJRefreshAutoNormalFooter footerWithRefreshingBlock:^{
        
        //默认数据
        GoodsCondition *conditon = [[GoodsCondition alloc]init];
        //分页数据
        DataPage *Newpage = [[DataPage alloc]init];
        Newpage.page = self.indexPage ++;
        Newpage.rows = 10;
        conditon.page = Newpage;
        //搜索
        if (_selectedCode) {
            conditon.categoryEquals = _selectedCode;
            conditon.nameLike = _selectedCode;
        }
        [self getGoodsListDatasisRemove:YES Withobject:conditon];
    }];
    

}
//#pragma mark -热门搜索
//- (void)setSelectedCode:(NSString *)selectedCode
//{
//    _selectedCode = selectedCode;
//    //默认数据
//    GoodsCondition *conditon = [[GoodsCondition alloc]init];
//    //分页数据
//    DataPage *Newpage = [[DataPage alloc]init];
//    Newpage.page = 0;
//    conditon.page = Newpage;
//    conditon.categoryEquals = _selectedCode;
//
//    __weak typeof(self)weakSelf = self;
//    [self getGoodsListdatas:conditon returnResponse:^(GoodsResponse *response) {
//
//        if (response.goodsEntity.count == 0) {
//
//            [self ErrorMBProgressView:@"暂无数据"];
//        }else
//            {
//            weakSelf.datasArray = response;
//            [weakSelf.productCollectionView reloadData];
//            }
//    }];
//
//}

#pragma mark -获取商品列表数据
- (void)getGoodsListDatasisRemove:(BOOL)remove Withobject:(GoodsCondition *)conditon
{


    __weak typeof(self)weakSelf = self;
    [self getGoodsListdatas:conditon returnResponse:^(GoodsResponse *response) {
        if (response.goodsEntity.count == 0) {
            
            [self ErrorMBProgressView:@"暂无数据"];
            
        }else
        {
            if (remove) {
                [self.datasArray removeAllObjects];
            }
            for (TOGoodsEntity *model in response.goodsEntity) {
                [weakSelf.datasArray addObject:model];
            }
            [weakSelf.collectionView reloadData];
        }
    }];
}

#pragma mark -获取产品筛选数据
- (void)getScreeningdatasisRemoveArray:(BOOL)remove

{

    [[NetworkRequestClassManager Manager] NetworkWithDictionaryRequestWithURL:[NSString stringWithFormat:@"%@%@",ServerAddress,@"/goods/getGoodsFilter"] WithRequestType:1 WithParameter:nil WithReturnValueBlock:^(id returnValue) {

        if ([returnValue[@"code"] isEqualToNumber:@0]) {
            if (remove) {
                [self.arrayData removeAllObjects];
            }

            GoodsFilter *goodsStyle = [[GoodsFilter alloc]initWithDictionary:returnValue[@"data"] error:nil];
            self.goodsFilter=goodsStyle;
            self.arrayData=[NSMutableArray arrayWithArray:self.goodsFilter.styles];
            [self.seceneTableView reloadData];
        }
        else
            {
            [self ErrorMBProgressView:returnValue[@"message"]];
            }

    } WithErrorCodeBlock:^(id errorCodeValue) {

    } WithFailureBlock:^(id error) {

        NSLog(@"%@",error);
    }];
}



#pragma mark -获取商品列表数据
- (void)getGoodsListdatas:(GoodsCondition *)conditon returnResponse:(void(^)(GoodsResponse *))finish
{

    [self CreateMBProgressHUDLoding];
     [[NetworkRequestClassManager Manager] NetworkRequestWithURL:[NSString stringWithFormat:@"%@%@",ServerAddress,@"/goods/query"] WithRequestType:0 WithParameter:conditon WithReturnValueBlock:^(id returnValue) {

        [self RemoveMBProgressHUDLoding];
        [self endRefreshingForTableView:self.collectionView];
        if ([returnValue[@"code"] isEqualToNumber:@0]) {

            GoodsResponse *sponse = [[GoodsResponse alloc]initWithDictionary:returnValue[@"data"] error:nil];
            //返回结果
            finish(sponse);
        }
        else
            {
            [self ErrorMBProgressView:@"暂无数据"];
            }

    } WithErrorCodeBlock:^(id errorCodeValue) {

    } WithFailureBlock:^(id error) {
         [self endRefreshingForTableView:self.collectionView];
        [self RemoveMBProgressHUDLoding];
    }];
}
//#pragma mark -获取商品详情
//- (void)getGoodsListDetails
//
//{
//    [self CreateMBProgressHUDLoding];
//    NSString *url = [NSString stringWithFormat:@"%@%@%@",ServerAddress,@"/goods/getGoods/",_goodsID];
//    [[NetworkRequestClassManager Manager] NetworkWithDictionaryRequestWithURL:url WithRequestType:1 WithParameter:nil WithReturnValueBlock:^(id returnValue) {
//
//        [self RemoveMBProgressHUDLoding];
//        if ([returnValue[@"code"] isEqualToNumber:@0]) {
//
//            self.entity = [[TOGoodsEntity alloc]initWithDictionary:returnValue[@"data"] error:nil];
//            [self HeaderViewAssignment];
//            [self.productDetilsTableview reloadData];
//        }
//        else
//            {
//            [self ErrorMBProgressView:returnValue[@"message"]];
//            }
//
//
//
//    } WithErrorCodeBlock:^(id errorCodeValue) {
//
//
//    } WithFailureBlock:^(id error) {
//
//        [self RemoveMBProgressHUDLoding];
//        NSLog(@"%@",error);
//    }];
//}
-(void)initSubView
{
    for (int i=0; i<self.nameData.count; i++) {
        if (i !=5) {
            UIButton *btn=[UIButton buttonWithType:UIButtonTypeCustom];
            btn.frame=CGRectMake(ScreenWidth-250, 52+i*50, 100, 46) ;
            btn.backgroundColor=[UIColor whiteColor];
            [btn setTitle:[self.nameData objectAtIndex:i] forState:UIControlStateNormal];
             btn.contentEdgeInsets = UIEdgeInsetsMake(0, 40, 0, 0);
            [btn setTitleColor:[UIColor blackColor] forState:UIControlStateNormal];
            [btn addTarget:self action:@selector(selectedType:) forControlEvents:UIControlEventTouchUpInside];
            btn.tag=100 +i;
            btn.layer.masksToBounds = YES;
            btn.layer.cornerRadius = 25;
            [self.view addSubview:btn];
        }
       
    }
    self.subView=[[UIView alloc]initWithFrame:CGRectMake(100, 50, ScreenWidth-300, ScreenHeight-200)];
    self.subView.backgroundColor=[UIColor whiteColor];
    [self.view  addSubview:self.subView];

    //点击手势
    UITapGestureRecognizer *tap = [[UITapGestureRecognizer alloc]initWithTarget:self action:@selector(DismissScreenView:)];
    tap.delegate = self;
    tap.cancelsTouchesInView = NO;
    [[UIApplication sharedApplication].keyWindow addGestureRecognizer:tap];
    [self initSubViews];
   
    
}


-(void)initSubViews
{
    self.headerView=[[UIView alloc]initWithFrame:CGRectMake(0, 0, self.subView.frame.size.width-100, 50)];
    self.headerView.backgroundColor=[UIColor grayColor];
    [self.subView addSubview:self.headerView];
    UIButton *btn=[UIButton buttonWithType:UIButtonTypeCustom];
    btn.frame=CGRectMake(10, 10, 30, 30);
    [btn setBackgroundImage:[UIImage imageNamed:@"changjingtubiao"] forState:UIControlStateNormal];
    [self.headerView addSubview:btn];
    UILabel *lable=[[UILabel alloc]initWithFrame:CGRectMake(45, 10, 100, 30)];
    lable.text=@"选择产品";
    [self.headerView addSubview:lable];
    self.seceneTableView=[[UITableView alloc]initWithFrame:CGRectMake( self.headerView.frame.size.width, 0, 100, self.subView.frame.size.height)];
    self.seceneTableView.delegate=self;
    self.seceneTableView.dataSource=self;
    [self.subView addSubview:self.seceneTableView];
    
 
    //确定是水平滚动，还是垂直滚动
    UICollectionViewFlowLayout *flowLayout=[[UICollectionViewFlowLayout alloc] init];
    [flowLayout setScrollDirection:UICollectionViewScrollDirectionVertical];
    
    self.collectionView=[[UICollectionView alloc] initWithFrame:CGRectMake( 0, 50, self.headerView.frame.size.width, self.subView.frame.size.height-50) collectionViewLayout:flowLayout];
    self.collectionView.dataSource=self;
    self.collectionView.delegate=self;
    [self.collectionView setBackgroundColor:[UIColor clearColor]];
    
    //注册Cell，必须要有
    [self.collectionView registerClass:[ProductCollectionPictureCell class] forCellWithReuseIdentifier:@"UICollectionViewCell"];
    
    [self.subView addSubview:self.collectionView];
    
}
-(void)selectedType:(UIButton *)sender
{

            switch (sender.tag) {
                case 100:
                    //            风格
                    self.arrayData=[NSMutableArray arrayWithArray:self.goodsFilter.styles];
                    break;
                case 101:
                    //            类型
                    self.arrayData=[NSMutableArray arrayWithArray:self.goodsFilter.categories];
                    break;
                case 102:
                    //            空间
                    self.arrayData=[NSMutableArray arrayWithArray:self.goodsFilter.space];
                    break;
                case 103:
                    //            材质
                    self.arrayData=[NSMutableArray arrayWithArray:self.goodsFilter.material];
                    break;
                case 104:
                    //            价格
                    self.arrayData=[NSMutableArray arrayWithArray:self.goodsFilter.price];
                    break;
              
                default:
                    break;
            }
    [self.seceneTableView reloadData];
}
#pragma mark -- UICollectionViewDataSource
//定义展示的Section的个数
-(NSInteger)numberOfSectionsInCollectionView:(UICollectionView *)collectionView
{
    if (self.datasArray.count/3==0 && self.datasArray.count%3!=0 ) {
        return 1;
    }else
    {
        if (self.datasArray.count%3==0) {
            return self.datasArray.count/3;
        }else{
            return self.datasArray.count/3 +1;
        }
        
    }
}
//定义展示的UICollectionViewCell的个数
-(NSInteger)collectionView:(UICollectionView *)collectionView numberOfItemsInSection:(NSInteger)section
{
    if (self.datasArray.count<3) {
        return self.datasArray.count;
    }else
    {
        if (self.datasArray.count/section==0) {
            return 3;
        }else
        {
            return self.datasArray.count%section;
        }
    }
    
}

//每个UICollectionView展示的内容
-(UICollectionViewCell *)collectionView:(UICollectionView *)collectionView cellForItemAtIndexPath:(NSIndexPath *)indexPath
{
    static NSString * CellIdentifier = @"UICollectionViewCell";
    ProductCollectionPictureCell * cell = (ProductCollectionPictureCell*)[collectionView dequeueReusableCellWithReuseIdentifier:CellIdentifier forIndexPath:indexPath];
    NSArray *imageArray = [[[self.datasArray objectAtIndex_opple:indexPath.item] pictures] componentsSeparatedByString:@","];
    [cell.productImageView sd_setImageWithURL:[NSURL URLWithString:[imageArray objectAtIndex:indexPath.row]] placeholderImage:REPLACEIMAGE];
    cell.productPrice.text = [NSString stringWithFormat:@"￥%@",[[[self.datasArray objectAtIndex_opple:indexPath.item] guidePrice] stringValue]];
    cell.productParameter.text=[NSString stringWithFormat:@"%@ %@ %@",[[self.datasArray objectAtIndex_opple:indexPath.item]keyword],[[self.datasArray objectAtIndex_opple:indexPath.item]productProfile],[[self.datasArray objectAtIndex_opple:indexPath.item]power]];
    cell.productModel=[self.datasArray objectAtIndex_opple:indexPath.item];

    return cell;
}
#pragma mark --UICollectionViewDelegateFlowLayout
//定义每个Item 的大小
- (CGSize)collectionView:(UICollectionView *)collectionView layout:(UICollectionViewLayout*)collectionViewLayout sizeForItemAtIndexPath:(NSIndexPath *)indexPath
{
    return CGSizeMake(190, 150);
}

//定义每个UICollectionView 的边距
-(UIEdgeInsets)collectionView:(UICollectionView *)collectionView layout:(UICollectionViewLayout *)collectionViewLayout insetForSectionAtIndex:(NSInteger)section
{
    return UIEdgeInsetsMake(10, 10, 0, 20);
}
//定义每个UICollectionView 的纵向间距
-(CGFloat)collectionView:(UICollectionView *)collectionView layout:(UICollectionViewLayout *)collectionViewLayout minimumInteritemSpacingForSectionAtIndex:(NSInteger)section{
    return 2;
}

#pragma mark --UICollectionViewDelegate

//UICollectionView被选中时调用的方法
-(void)collectionView:(UICollectionView *)collectionView didSelectItemAtIndexPath:(NSIndexPath *)indexPath
{
    ProductCollectionPictureCell * cell = (ProductCollectionPictureCell *)[collectionView cellForItemAtIndexPath:indexPath];
    if ([self.delegate respondsToSelector:@selector(addProductImage:productModel:)]) {
        
        [self.delegate addProductImage:cell.productImageView.image productModel:cell.productModel];
    }

}

//返回这个UICollectionView是否可以被选择
-(BOOL)collectionView:(UICollectionView *)collectionView shouldSelectItemAtIndexPath:(NSIndexPath *)indexPath
{
    return YES;
}

#pragma mark - 协议方法
- (NSInteger)numberOfSectionsInTableView:(UITableView *)tableView {
    return 1;
}
- (NSInteger)tableView:(UITableView *)tableView numberOfRowsInSection:(NSInteger)section
{    if ([tableView isEqual:self.seceneTableView])
{
    return self.arrayData.count;
}else
{
    return 5;
}
    
}
- (CGFloat)tableView:(UITableView *)tableView heightForRowAtIndexPath:(NSIndexPath *)indexPath
{
    if ([tableView isEqual:self.seceneTableView])
    {
        return 50;
    }else
    {
        return 150;
    }
    
    
}


- (UITableViewCell *)tableView:(UITableView *)tableView cellForRowAtIndexPath:(NSIndexPath *)indexPath
{
           static NSString *cellID = @"ChooseTansferCell";
        UITableViewCell *cell = [tableView dequeueReusableCellWithIdentifier:cellID];
        if (cell == nil) {
            cell = [[UITableViewCell alloc]initWithStyle:UITableViewCellStyleDefault reuseIdentifier:cellID];
         
        }
    if ([[self.arrayData objectAtIndex_opple:indexPath.row]isKindOfClass:[GoodsCategory class]]) {
        cell.textLabel.text=[[self.arrayData objectAtIndex_opple:indexPath.row] name];
    }else
    {//类型是多级的这里要改动
        cell.textLabel.text=[[self.arrayData objectAtIndex_opple:indexPath.row] typename];
    }
    
//        05产品库-详情_03
        return cell;
        
}

- (void)tableView:(UITableView *)tableView didSelectRowAtIndexPath:(NSIndexPath *)indexPath
{
    self.indexPage=0;
    //默认数据
    GoodsCondition *conditon = [[GoodsCondition alloc]init];
    //分页数据
    DataPage *Newpage = [[DataPage alloc]init];
    Newpage.page = self.indexPage;
    Newpage.rows = 0;
    conditon.page = Newpage;
    [self getGoodsListDatasisRemove:YES Withobject:conditon];
    
}

-(void)DismissScreenView:(UITapGestureRecognizer*)sender{
    CGPoint point = [sender locationInView:self.view];
    if (point.x<100 || point.x >ScreenWidth-150||point.y<50||point.y>ScreenHeight-150) {
        
        if (self) {
            [self.view removeFromSuperview];
        }
    }
}

/*
// Only override drawRect: if you perform custom drawing.
// An empty implementation adversely affects performance during animation.
- (void)drawRect:(CGRect)rect {
    // Drawing code
}
*/

@end
