//
//  screeningSecondView.m
//  Lighting
//
//  Created by 曹云霄 on 16/5/8.
//  Copyright © 2016年 上海勾芒科技有限公司. All rights reserved.
//

#import "screeningSecondView.h"
#import "ScreeningFirstCollectionViewCell.h"
#import "ScreeningSecondCollectionReusableView.h"


#define WIDTH self.screeningCollectionView.frame.size.width

@implementation screeningSecondView

/*
// Only override drawRect: if you perform custom drawing.
// An empty implementation adversely affects performance during animation.
- (void)drawRect:(CGRect)rect {
    // Drawing code
}
*/




- (void)awakeFromNib
{
//    [self uiConfigAction];
    self.defaultDatasArray = [NSMutableArray array];
    for (int i=0; i<5; i++) {
        
        NSDictionary *defaultDict = @{@"typecode":@"",@"typename":@"全部"};
        [self.defaultDatasArray addObject:defaultDict];
    }
    [self uiConfigAction];
}


#pragma mark -获取数据
- (void)setDatasArray:(NSArray *)datasArray
{
    _datasArray = datasArray;
    [self.screeningCollectionView reloadData];
}


#pragma mark - 布局
- (void)uiConfigAction
{
    self.screeningTableview.delegate = self;
    self.screeningTableview.dataSource = self;
    self.screeningTableview.tableFooterView = [UIView new];
    self.screeningTableview.backgroundColor = [UIColor grayColor];
    [self.screeningTableview registerClass:[UITableViewCell class] forCellReuseIdentifier:@"tableviewcell"];
    self.screeningLayout.itemSize = CGSizeMake((WIDTH-127)/3, 35);
    self.screeningLayout.minimumLineSpacing = 30;
    self.screeningLayout.minimumInteritemSpacing = 10;
    self.screeningLayout.sectionInset = UIEdgeInsetsMake(20, 30, 20, 30);
    self.screeningResultButton.layer.masksToBounds = YES;
    self.screeningResultButton.layer.cornerRadius = kCornerRadius;
    [self.screeningCollectionView registerClass:[ScreeningFirstCollectionViewCell class] forCellWithReuseIdentifier:@"cell"];
    [self.screeningCollectionView registerClass:[ScreeningSecondCollectionReusableView class] forSupplementaryViewOfKind:UICollectionElementKindSectionHeader withReuseIdentifier:@"screeningcell"];
    self.screeningCollectionView.dataSource = self;
    self.screeningCollectionView.delegate = self;
    self.screeningCollectionView.alwaysBounceVertical = YES;
}


- (UITableViewCell *)tableView:(UITableView *)tableView cellForRowAtIndexPath:(NSIndexPath *)indexPath
{
    UITableViewCell *cell = [tableView dequeueReusableCellWithIdentifier:@"tableviewcell" forIndexPath:indexPath];
    cell.textLabel.text = [self.defaultDatasArray objectAtIndex_opple:indexPath.row][@"typename"];
    cell.textLabel.font = [UIFont systemFontOfSize:10];
    cell.selectedBackgroundView.backgroundColor = [UIColor whiteColor];
    cell.backgroundColor = [UIColor grayColor];
    cell.textLabel.textAlignment = NSTextAlignmentCenter;
    return cell;
}

- (NSInteger)tableView:(UITableView *)tableView numberOfRowsInSection:(NSInteger)section
{
    return self.defaultDatasArray.count;
}

- (CGFloat)tableView:(UITableView *)tableView heightForRowAtIndexPath:(NSIndexPath *)indexPath
{
    return 55;
}

- (void)tableView:(UITableView *)tableView didSelectRowAtIndexPath:(NSIndexPath *)indexPath
{

    if ([self.delegate respondsToSelector:@selector(tableSelectedindex:)]) {
        
        [self.delegate tableSelectedindex:indexPath.row];
    }
}

- (UICollectionViewCell *)collectionView:(UICollectionView *)collectionView cellForItemAtIndexPath:(NSIndexPath *)indexPath
{
    ScreeningFirstCollectionViewCell *cell = [collectionView dequeueReusableCellWithReuseIdentifier:@"cell" forIndexPath:indexPath];
    if (self.selectedIndex == 1) {
        
        cell.titleLabe.text = [[[[self.datasArray objectAtIndex_opple:indexPath.section] children] objectAtIndex_opple:indexPath.row] name];
    }
    else
    {
        cell.titleLabe.text = [[self.datasArray objectAtIndex_opple:indexPath.row] typename];
    }
    return cell;
}

- (NSInteger)collectionView:(UICollectionView *)collectionView numberOfItemsInSection:(NSInteger)section
{
    if (self.selectedIndex == 1) {
        
        return [[[self.datasArray objectAtIndex_opple:section] children] count];
        
    }
    return self.datasArray.count;
}



- (UICollectionReusableView *)collectionView:(UICollectionView *)collectionView viewForSupplementaryElementOfKind:(NSString *)kind atIndexPath:(NSIndexPath *)indexPath
{
    ScreeningSecondCollectionReusableView *cell = [collectionView dequeueReusableSupplementaryViewOfKind:UICollectionElementKindSectionHeader withReuseIdentifier:@"screeningcell" forIndexPath:indexPath];
    
    self.selectedIndex == 1?(cell.subTitleButton.hidden = NO):(cell.subTitleButton.hidden = YES);
    [cell.alltitleButton addTarget:self action:@selector(AllButtonClick:) forControlEvents:UIControlEventTouchUpInside];
    
    if (self.selectedIndex == 1) {
       
        NSString *subTitle = [[self.datasArray objectAtIndex_opple:indexPath.section] name];
        [cell.subTitleButton setTitle:subTitle forState:UIControlStateNormal];
    }

    return cell;
}


- (CGSize)collectionView:(UICollectionView *)collectionView layout:(UICollectionViewLayout*)collectionViewLayout referenceSizeForHeaderInSection:(NSInteger)section{

    if (self.selectedIndex == 1 && section == 0) {
        
        return CGSizeMake(self.screeningCollectionView.frame.size.width, 130);
    }
    return CGSizeMake(self.screeningCollectionView.frame.size.width, 75);
}


- (void)collectionView:(UICollectionView *)collectionView didSelectItemAtIndexPath:(NSIndexPath *)indexPath
{
    //选中后的tableview赋值，并传递typecode筛选商品
    UITableViewCell *cell = [self.screeningTableview cellForRowAtIndexPath:[NSIndexPath indexPathForRow:self.selectedIndex inSection:0]];
    
    //选中类型的文本
    NSString *selectedTitle = nil;
    //选中的key
    NSString *selectedTypecode = nil;
    if (self.selectedIndex == 1) {
        
        selectedTitle = [[[[self.datasArray objectAtIndex_opple:indexPath.section] children] objectAtIndex_opple:indexPath.row] name];
        selectedTypecode = [[[[self.datasArray objectAtIndex_opple:indexPath.section] children] objectAtIndex_opple:indexPath.row] fid];
    }
    else
    {
        selectedTitle = [[self.datasArray objectAtIndex_opple:indexPath.row] typename];
        selectedTypecode = [[self.datasArray objectAtIndex_opple:indexPath.row] typecode];
    }
    
    NSDictionary *dict = [NSDictionary dictionaryWithObjectsAndKeys:selectedTitle,@"typename",selectedTypecode,@"typecode", nil];
    [self.defaultDatasArray replaceObjectAtIndex:self.selectedIndex withObject:dict];
    cell.textLabel.text = selectedTitle;
    [self JudgeDelegateIsPerformWithPassParamater];
}


#pragma mark -区头的全部按钮点击
- (void)AllButtonClick:(UIButton *)button
{
    UITableViewCell *cell = [self.screeningTableview cellForRowAtIndexPath:[NSIndexPath indexPathForRow:self.selectedIndex inSection:0]];
    cell.textLabel.text = @"全部";
    NSDictionary *dict = [NSDictionary dictionaryWithObjectsAndKeys:button.currentTitle,@"typename", nil];
    [self.defaultDatasArray replaceObjectAtIndex:self.selectedIndex withObject:dict];
    [self JudgeDelegateIsPerformWithPassParamater];

}


#pragma mark -判断代理是否被执行，并传递复选的参数
- (void)JudgeDelegateIsPerformWithPassParamater
{
    if ([self.delegate respondsToSelector:@selector(collectionSelectedindexWithStyleCode:withCategories:withSpace:withMaterial:withPrice:)]) {
        
        //传回选中的所有条件
        [self.delegate collectionSelectedindexWithStyleCode:[self.defaultDatasArray objectAtIndex_opple:0][@"typecode"] withCategories:[self.defaultDatasArray objectAtIndex_opple:1][@"typecode"] withSpace:[self.defaultDatasArray objectAtIndex_opple:2][@"typecode"] withMaterial:[self.defaultDatasArray objectAtIndex_opple:3][@"typecode"] withPrice:[self.defaultDatasArray objectAtIndex_opple:4][@"typename"]];
    }
}


#pragma mark -筛选结果点击
- (IBAction)ScreeningResultButtonClick:(UIButton *)sender {
    
    if ([self.delegate respondsToSelector:@selector(ShowScreeningResponse)]) {
        
        [self.delegate ShowScreeningResponse];
    }
}



#pragma mark -传入满足搜索条件的个数
- (void)setTotalNumber:(NSInteger)totalNumber
{
    _totalNumber = totalNumber;
    [self.screeningResultButton setTitle:[NSString stringWithFormat:@"筛选结果共%ld件商品",totalNumber] forState:UIControlStateNormal];
     
}



















@end
