//
//  ShoppingTableViewCell.m
//  Lighting
//
//  Created by 曹云霄 on 16/4/29.
//  Copyright © 2016年 上海勾芒科技有限公司. All rights reserved.
//

#import "ShoppingTableViewCell.h"

@implementation ShoppingTableViewCell

- (void)awakeFromNib {
    [super awakeFromNib];
    // Initialization code
}


#pragma mark -赋值
- (void)setModel:(ShopcarModel *)model
{
    _model = model;
    self.selectedButton.selected = _model.isSelected;
    [self.goodsImageView sd_setImageWithURL:[NSURL URLWithString:_model.goods.pictures] placeholderImage:ReplaceImage];
    self.goodsInformationLabe.text = _model.goods.name;
    self.tagsPriceLabe.text = [_model.goods.tagPrice stringValue];
    self.clinchTextfield.text = [_model.goods.costPrice stringValue];
    self.goodsNumbersLabe.text = [NSString stringWithFormat:@"%d",_model.goodsNum];
    self.productPriceLabe.text = [_model.goods.costPrice stringValue];
    
    
    
}

#pragma mark -增加或者减少商品
- (IBAction)reduceAndaddButtonClick:(UIButton *)sender {
    
    //sender.tag == 100   减少
    //sender.tag == 101   增加
    NSLog(@"%ld",sender.tag);
    
    
    NSInteger goodsNumber = [self.goodsNumbersLabe.text integerValue];
    switch (sender.tag) {
        case 100://减少
        {
            if (goodsNumber <= 1) {
                
                //不能小于1
                return;
            }
            goodsNumber --;
            self.goodsNumbersLabe.text = [NSString stringWithFormat:@"%ld",goodsNumber];
            
        }
            break;
        case 101://增加
        {
            if (goodsNumber >= [_model.goods.number integerValue]) {
                
                //不能大于库存
                
                return;
            }
            goodsNumber ++;
            self.goodsNumbersLabe.text = [NSString stringWithFormat:@"%ld",goodsNumber];
            
        }
            break;
            
        default:
            break;
    }
    
    
    
    
}


#pragma mark -商品选中
- (IBAction)selectedButtonClick:(UIButton *)sender {
    
    if (self.returnCellblock) {
        
        self.returnCellblock(_cellindex);
    }
    sender.selected = !sender.selected;
}






- (void)setSelected:(BOOL)selected animated:(BOOL)animated {
    [super setSelected:selected animated:animated];

    // Configure the view for the selected state
}

@end
