//
//  AddressViewController.h
//  Lighting
//
//  Created by 曹云霄 on 16/5/10.
//  Copyright © 2016年 上海勾芒科技有限公司. All rights reserved.
//

#import "BaseViewController.h"
#import "AddressModel.h"


@protocol delecteDelegate <NSObject>

//删除地址
- (void)delecteCell:(NSString *)addressid;

//增加地址
- (void)addAddressCell:(AddressModel *)model;

@end

@interface AddressViewController : BaseViewController



/**
 *  关闭按钮
 */
@property (weak, nonatomic) IBOutlet UIButton *turnoffButton;

/**
 *  title
 */
@property (weak, nonatomic) IBOutlet UILabel *changAddressLabe;


/**
 *  收件人
 */
@property (weak, nonatomic) IBOutlet UITextField *recipientPerson;


/**
 *  手机号
 */
@property (weak, nonatomic) IBOutlet UITextField *PhoneNumber;




/**
 *  地址选择(城市选择器)
 */
@property (weak, nonatomic) IBOutlet UIButton *citySelected;


/**
 *  详细地址
 */
@property (weak, nonatomic) IBOutlet UITextField *detailsAddress;

/**
 *  删除按钮(取消按钮)
 */

@property (weak, nonatomic) IBOutlet UIButton *delectAddressButton;

/**
 *  修改按钮(新增按钮)
 */
@property (weak, nonatomic) IBOutlet UIButton *modifyButton;


/**
 *  弹出框View
 */
@property (weak, nonatomic) IBOutlet UIView *popupView;



/**
 *  收货人
 */
@property (weak, nonatomic) IBOutlet UIView *recipientUserBackview;


/**
 *  手机号
 */
@property (weak, nonatomic) IBOutlet UIView *phoneNumberBackview;


/**
 *  详细地址
 */
@property (weak, nonatomic) IBOutlet UIView *detailsAddressBackview;




/**
 *  地址数据源model
 */
@property (nonatomic,strong) AddressModel *model;




/**
 *  是否为修改地址
 */
@property (nonatomic,assign) BOOL isChange;


/**
 *  删除代理
 */
@property (nonatomic,assign) id<delecteDelegate> delegate;















@end
