//
//  CustomerOrderViewController.m
//  Lighting
//
//  Created by 曹云霄 on 16/5/6.
//  Copyright © 2016年 上海勾芒科技有限公司. All rights reserved.
//

#import "CustomerOrderViewController.h"
#import "CustomerOrderTableViewCell.h"

@interface CustomerOrderViewController ()<UITableViewDataSource,UITableViewDelegate>

@end

@implementation CustomerOrderViewController

- (void)viewDidLoad {
    [super viewDidLoad];
    // Do any additional setup after loading the view.
    [self uiConfigAction];
    [self getGuideAllcustomerOrder];
}


#pragma mark -UI
- (void)uiConfigAction
{
    self.customerOrderTableView.dataSource = self;
    self.customerOrderTableView.delegate = self;
    
    self.StyleButton = [screeningButton buttonWithType:UIButtonTypeCustom];
    self.StyleButton.frame = CGRectMake(ScreenWidth-250, 20, 150, 30);
    self.StyleButton.backgroundColor = kTCColor(131, 131, 131);
    [self.StyleButton setTitle:@"订单状态" forState:UIControlStateNormal];
    [self.StyleButton addTarget:self action:@selector(screeningStyleButtonClick:) forControlEvents:UIControlEventTouchUpInside];
    [self.StyleButton setImage:TCImage(@"down_arr") forState:UIControlStateNormal];
    self.StyleButton.layer.masksToBounds = YES;
    self.StyleButton.layer.cornerRadius = 10;
    [self.orderStateBackView addSubview:self.StyleButton];
}


#pragma mark -获取导购下客户订单
- (void)getGuideAllcustomerOrder
{
    OrderBill *allOrder = [[OrderBill alloc]init];
    //分页
    DataPage *page = [[DataPage alloc]init];
    page = 0;
    //订单
    TOOrderEntity *order = [[TOOrderEntity alloc]init];
    order.guideId = [Shoppersmanager manager].guideid;
    allOrder.datapage = page;
    allOrder.order = order;
    
    [[NetworkRequestClassManager Manager] NetworkRequestWithURL:[NSString stringWithFormat:@"%@%@",ServerAddress,@"/order/query"] WithRequestType:0 WithParameter:allOrder WithReturnValueBlock:^(id returnValue) {
        
        if ([returnValue[@"code"] isEqualToNumber:@0]) {
            
            NSLog(@"%@",returnValue);
            
        }else
        {
            [self ErrorMBProgressView:returnValue[@"message"]];
        }
        
    } WithErrorCodeBlock:^(id errorCodeValue) {
        
    } WithFailureBlock:^(id error) {
        
        NSLog(@"%@",error);
        
    }];
}







#pragma mark -订单状态筛选
- (void)screeningStyleButtonClick:(UIButton *)button
{
    
}

- (UITableViewCell *)tableView:(UITableView *)tableView cellForRowAtIndexPath:(NSIndexPath *)indexPath
{
    CustomerOrderTableViewCell *cell = [tableView dequeueReusableCellWithIdentifier:@"customerordercell" forIndexPath:indexPath];
    cell.backgroundColor = [UIColor clearColor];
    cell.cellBackView.layer.masksToBounds = YES;
    cell.cellBackView.layer.cornerRadius = kCornerRadius;
    return cell;
}

- (NSInteger)tableView:(UITableView *)tableView numberOfRowsInSection:(NSInteger)section
{
    return 10;
}

- (CGFloat)tableView:(UITableView *)tableView heightForRowAtIndexPath:(NSIndexPath *)indexPath
{
    return 260;
}




- (void)didReceiveMemoryWarning {
    [super didReceiveMemoryWarning];
    // Dispose of any resources that can be recreated.
}

/*
#pragma mark - Navigation

// In a storyboard-based application, you will often want to do a little preparation before navigation
- (void)prepareForSegue:(UIStoryboardSegue *)segue sender:(id)sender {
    // Get the new view controller using [segue destinationViewController].
    // Pass the selected object to the new view controller.
}
*/

@end
