//
//  CustomerOrderTableViewCell.m
//  Lighting
//
//  Created by 曹云霄 on 16/5/6.
//  Copyright © 2016年 上海勾芒科技有限公司. All rights reserved.
//

#import "CustomerOrderTableViewCell.h"

@implementation CustomerOrderTableViewCell

- (void)awakeFromNib {
    [super awakeFromNib];
    // Initialization code
    
    [self uiConfigAction];
}

#pragma mark -UI
- (void)uiConfigAction
{
    self.delecteOrder.layer.masksToBounds = YES;
    self.delecteOrder.layer.cornerRadius = kCornerRadius;
    self.gotoPayButton.layer.masksToBounds = YES;
    self.gotoPayButton.layer.cornerRadius = kCornerRadius;
    self.cellBackView.layer.masksToBounds = YES;
    self.cellBackView.layer.cornerRadius = kCornerRadius;
    
    [self.consigneeNumber mas_makeConstraints:^(MASConstraintMaker *make) {
        
        make.right.equalTo(self.orderAll.mas_right).offset(14);
        make.top.equalTo(self.orderAll.mas_bottom).offset(10);
    }];
    
}

#pragma mark -赋值
- (void)setModel:(OrderBill *)model
{
    _model = model;
    self.orderDate.text = _model.order.createDate;
    self.orderSerialNumber.text = _model.order.orderNumber;
    self.shoppersName.text = _model.employee.realName;
    self.customerName.text = _model.consumer.name;
    [self.customerHeader sd_setImageWithURL:[NSURL URLWithString:_model.consumer.picture] placeholderImage:ReplaceImage];
    self.orderStatus.text = _model.order.orderState;
    self.consigneeName.text = _model.order.receiverName;
    self.consigneePhoneNumber.text = _model.order.receiverMobile;
    self.phoneNumber.text = _model.consumer.mobile;
    self.consigneeAddress.text = _model.order.receiverAddress;
    
    CGFloat goodsAllprice = 0;
    NSInteger goodsAllnum = 0;
    for (TOOrderdetailEntity *goodslist in _model.orderdetailList) {
        goodsAllprice += [goodslist.goodsTotalPrice floatValue];
        goodsAllnum += [goodslist.goodsNum integerValue];
        
    }
    self.orderTotalPrice.text = [NSString stringWithFormat:@"￥%.2f",goodsAllprice];
    
    self.styleNumber.text = [NSString stringWithFormat:@"%ld",goodsAllnum];
    
    //撤销订单、去支付
    if ([_model.order.orderState isEqualToString:@"001"]) {
        self.delecteOrder.hidden = NO;
        self.gotoPayButton.hidden = NO;

    }else
    {
        self.delecteOrder.hidden = YES;
        self.gotoPayButton.hidden = YES;
    }
    //订单状态图片
    self.orderStateImageView.image = [BaseViewController ReturnOrderStateImageWithStateCode:[_model.order.orderState integerValue]];
    
    //订单状态文本
    self.orderStatus.text = [BaseViewController ReturnOrderStateTitleWithStateCode:[_model.order.orderState integerValue] withPoint:CGPointMake(self.orderStatus.frame.origin.x, self.orderStatus.frame.origin.y) WithCode:0];
    self.orderStatus.textColor = [BaseViewController ReturnOrderStateTitleWithStateCode:[_model.order.orderState integerValue] withPoint:CGPointMake(self.orderStatus.frame.origin.x, self.orderStatus.frame.origin.y) WithCode:1];
    
}

#pragma mark -时间转换NSDate转NSString
- (NSString*)dateAsString:(NSDate*)date {
    
    NSDateFormatter *formatter=[[NSDateFormatter alloc] init];
    [formatter setDateFormat:@"yyyy-MM-dd"];
    NSString * timeString = [formatter stringFromDate:date];
    return timeString;
    
}


#pragma mark -撤销订单
- (IBAction)delecteOrderButtonClick:(UIButton *)sender {
    
    if ([self.delegate respondsToSelector:@selector(undoOrderButtonClick:)]) {
        
        [self.delegate undoOrderButtonClick:_cellIndex];
    }
}



#pragma mark -去支付
- (IBAction)GotoPayButtonClick:(UIButton *)sender {
    
    if ([self.delegate respondsToSelector:@selector(TopayButtonClick:)]) {
        [self.delegate TopayButtonClick:_cellIndex];
    }
}



- (void)setSelected:(BOOL)selected animated:(BOOL)animated {
    [super setSelected:selected animated:animated];

    // Configure the view for the selected state
}

@end
